/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.accountpicker;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.tooling.preview.PreviewParameterProvider;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.exception.AccountNoneEligibleForPaymentMethodError;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerState;
import com.stripe.android.financialconnections.features.common.MerchantDataAccessModel;
import com.stripe.android.financialconnections.model.Bullet;
import com.stripe.android.financialconnections.model.ConnectedAccessNotice;
import com.stripe.android.financialconnections.model.DataAccessNotice;
import com.stripe.android.financialconnections.model.DataAccessNoticeBody;
import com.stripe.android.financialconnections.model.FinancialConnectionsAccount;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.model.Image;
import com.stripe.android.financialconnections.model.PartnerAccount;
import com.stripe.android.financialconnections.presentation.Async;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0002H\u0002J\b\u0010\u0014\u001a\u00020\u0002H\u0002J\b\u0010\u0015\u001a\u00020\u0002H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerPreviewParameterProvider;", "Landroidx/compose/ui/tooling/preview/PreviewParameterProvider;", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;", "()V", "count", "", "getCount", "()I", "values", "Lkotlin/sequences/Sequence;", "getValues", "()Lkotlin/sequences/Sequence;", "accessibleCallout", "Lcom/stripe/android/financialconnections/features/common/MerchantDataAccessModel;", "bullets", "", "Lcom/stripe/android/financialconnections/model/Bullet;", "dataAccessNotice", "Lcom/stripe/android/financialconnections/model/DataAccessNotice;", "error", "loading", "multiSelect", "partnerAccountList", "Lcom/stripe/android/financialconnections/model/PartnerAccount;", "singleSelect", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class AccountPickerPreviewParameterProvider
implements PreviewParameterProvider<AccountPickerState> {
    @NotNull
    private final Sequence<AccountPickerState> values;
    public static final int $stable = 8;

    public AccountPickerPreviewParameterProvider() {
        Object[] objectArray = new AccountPickerState[]{this.loading(), this.error(), this.multiSelect(), this.singleSelect()};
        this.values = SequencesKt.sequenceOf((Object[])objectArray);
    }

    @NotNull
    public Sequence<AccountPickerState> getValues() {
        return this.values;
    }

    public int getCount() {
        return super.getCount();
    }

    private final AccountPickerState loading() {
        return new AccountPickerState(null, new Async.Loading(null, 1, null), false, null, SetsKt.emptySet(), null, 45, null);
    }

    private final AccountPickerState error() {
        return new AccountPickerState(null, new Async.Fail((Throwable)((Object)new AccountNoneEligibleForPaymentMethodError(1, new FinancialConnectionsInstitution(false, "2", false, "Institution 2", null, null, null, "Institution 2 url"), "Merchant name", (StripeException)new APIException(null, null, 0, null, null, 31, null)))), false, null, SetsKt.emptySet(), null, 45, null);
    }

    private final AccountPickerState multiSelect() {
        Object[] objectArray = new Image("");
        Async.Success<FinancialConnectionsInstitution> success = new Async.Success<FinancialConnectionsInstitution>(new FinancialConnectionsInstitution(false, "1", false, "Institution 1", (Image)objectArray, null, null, "Institution 1 url"));
        objectArray = new String[]{"id1", "id3"};
        return new AccountPickerState(success, new Async.Success<AccountPickerState.Payload>(new AccountPickerState.Payload(false, this.partnerAccountList(), this.dataAccessNotice(), AccountPickerState.SelectionMode.Multiple, this.accessibleCallout(), false, false, "Random business", false)), false, null, SetsKt.setOf((Object[])objectArray), null, 44, null);
    }

    private final AccountPickerState singleSelect() {
        Image image = new Image("");
        return new AccountPickerState(new Async.Success<FinancialConnectionsInstitution>(new FinancialConnectionsInstitution(false, "1", false, "Institution 1", image, null, null, "Institution 1 url")), new Async.Success<AccountPickerState.Payload>(new AccountPickerState.Payload(false, this.partnerAccountList(), this.dataAccessNotice(), AccountPickerState.SelectionMode.Single, this.accessibleCallout(), true, false, "Random business", false)), false, null, SetsKt.setOf((Object)"id1"), null, 44, null);
    }

    private final DataAccessNotice dataAccessNotice() {
        Image image = new Image("https://www.cdn.stripe.com/12321312321.png");
        DataAccessNoticeBody dataAccessNoticeBody = new DataAccessNoticeBody(this.bullets());
        ConnectedAccessNotice connectedAccessNotice = new ConnectedAccessNotice("Connected account placeholder", new DataAccessNoticeBody(this.bullets()));
        return new DataAccessNotice(image, "Goldilocks uses Stripe to link your accounts", "Goldilocks will use your account and routing number, balances and transactions:", dataAccessNoticeBody, connectedAccessNotice, "Learn more about data access", "OK");
    }

    private final List<Bullet> bullets() {
        Object[] objectArray = new Bullet[2];
        Image image = new Image("https://www.cdn.stripe.com/12321312321.png");
        objectArray[0] = new Bullet("Account number, routing number, account type, account nickname.", image, "Account details");
        image = new Image("https://www.cdn.stripe.com/12321312321.png");
        objectArray[1] = new Bullet("Account number, routing number, account type, account nickname.", image, "Account details");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<PartnerAccount> partnerAccountList() {
        Object[] objectArray = new PartnerAccount[5];
        FinancialConnectionsAccount.Category category = FinancialConnectionsAccount.Category.CASH;
        FinancialConnectionsAccount.Subcategory subcategory = FinancialConnectionsAccount.Subcategory.CHECKING;
        List list = CollectionsKt.emptyList();
        objectArray[0] = new PartnerAccount("Authorization", category, "id1", "With balance", subcategory, list, 1000, "$", null, "1234", null, null, true, "", null, null, null, null, null, 511232, null);
        category = FinancialConnectionsAccount.Category.CASH;
        subcategory = FinancialConnectionsAccount.Subcategory.SAVINGS;
        list = CollectionsKt.emptyList();
        objectArray[1] = new PartnerAccount("Authorization", category, "id2", "With balance disabled", subcategory, list, 1000, null, null, null, null, null, false, "Cannot be selected", null, null, null, null, null, 511872, null);
        category = FinancialConnectionsAccount.Category.CASH;
        subcategory = FinancialConnectionsAccount.Subcategory.CREDIT_CARD;
        list = CollectionsKt.emptyList();
        objectArray[2] = new PartnerAccount("Authorization", category, "id3", "No balance", subcategory, list, null, null, null, "1234", null, null, true, "Cannot be selected", null, null, null, null, null, 511424, null);
        category = FinancialConnectionsAccount.Category.CASH;
        subcategory = FinancialConnectionsAccount.Subcategory.CHECKING;
        list = CollectionsKt.emptyList();
        objectArray[3] = new PartnerAccount("Authorization", category, "id4", "No balance disabled", subcategory, list, null, null, null, "1234", null, null, false, "Cannot be selected", null, null, null, null, null, 511424, null);
        category = FinancialConnectionsAccount.Category.CASH;
        subcategory = FinancialConnectionsAccount.Subcategory.CHECKING;
        list = CollectionsKt.emptyList();
        objectArray[4] = new PartnerAccount("Authorization", category, "id5", "Very long institution that is already linked", subcategory, list, null, null, null, "1234", null, null, true, null, null, null, "linkedAccountId", null, null, 454080, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final MerchantDataAccessModel accessibleCallout() {
        FinancialConnectionsAccount.Permissions[] permissionsArray = new FinancialConnectionsAccount.Permissions[]{FinancialConnectionsAccount.Permissions.PAYMENT_METHOD, FinancialConnectionsAccount.Permissions.BALANCES, FinancialConnectionsAccount.Permissions.OWNERSHIP, FinancialConnectionsAccount.Permissions.TRANSACTIONS};
        return new MerchantDataAccessModel("My business", CollectionsKt.listOf((Object[])permissionsArray), false);
    }
}

