/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.accountpicker;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import com.stripe.android.core.Logger;
import com.stripe.android.financialconnections.FinancialConnections;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsEvent;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTrackerKt;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsEvent;
import com.stripe.android.financialconnections.di.FinancialConnectionsSheetNativeComponent;
import com.stripe.android.financialconnections.domain.GetCachedAccountsKt;
import com.stripe.android.financialconnections.domain.GetCachedConsumerSession;
import com.stripe.android.financialconnections.domain.GetOrFetchSync;
import com.stripe.android.financialconnections.domain.NativeAuthFlowCoordinator;
import com.stripe.android.financialconnections.domain.PollAuthorizationSessionAccounts;
import com.stripe.android.financialconnections.domain.SaveAccountToLink;
import com.stripe.android.financialconnections.domain.SelectAccounts;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerClickableText;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerState;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerViewModel;
import com.stripe.android.financialconnections.features.common.ManifestExtensionsKt;
import com.stripe.android.financialconnections.features.common.MerchantDataAccessModel;
import com.stripe.android.financialconnections.features.notice.NoticeSheetState;
import com.stripe.android.financialconnections.features.notice.PresentSheet;
import com.stripe.android.financialconnections.model.DataAccessNotice;
import com.stripe.android.financialconnections.model.FinancialConnectionsAuthorizationSession;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.model.PartnerAccount;
import com.stripe.android.financialconnections.model.PartnerAccountsList;
import com.stripe.android.financialconnections.model.SynchronizeSessionResponse;
import com.stripe.android.financialconnections.navigation.Destination;
import com.stripe.android.financialconnections.navigation.DestinationMappersKt;
import com.stripe.android.financialconnections.navigation.NavigationManager;
import com.stripe.android.financialconnections.navigation.topappbar.TopAppBarStateUpdate;
import com.stripe.android.financialconnections.presentation.FinancialConnectionsViewModel;
import com.stripe.android.financialconnections.repository.CachedConsumerSession;
import com.stripe.android.financialconnections.ui.HandleClickableUrl;
import com.stripe.android.financialconnections.utils.MavericksExtensionsKt;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002:;Bi\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J,\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001cH\u0002J\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!J\u0006\u0010,\u001a\u00020\u001cJ\u0006\u0010-\u001a\u00020\u001cJ\b\u0010.\u001a\u00020\u001cH\u0002J\u0006\u0010/\u001a\u00020\u001cJ\u0006\u00100\u001a\u00020\u001cJ\b\u00101\u001a\u00020\u001cH\u0002J\u0006\u00102\u001a\u00020\u001cJ&\u00103\u001a\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020$H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel;", "Lcom/stripe/android/financialconnections/presentation/FinancialConnectionsViewModel;", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;", "initialState", "nativeAuthFlowCoordinator", "Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;", "eventTracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "getCachedConsumerSession", "Lcom/stripe/android/financialconnections/domain/GetCachedConsumerSession;", "saveAccountToLink", "Lcom/stripe/android/financialconnections/domain/SaveAccountToLink;", "selectAccounts", "Lcom/stripe/android/financialconnections/domain/SelectAccounts;", "getOrFetchSync", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;", "navigationManager", "Lcom/stripe/android/financialconnections/navigation/NavigationManager;", "handleClickableUrl", "Lcom/stripe/android/financialconnections/ui/HandleClickableUrl;", "logger", "Lcom/stripe/android/core/Logger;", "pollAuthorizationSessionAccounts", "Lcom/stripe/android/financialconnections/domain/PollAuthorizationSessionAccounts;", "presentSheet", "Lcom/stripe/android/financialconnections/features/notice/PresentSheet;", "(Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;Lcom/stripe/android/financialconnections/domain/GetCachedConsumerSession;Lcom/stripe/android/financialconnections/domain/SaveAccountToLink;Lcom/stripe/android/financialconnections/domain/SelectAccounts;Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;Lcom/stripe/android/financialconnections/navigation/NavigationManager;Lcom/stripe/android/financialconnections/ui/HandleClickableUrl;Lcom/stripe/android/core/Logger;Lcom/stripe/android/financialconnections/domain/PollAuthorizationSessionAccounts;Lcom/stripe/android/financialconnections/features/notice/PresentSheet;)V", "loadAccounts", "", "loadInstitution", "logAccountSelectionChanges", "idsBefore", "", "", "idsAfter", "isSingleAccount", "", "logErrors", "onAccountClicked", "account", "Lcom/stripe/android/financialconnections/model/PartnerAccount;", "onClickableTextClick", "Lkotlinx/coroutines/Job;", "uri", "onEnterDetailsManually", "onLoadAccountsAgain", "onPayloadLoaded", "onSubmit", "onViewEffectLaunched", "presentDataAccessBottomSheet", "selectAnotherBank", "submitAccounts", "selectedIds", "updateLocalCache", "isSkipAccountSelection", "updateTopAppBar", "Lcom/stripe/android/financialconnections/navigation/topappbar/TopAppBarStateUpdate;", "state", "Companion", "Factory", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class AccountPickerViewModel
extends FinancialConnectionsViewModel<AccountPickerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsAnalyticsTracker eventTracker;
    @NotNull
    private final GetCachedConsumerSession getCachedConsumerSession;
    @NotNull
    private final SaveAccountToLink saveAccountToLink;
    @NotNull
    private final SelectAccounts selectAccounts;
    @NotNull
    private final GetOrFetchSync getOrFetchSync;
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final HandleClickableUrl handleClickableUrl;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PollAuthorizationSessionAccounts pollAuthorizationSessionAccounts;
    @NotNull
    private final PresentSheet presentSheet;
    public static final int $stable = 8;
    @NotNull
    private static final FinancialConnectionsSessionManifest.Pane PANE = FinancialConnectionsSessionManifest.Pane.ACCOUNT_PICKER;

    @AssistedInject
    public AccountPickerViewModel(@Assisted @NotNull AccountPickerState initialState, @NotNull NativeAuthFlowCoordinator nativeAuthFlowCoordinator, @NotNull FinancialConnectionsAnalyticsTracker eventTracker, @NotNull GetCachedConsumerSession getCachedConsumerSession2, @NotNull SaveAccountToLink saveAccountToLink, @NotNull SelectAccounts selectAccounts2, @NotNull GetOrFetchSync getOrFetchSync, @NotNull NavigationManager navigationManager, @NotNull HandleClickableUrl handleClickableUrl, @NotNull Logger logger, @NotNull PollAuthorizationSessionAccounts pollAuthorizationSessionAccounts, @NotNull PresentSheet presentSheet) {
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)nativeAuthFlowCoordinator, (String)"nativeAuthFlowCoordinator");
        Intrinsics.checkNotNullParameter((Object)eventTracker, (String)"eventTracker");
        Intrinsics.checkNotNullParameter((Object)getCachedConsumerSession2, (String)"getCachedConsumerSession");
        Intrinsics.checkNotNullParameter((Object)saveAccountToLink, (String)"saveAccountToLink");
        Intrinsics.checkNotNullParameter((Object)selectAccounts2, (String)"selectAccounts");
        Intrinsics.checkNotNullParameter((Object)getOrFetchSync, (String)"getOrFetchSync");
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        Intrinsics.checkNotNullParameter((Object)handleClickableUrl, (String)"handleClickableUrl");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)pollAuthorizationSessionAccounts, (String)"pollAuthorizationSessionAccounts");
        Intrinsics.checkNotNullParameter((Object)presentSheet, (String)"presentSheet");
        super(initialState, nativeAuthFlowCoordinator);
        this.eventTracker = eventTracker;
        this.getCachedConsumerSession = getCachedConsumerSession2;
        this.saveAccountToLink = saveAccountToLink;
        this.selectAccounts = selectAccounts2;
        this.getOrFetchSync = getOrFetchSync;
        this.navigationManager = navigationManager;
        this.handleClickableUrl = handleClickableUrl;
        this.logger = logger;
        this.pollAuthorizationSessionAccounts = pollAuthorizationSessionAccounts;
        this.presentSheet = presentSheet;
        this.logErrors();
        this.onPayloadLoaded();
        this.loadInstitution();
        this.loadAccounts();
    }

    @Override
    @NotNull
    public TopAppBarStateUpdate updateTopAppBar(@NotNull AccountPickerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new TopAppBarStateUpdate(PANE, false, MavericksExtensionsKt.getError(state.getPayload()), null, false, 24, null);
    }

    private final void loadInstitution() {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super FinancialConnectionsInstitution>, Object>(this, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, (Continuation)this, 1, null);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        sync = (SynchronizeSessionResponse)v0;
                        manifest = sync.getManifest();
                        v1 = manifest.getActiveInstitution();
                        if (v1 == null) {
                            var4_5 = "Required value was null.";
                            throw new IllegalArgumentException(var4_5.toString());
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super FinancialConnectionsInstitution> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, loadInstitution.2.INSTANCE, 1, null);
    }

    private final void loadAccounts() {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super AccountPickerState.Payload>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            long J$0;
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        state = (AccountPickerState)this.this$0.getStateFlow().getValue();
                        this.L$0 = state;
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, (Continuation)this, 1, null);
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        state = (AccountPickerState)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        dataAccessNotice = (v1 = (sync = (SynchronizeSessionResponse)v0).getText()) != null && (v1 = v1.getConsent()) != null ? v1.getDataAccessNotice() : null;
                        manifest = sync.getManifest();
                        v2 = manifest.getActiveAuthSession();
                        if (v2 == null) {
                            var8_7 = "Required value was null.";
                            throw new IllegalArgumentException(var8_7.toString());
                        }
                        activeAuthSession = v2;
                        var8_8 = this.this$0;
                        $i$f$measureTimeMillis = false;
                        startTime$iv = System.currentTimeMillis();
                        $i$a$-measureTimeMillis-AccountPickerViewModel$loadAccounts$1$1 = false;
                        var13_17 = AccountPickerViewModel.access$getPollAuthorizationSessionAccounts$p(var8_8);
                        var14_20 = state.getCanRetry();
                        v3 = var14_20 != false;
                        this.L$0 = dataAccessNotice;
                        this.L$1 = manifest;
                        this.L$2 = activeAuthSession;
                        this.J$0 = startTime$iv;
                        this.label = 2;
                        v4 = var13_17.invoke(v3, sync, (Continuation<? super PartnerAccountsList>)this);
                        if (v4 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl48
                    }
                    case 2: {
                        $i$f$measureTimeMillis = false;
                        $i$a$-measureTimeMillis-AccountPickerViewModel$loadAccounts$1$1 = false;
                        startTime$iv = this.J$0;
                        activeAuthSession = (FinancialConnectionsAuthorizationSession)this.L$2;
                        manifest = (FinancialConnectionsSessionManifest)this.L$1;
                        dataAccessNotice = (DataAccessNotice)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl48:
                        // 2 sources

                        result$iv = (PartnerAccountsList)v4;
                        var7_24 = TuplesKt.to((Object)result$iv, (Object)Boxing.boxLong((long)(System.currentTimeMillis() - startTime$iv)));
                        partnerAccountList = (PartnerAccountsList)var7_24.component1();
                        millis = ((Number)var7_24.component2()).longValue();
                        if (((Collection)partnerAccountList.getData()).isEmpty() == false) {
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.PollAccountsSucceeded(AccountPickerViewModel.access$getPANE$cp(), activeAuthSession.getId(), millis));
                        }
                        $this$sortedBy$iv = partnerAccountList.getData();
                        $i$f$sortedBy = false;
                        accounts = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                PartnerAccount it = (PartnerAccount)a;
                                boolean bl = false;
                                boolean bl2 = !it.getAllowSelection$financial_connections_release();
                                it = (PartnerAccount)b;
                                Comparable comparable = Boolean.valueOf(bl2);
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.getAllowSelection$financial_connections_release()));
                            }
                        });
                        v5 = partnerAccountList.getSkipAccountSelection();
                        if (v5 != null) {
                            v6 = v5;
                        } else {
                            v7 = activeAuthSession.getSkipAccountSelection();
                            v6 = v7 != null ? v7 : false;
                        }
                        var12_15 = v6;
                        var13_19 /* !! */  = manifest.getSingleAccount() != false ? AccountPickerState.SelectionMode.Single : AccountPickerState.SelectionMode.Multiple;
                        v8 = manifest.isStripeDirect();
                        var14_21 = new MerchantDataAccessModel(manifest.getBusinessName(), manifest.getPermissions(), v8 != null ? v8 : false);
                        result$iv = manifest.getSingleAccount();
                        var16_26 = manifest.getSingleAccount() != false && Intrinsics.areEqual((Object)activeAuthSession.getInstitutionSkipAccountSelection(), (Object)Boxing.boxBoolean((boolean)true)) != false && accounts.size() == 1;
                        var17_27 = manifest.getBusinessName();
                        v9 = manifest.isStripeDirect();
                        var18_28 = v9 != null ? v9 : false;
                        var12_16 = new AccountPickerState.Payload(var12_15 != false, accounts, dataAccessNotice, var13_19 /* !! */ , var14_21, result$iv != false, var18_28 != false, var17_27, var16_26 != false);
                        var13_19 /* !! */  = this.this$0;
                        $i$a$-also-AccountPickerViewModel$loadAccounts$1$2 = false;
                        AccountPickerViewModel.access$getEventTracker$p((AccountPickerViewModel)var13_19 /* !! */ ).track(new FinancialConnectionsAnalyticsEvent.PaneLoaded(AccountPickerViewModel.access$getPANE$cp()));
                        return var12_16;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super AccountPickerState.Payload> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, loadAccounts.2.INSTANCE, 1, null);
    }

    private final void onPayloadLoaded() {
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)onPayloadLoaded.1.INSTANCE, (Function2)new Function2<AccountPickerState.Payload, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountPickerState.Payload payload = (AccountPickerState.Payload)this.L$0;
                        if (payload.getSkipAccountSelection()) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = payload.getSelectableAccounts();
                            AccountPickerViewModel accountPickerViewModel = this.this$0;
                            boolean $i$f$map = false;
                            void var5_11 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                PartnerAccount partnerAccount = (PartnerAccount)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getId());
                            }
                            AccountPickerViewModel.access$submitAccounts(accountPickerViewModel, CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), false, true);
                        } else if (payload.getUserSelectedSingleAccountInInstitution()) {
                            AccountPickerViewModel.access$submitAccounts(this.this$0, SetsKt.setOf((Object)((PartnerAccount)CollectionsKt.first(payload.getAccounts())).getId()), true, true);
                        } else if (payload.getSelectionMode() == AccountPickerState.SelectionMode.Single) {
                            PartnerAccount partnerAccount = (PartnerAccount)CollectionsKt.firstOrNull(payload.getSelectableAccounts());
                            Set selectedId = SetsKt.setOfNotNull((Object)(partnerAccount != null ? partnerAccount.getId() : null));
                            FinancialConnectionsSessionManifest.Pane $i$f$map = AccountPickerViewModel.access$getPANE$cp();
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsAutoSelected($i$f$map, selectedId, true));
                            AccountPickerViewModel.access$setState(this.this$0, (Function1)new Function1<AccountPickerState, AccountPickerState>((Set<String>)selectedId){
                                final /* synthetic */ Set<String> $selectedId;
                                {
                                    this.$selectedId = $selectedId;
                                    super(1);
                                }

                                @NotNull
                                public final AccountPickerState invoke(@NotNull AccountPickerState $this$setState) {
                                    Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                                    return AccountPickerState.copy$default($this$setState, null, null, false, null, this.$selectedId, null, 47, null);
                                }
                            });
                        } else if (payload.getSelectionMode() == AccountPickerState.SelectionMode.Multiple) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = payload.getSelectableAccounts();
                            boolean $i$f$map = false;
                            Iterable destination$iv$iv = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                PartnerAccount bl = (PartnerAccount)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl2 = false;
                                collection.add(it.getId());
                            }
                            Set selectedIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                            FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsAutoSelected(pane, selectedIds, false));
                            AccountPickerViewModel.access$setState(this.this$0, (Function1)new Function1<AccountPickerState, AccountPickerState>((Set<String>)selectedIds){
                                final /* synthetic */ Set<String> $selectedIds;
                                {
                                    this.$selectedIds = $selectedIds;
                                    super(1);
                                }

                                @NotNull
                                public final AccountPickerState invoke(@NotNull AccountPickerState $this$setState) {
                                    Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                                    return AccountPickerState.copy$default($this$setState, null, null, false, null, this.$selectedIds, null, 47, null);
                                }
                            });
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull AccountPickerState.Payload p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, 4, null);
    }

    private final void logErrors() {
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)logErrors.1.INSTANCE, null, (Function2)new Function2<Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        FinancialConnectionsAnalyticsTracker financialConnectionsAnalyticsTracker = AccountPickerViewModel.access$getEventTracker$p(this.this$0);
                        Logger logger = AccountPickerViewModel.access$getLogger$p(this.this$0);
                        FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                        FinancialConnectionsAnalyticsTrackerKt.logError(financialConnectionsAnalyticsTracker, "Error retrieving accounts", it, logger, pane);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Throwable p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)logErrors.3.INSTANCE, null, (Function2)new Function2<Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        FinancialConnectionsAnalyticsTracker financialConnectionsAnalyticsTracker = AccountPickerViewModel.access$getEventTracker$p(this.this$0);
                        Logger logger = AccountPickerViewModel.access$getLogger$p(this.this$0);
                        FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                        FinancialConnectionsAnalyticsTrackerKt.logError(financialConnectionsAnalyticsTracker, "Error selecting accounts", it, logger, pane);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Throwable p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public final void onAccountClicked(@NotNull PartnerAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.withState((Function1)new Function1<AccountPickerState, Unit>(this, account){
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ PartnerAccount $account;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                super(1);
            }

            public final void invoke(@NotNull AccountPickerState state) {
                block7: {
                    Unit unit;
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    AccountPickerState.Payload payload = state.getPayload().invoke();
                    if (payload != null) {
                        Set set;
                        AccountPickerState.Payload payload2 = payload;
                        PartnerAccount partnerAccount = this.$account;
                        AccountPickerViewModel accountPickerViewModel = this.this$0;
                        AccountPickerState.Payload payload3 = payload2;
                        boolean bl = false;
                        Set<String> selectedIds = state.getSelectedIds();
                        switch (onAccountClicked.WhenMappings.$EnumSwitchMapping$0[payload3.getSelectionMode().ordinal()]) {
                            case 1: {
                                set = SetsKt.setOf((Object)partnerAccount.getId());
                                break;
                            }
                            case 2: {
                                if (selectedIds.contains(partnerAccount.getId())) {
                                    set = SetsKt.minus(selectedIds, (Object)partnerAccount.getId());
                                    break;
                                }
                                set = SetsKt.plus(selectedIds, (Object)partnerAccount.getId());
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Set newSelectedIds = set;
                        AccountPickerViewModel.access$setState(accountPickerViewModel, (Function1)new Function1<AccountPickerState, AccountPickerState>((Set<String>)newSelectedIds){
                            final /* synthetic */ Set<String> $newSelectedIds;
                            {
                                this.$newSelectedIds = $newSelectedIds;
                                super(1);
                            }

                            @NotNull
                            public final AccountPickerState invoke(@NotNull AccountPickerState $this$setState) {
                                Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                                return AccountPickerState.copy$default($this$setState, null, null, false, null, this.$newSelectedIds, null, 47, null);
                            }
                        });
                        AccountPickerViewModel.access$logAccountSelectionChanges(accountPickerViewModel, selectedIds, newSelectedIds, payload3.getSingleAccount());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block7;
                    AccountPickerViewModel $this$invoke_u24lambda_u241 = this.this$0;
                    boolean bl = false;
                    Logger.DefaultImpls.error$default((Logger)AccountPickerViewModel.access$getLogger$p($this$invoke_u24lambda_u241), (String)"account clicked without available payload.", null, (int)2, null);
                }
            }
        });
    }

    private final void logAccountSelectionChanges(Set<String> idsBefore, Set<String> idsAfter, boolean isSingleAccount) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(idsAfter, idsBefore, this, isSingleAccount, null){
            int label;
            final /* synthetic */ Set<String> $idsAfter;
            final /* synthetic */ Set<String> $idsBefore;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ boolean $isSingleAccount;
            {
                this.$idsAfter = $idsAfter;
                this.$idsBefore = $idsBefore;
                this.this$0 = $receiver;
                this.$isSingleAccount = $isSingleAccount;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string2;
                        FinancialConnectionsSessionManifest.Pane pane;
                        ResultKt.throwOnFailure((Object)object);
                        Set newIds = SetsKt.minus(this.$idsAfter, (Iterable)this.$idsBefore);
                        Set removedIds = SetsKt.minus(this.$idsBefore, (Iterable)this.$idsAfter);
                        if (newIds.size() == 1) {
                            pane = AccountPickerViewModel.access$getPANE$cp();
                            string2 = (String)CollectionsKt.first((Iterable)newIds);
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountSelected(pane, true, this.$isSingleAccount, string2));
                        }
                        if (removedIds.size() == 1) {
                            pane = AccountPickerViewModel.access$getPANE$cp();
                            string2 = (String)CollectionsKt.first((Iterable)removedIds);
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountSelected(pane, false, this.$isSingleAccount, string2));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onSubmit() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.ClickLinkAccounts(AccountPickerViewModel.access$getPANE$cp()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        FinancialConnections.emitEvent-gIAlu-s$financial_connections_release$default(FinancialConnections.INSTANCE, FinancialConnectionsEvent.Name.ACCOUNTS_SELECTED, null, 2, null);
        this.withState((Function1)new Function1<AccountPickerState, Unit>(this){
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AccountPickerState state) {
                block2: {
                    Unit unit;
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    AccountPickerState.Payload payload = state.getPayload().invoke();
                    if (payload != null) {
                        AccountPickerState.Payload payload2 = payload;
                        AccountPickerViewModel accountPickerViewModel = this.this$0;
                        AccountPickerState.Payload it = payload2;
                        boolean bl = false;
                        AccountPickerViewModel.access$submitAccounts(accountPickerViewModel, state.getSelectedIds(), true, false);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block2;
                    AccountPickerViewModel $this$invoke_u24lambda_u241 = this.this$0;
                    boolean bl = false;
                    Logger.DefaultImpls.error$default((Logger)AccountPickerViewModel.access$getLogger$p($this$invoke_u24lambda_u241), (String)"account clicked without available payload.", null, (int)2, null);
                }
            }
        });
    }

    private final void submitAccounts(Set<String> selectedIds, boolean updateLocalCache, boolean isSkipAccountSelection) {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super PartnerAccountsList>, Object>(this, selectedIds, isSkipAccountSelection, updateLocalCache, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ Set<String> $selectedIds;
            final /* synthetic */ boolean $isSkipAccountSelection;
            final /* synthetic */ boolean $updateLocalCache;
            {
                this.this$0 = $receiver;
                this.$selectedIds = $selectedIds;
                this.$isSkipAccountSelection = $isSkipAccountSelection;
                this.$updateLocalCache = $updateLocalCache;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = AccountPickerViewModel.access$getPANE$cp();
                        AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsSubmitted(var2_3, this.$selectedIds, this.$isSkipAccountSelection));
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, (Continuation)this, 1, null);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        manifest = ((SynchronizeSessionResponse)v0).getManifest();
                        v1 = manifest.getActiveAuthSession();
                        if (v1 == null) {
                            var5_4 = "Required value was null.";
                            throw new IllegalArgumentException(var5_4.toString());
                        }
                        this.L$0 = manifest;
                        this.label = 2;
                        v2 = AccountPickerViewModel.access$getSelectAccounts$p(this.this$0).invoke(this.$selectedIds, v1.getId(), this.$updateLocalCache, (Continuation<? super PartnerAccountsList>)((Continuation)this));
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        manifest = (FinancialConnectionsSessionManifest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl30:
                        // 2 sources

                        accountsList = (PartnerAccountsList)v2;
                        this.L$0 = manifest;
                        this.L$1 = accountsList;
                        this.label = 3;
                        v3 = AccountPickerViewModel.access$getGetCachedConsumerSession$p(this.this$0).invoke((Continuation<? super CachedConsumerSession>)((Continuation)this));
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl43
                    }
                    case 3: {
                        accountsList = (PartnerAccountsList)this.L$1;
                        manifest = (FinancialConnectionsSessionManifest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl43:
                        // 2 sources

                        v4 = (CachedConsumerSession)v3;
                        v5 = consumerSessionClientSecret = v4 != null ? v4.getClientSecret() : null;
                        if (ManifestExtensionsKt.isDataFlow(manifest) && ManifestExtensionsKt.getCanSaveAccountsToLink(manifest) && consumerSessionClientSecret != null) {
                            this.L$0 = accountsList;
                            this.L$1 = null;
                            this.label = 4;
                            v6 = AccountPickerViewModel.access$getSaveAccountToLink$p(this.this$0).existing(consumerSessionClientSecret, GetCachedAccountsKt.toCachedPartnerAccounts(accountsList.getData()), ManifestExtensionsKt.isDataFlow(manifest), (Continuation<? super FinancialConnectionsSessionManifest>)((Continuation)this));
                            if (v6 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl57
                    }
                    case 4: {
                        accountsList = (PartnerAccountsList)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl57:
                        // 2 sources

                        NavigationManager.DefaultImpls.tryNavigateTo$default(AccountPickerViewModel.access$getNavigationManager$p(this.this$0), Destination.invoke$default(DestinationMappersKt.getDestination(accountsList.getNextPane()), AccountPickerViewModel.access$getPANE$cp(), null, 2, null), null, false, 6, null);
                        return accountsList;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super PartnerAccountsList> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, submitAccounts.2.INSTANCE, 1, null);
    }

    public final void selectAnotherBank() {
        NavigationManager.DefaultImpls.tryNavigateTo$default(this.navigationManager, Destination.invoke$default(Destination.Reset.INSTANCE, PANE, null, 2, null), null, false, 6, null);
    }

    public final void onEnterDetailsManually() {
        NavigationManager.DefaultImpls.tryNavigateTo$default(this.navigationManager, Destination.invoke$default(Destination.ManualEntry.INSTANCE, PANE, null, 2, null), null, false, 6, null);
    }

    public final void onLoadAccountsAgain() {
        this.setState(onLoadAccountsAgain.1.INSTANCE);
        this.loadAccounts();
    }

    @NotNull
    public final Job onClickableTextClick(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ String $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Date date = new Date();
                        this.label = 1;
                        Object object3 = AccountPickerViewModel.access$getHandleClickableUrl$p(this.this$0).invoke(AccountPickerViewModel.access$getPANE$cp(), this.$uri, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0, this.$uri, date){
                            final /* synthetic */ AccountPickerViewModel this$0;
                            final /* synthetic */ String $uri;
                            final /* synthetic */ Date $date;
                            {
                                this.this$0 = $receiver;
                                this.$uri = $uri;
                                this.$date = $date;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                AccountPickerViewModel.access$setState(this.this$0, (Function1)new Function1<AccountPickerState, AccountPickerState>(this.$uri, this.$date){
                                    final /* synthetic */ String $uri;
                                    final /* synthetic */ Date $date;
                                    {
                                        this.$uri = $uri;
                                        this.$date = $date;
                                        super(1);
                                    }

                                    @NotNull
                                    public final AccountPickerState invoke(@NotNull AccountPickerState $this$setState) {
                                        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                                        return AccountPickerState.copy$default($this$setState, null, null, false, null, null, new AccountPickerState.ViewEffect.OpenUrl(this.$uri, this.$date.getTime()), 31, null);
                                    }
                                });
                            }
                        }), MapsKt.mapOf((Pair)TuplesKt.to((Object)AccountPickerClickableText.DATA.getValue(), (Object)new Function2<HandleClickableUrl.DeeplinkPayload, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccountPickerViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AccountPickerViewModel.access$presentDataAccessBottomSheet(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull HandleClickableUrl.DeeplinkPayload p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void presentDataAccessBottomSheet() {
        Object object = ((AccountPickerState)this.getStateFlow().getValue()).getPayload().invoke();
        if (object == null || (object = ((AccountPickerState.Payload)object).getDataAccessNotice()) == null) {
            return;
        }
        Object dataAccessNotice = object;
        this.eventTracker.track(new FinancialConnectionsAnalyticsEvent.ClickLearnMoreDataAccess(PANE));
        this.presentSheet.invoke(new NoticeSheetState.NoticeSheetContent.DataAccess((DataAccessNotice)dataAccessNotice), PANE);
    }

    public final void onViewEffectLaunched() {
        this.setState(onViewEffectLaunched.1.INSTANCE);
    }

    public static final /* synthetic */ GetOrFetchSync access$getGetOrFetchSync$p(AccountPickerViewModel $this) {
        return $this.getOrFetchSync;
    }

    public static final /* synthetic */ FinancialConnectionsAnalyticsTracker access$getEventTracker$p(AccountPickerViewModel $this) {
        return $this.eventTracker;
    }

    public static final /* synthetic */ FinancialConnectionsSessionManifest.Pane access$getPANE$cp() {
        return PANE;
    }

    public static final /* synthetic */ PollAuthorizationSessionAccounts access$getPollAuthorizationSessionAccounts$p(AccountPickerViewModel $this) {
        return $this.pollAuthorizationSessionAccounts;
    }

    public static final /* synthetic */ void access$submitAccounts(AccountPickerViewModel $this, Set selectedIds, boolean updateLocalCache, boolean isSkipAccountSelection) {
        $this.submitAccounts(selectedIds, updateLocalCache, isSkipAccountSelection);
    }

    public static final /* synthetic */ void access$setState(AccountPickerViewModel $this, Function1 reducer) {
        $this.setState(reducer);
    }

    public static final /* synthetic */ Logger access$getLogger$p(AccountPickerViewModel $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$logAccountSelectionChanges(AccountPickerViewModel $this, Set idsBefore, Set idsAfter, boolean isSingleAccount) {
        $this.logAccountSelectionChanges(idsBefore, idsAfter, isSingleAccount);
    }

    public static final /* synthetic */ SelectAccounts access$getSelectAccounts$p(AccountPickerViewModel $this) {
        return $this.selectAccounts;
    }

    public static final /* synthetic */ GetCachedConsumerSession access$getGetCachedConsumerSession$p(AccountPickerViewModel $this) {
        return $this.getCachedConsumerSession;
    }

    public static final /* synthetic */ SaveAccountToLink access$getSaveAccountToLink$p(AccountPickerViewModel $this) {
        return $this.saveAccountToLink;
    }

    public static final /* synthetic */ NavigationManager access$getNavigationManager$p(AccountPickerViewModel $this) {
        return $this.navigationManager;
    }

    public static final /* synthetic */ HandleClickableUrl access$getHandleClickableUrl$p(AccountPickerViewModel $this) {
        return $this.handleClickableUrl;
    }

    public static final /* synthetic */ void access$presentDataAccessBottomSheet(AccountPickerViewModel $this) {
        $this.presentDataAccessBottomSheet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion;", "", "()V", "PANE", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "parentComponent", "Lcom/stripe/android/financialconnections/di/FinancialConnectionsSheetNativeComponent;", "financial-connections_release"})
    @SourceDebugExtension(value={"SMAP\nAccountPickerViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion\n+ 2 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,439:1\n31#2:440\n63#2,2:441\n*S KotlinDebug\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion\n*L\n380#1:440\n381#1:441,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ViewModelProvider.Factory factory(@NotNull FinancialConnectionsSheetNativeComponent parentComponent) {
            void $this$initializer$iv;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            boolean $i$f$viewModelFactory = false;
            InitializerViewModelFactoryBuilder $this$factory_u24lambda_u240 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
            boolean bl = false;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$factory_u24lambda_u240;
            Function1 initializer$iv = (Function1)new Function1<CreationExtras, AccountPickerViewModel>(parentComponent){
                final /* synthetic */ FinancialConnectionsSheetNativeComponent $parentComponent;
                {
                    this.$parentComponent = $parentComponent;
                    super(1);
                }

                @NotNull
                public final AccountPickerViewModel invoke(@NotNull CreationExtras $this$initializer) {
                    Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
                    return this.$parentComponent.getAccountPickerViewModelFactory().create(new AccountPickerState(null, null, false, null, null, null, 63, null));
                }
            };
            boolean $i$f$initializer = false;
            $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(AccountPickerViewModel.class), initializer$iv);
            return initializerViewModelFactoryBuilder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @AssistedFactory
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Factory;", "", "create", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel;", "initialState", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;", "financial-connections_release"})
    public static interface Factory {
        @NotNull
        public AccountPickerViewModel create(@NotNull AccountPickerState var1);
    }
}

