/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.manualentry;

import androidx.annotation.StringRes;
import com.stripe.android.financialconnections.R;
import com.stripe.android.financialconnections.features.manualentry.Validator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/financialconnections/features/manualentry/Validator;", "", "()V", "ACCOUNT_NUMBER_MAX_LENGTH", "", "ROUTING_NUMBER_LENGTH", "getAccountConfirmIdOrNull", "accountInput", "", "accountConfirmInput", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "getAccountErrorIdOrNull", "input", "(Ljava/lang/String;)Ljava/lang/Integer;", "getRoutingErrorIdOrNull", "isUSRoutingNumber", "", "financial-connections_release"})
@SourceDebugExtension(value={"SMAP\nManualEntryFormState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualEntryFormState.kt\ncom/stripe/android/financialconnections/features/manualentry/Validator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,84:1\n1128#2,4:85\n*S KotlinDebug\n*F\n+ 1 ManualEntryFormState.kt\ncom/stripe/android/financialconnections/features/manualentry/Validator\n*L\n72#1:85,4\n*E\n"})
final class Validator {
    @NotNull
    public static final Validator INSTANCE = new Validator();
    private static final int ROUTING_NUMBER_LENGTH = 9;
    private static final int ACCOUNT_NUMBER_MAX_LENGTH = 17;

    private Validator() {
    }

    @StringRes
    @Nullable
    public final Integer getRoutingErrorIdOrNull(@NotNull String input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        return ((CharSequence)input2).length() == 0 ? Integer.valueOf(R.string.stripe_validation_routing_required) : (input2.length() != 9 ? Integer.valueOf(R.string.stripe_validation_routing_too_short) : (!this.isUSRoutingNumber(input2) ? Integer.valueOf(R.string.stripe_validation_no_us_routing) : null));
    }

    @StringRes
    @Nullable
    public final Integer getAccountErrorIdOrNull(@NotNull String input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        return ((CharSequence)input2).length() == 0 ? Integer.valueOf(R.string.stripe_validation_account_required) : (input2.length() > 17 ? Integer.valueOf(R.string.stripe_validation_account_too_long) : null);
    }

    @StringRes
    @Nullable
    public final Integer getAccountConfirmIdOrNull(@NotNull String accountInput, @NotNull String accountConfirmInput) {
        Intrinsics.checkNotNullParameter((Object)accountInput, (String)"accountInput");
        Intrinsics.checkNotNullParameter((Object)accountConfirmInput, (String)"accountConfirmInput");
        return this.getAccountErrorIdOrNull(accountInput) == null && !Intrinsics.areEqual((Object)accountInput, (Object)accountConfirmInput) ? Integer.valueOf(R.string.stripe_validation_account_confirm_mismatch) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUSRoutingNumber(String $this$isUSRoutingNumber) {
        boolean bl;
        Function1 usRoutingFactor2 = isUSRoutingNumber.usRoutingFactor.1.INSTANCE;
        if (new Regex("^\\d{9}$").matches((CharSequence)$this$isUSRoutingNumber)) {
            void $this$foldIndexed$iv;
            CharSequence charSequence = $this$isUSRoutingNumber;
            int initial$iv = 0;
            boolean $i$f$foldIndexed = false;
            int index$iv = 0;
            int accumulator$iv = initial$iv;
            for (int i = 0; i < $this$foldIndexed$iv.length(); ++i) {
                void current;
                void sum;
                char element$iv = $this$foldIndexed$iv.charAt(i);
                int n = index$iv++;
                char c = element$iv;
                int n2 = accumulator$iv;
                int idx = n;
                boolean bl2 = false;
                accumulator$iv = sum + CharsKt.digitToInt((char)current, (int)10) * ((Number)usRoutingFactor2.invoke((Object)idx)).intValue();
            }
            int total = accumulator$iv;
            bl = total % 10 == 0;
        } else {
            bl = false;
        }
        return bl;
    }
}

