/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.navigation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.financialconnections.navigation.NavigationIntent;
import com.stripe.android.financialconnections.navigation.NavigationManager;
import com.stripe.android.financialconnections.navigation.PopUpToBehavior;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/financialconnections/navigation/NavigationManagerImpl;", "Lcom/stripe/android/financialconnections/navigation/NavigationManager;", "()V", "_navigationFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/stripe/android/financialconnections/navigation/NavigationIntent;", "navigationFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getNavigationFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "tryNavigateBack", "", "tryNavigateTo", "route", "", "popUpTo", "Lcom/stripe/android/financialconnections/navigation/PopUpToBehavior;", "isSingleTop", "", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class NavigationManagerImpl
implements NavigationManager {
    @NotNull
    private final MutableSharedFlow<NavigationIntent> _navigationFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
    @NotNull
    private final SharedFlow<NavigationIntent> navigationFlow = FlowKt.asSharedFlow(this._navigationFlow);
    public static final int $stable = 8;

    @Inject
    public NavigationManagerImpl() {
    }

    @Override
    @NotNull
    public SharedFlow<NavigationIntent> getNavigationFlow() {
        return this.navigationFlow;
    }

    @Override
    public void tryNavigateTo(@NotNull String route, @Nullable PopUpToBehavior popUpTo, boolean isSingleTop) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this._navigationFlow.tryEmit((Object)new NavigationIntent.NavigateTo(route, popUpTo, isSingleTop));
    }

    @Override
    public void tryNavigateBack() {
        this._navigationFlow.tryEmit((Object)NavigationIntent.NavigateBack.INSTANCE);
    }
}

