/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.repository;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.financialconnections.model.FinancialConnectionsAccountList;
import com.stripe.android.financialconnections.model.FinancialConnectionsSession;
import com.stripe.android.financialconnections.model.GetFinancialConnectionsAcccountsParams;
import com.stripe.android.financialconnections.model.MixedOAuthParams;
import com.stripe.android.financialconnections.model.PaymentMethod;
import com.stripe.android.financialconnections.network.FinancialConnectionsRequestExecutor;
import com.stripe.android.financialconnections.repository.FinancialConnectionsRepository;
import com.stripe.android.financialconnections.repository.api.ProvideApiRequestOptions;
import com.stripe.android.financialconnections.utils.CollectionsKt;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepositoryImpl;", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepository;", "requestExecutor", "Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;", "provideApiRequestOptions", "Lcom/stripe/android/financialconnections/repository/api/ProvideApiRequestOptions;", "apiRequestFactory", "Lcom/stripe/android/core/networking/ApiRequest$Factory;", "(Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;Lcom/stripe/android/financialconnections/repository/api/ProvideApiRequestOptions;Lcom/stripe/android/core/networking/ApiRequest$Factory;)V", "createPaymentMethod", "Lcom/stripe/android/financialconnections/model/PaymentMethod;", "paymentDetailsId", "", "consumerSessionClientSecret", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFinancialConnectionsAccounts", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsAccountList;", "getFinancialConnectionsAcccountsParams", "Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;", "(Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFinancialConnectionsSession", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSession;", "clientSecret", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postAuthorizationSessionOAuthResults", "Lcom/stripe/android/financialconnections/model/MixedOAuthParams;", "sessionId", "postCompleteFinancialConnectionsSessions", "terminalError", "Companion", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class FinancialConnectionsRepositoryImpl
implements FinancialConnectionsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsRequestExecutor requestExecutor;
    @NotNull
    private final ProvideApiRequestOptions provideApiRequestOptions;
    @NotNull
    private final ApiRequest.Factory apiRequestFactory;
    public static final int $stable = 8;
    @NotNull
    private static final String listAccountsUrl = "https://api.stripe.com/v1/link_account_sessions/list_accounts";
    @NotNull
    private static final String sessionReceiptUrl = "https://api.stripe.com/v1/link_account_sessions/session_receipt";
    @NotNull
    public static final String authorizationSessionUrl = "https://api.stripe.com/v1/connections/auth_sessions";
    @NotNull
    private static final String completeUrl = "https://api.stripe.com/v1/link_account_sessions/complete";
    @NotNull
    private static final String authorizationSessionOAuthResultsUrl = "https://api.stripe.com/v1/connections/auth_sessions/oauth_results";
    @NotNull
    public static final String authorizeSessionUrl = "https://api.stripe.com/v1/connections/auth_sessions/authorized";
    @NotNull
    private static final String paymentMethodsUrl = "https://api.stripe.com/v1/payment_methods";

    @Inject
    public FinancialConnectionsRepositoryImpl(@NotNull FinancialConnectionsRequestExecutor requestExecutor, @NotNull ProvideApiRequestOptions provideApiRequestOptions, @NotNull ApiRequest.Factory apiRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)provideApiRequestOptions, (String)"provideApiRequestOptions");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        this.requestExecutor = requestExecutor;
        this.provideApiRequestOptions = provideApiRequestOptions;
        this.apiRequestFactory = apiRequestFactory;
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsAccounts(@NotNull GetFinancialConnectionsAcccountsParams getFinancialConnectionsAcccountsParams, @NotNull Continuation<? super FinancialConnectionsAccountList> $completion) {
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createGet$default((ApiRequest.Factory)this.apiRequestFactory, (String)listAccountsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), getFinancialConnectionsAcccountsParams.toParamMap(), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsAccountList.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsSession(@NotNull String clientSecret, @NotNull Continuation<? super FinancialConnectionsSession> $completion) {
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createGet$default((ApiRequest.Factory)this.apiRequestFactory, (String)sessionReceiptUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret)), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsSession.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object postCompleteFinancialConnectionsSessions(@NotNull String clientSecret, @Nullable String terminalError, @NotNull Continuation<? super FinancialConnectionsSession> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_secret", (Object)clientSecret), TuplesKt.to((Object)"terminal_error", (Object)terminalError)};
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)completeUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(true), CollectionsKt.filterNotNullValues(MapsKt.mapOf((Pair[])pairArray)), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsSession.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object postAuthorizationSessionOAuthResults(@NotNull String clientSecret, @NotNull String sessionId, @NotNull Continuation<? super MixedOAuthParams> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)sessionId), TuplesKt.to((Object)"client_secret", (Object)clientSecret)};
        ApiRequest request = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)authorizationSessionOAuthResultsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(true), (Map)MapsKt.mapOf((Pair[])pairArray), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)request, MixedOAuthParams.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object createPaymentMethod(@NotNull String paymentDetailsId, @NotNull String consumerSessionClientSecret, @NotNull Continuation<? super PaymentMethod> $completion) {
        Map credentials = MapsKt.mapOf((Pair)TuplesKt.to((Object)"consumer_session_client_secret", (Object)consumerSessionClientSecret));
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)"link");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"credentials", (Object)credentials), TuplesKt.to((Object)"payment_details_id", (Object)paymentDetailsId)};
        pairArray[1] = TuplesKt.to((Object)"link", (Object)MapsKt.mapOf((Pair[])pairArray2));
        Map params = MapsKt.mapOf((Pair[])pairArray);
        ApiRequest request = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)paymentMethodsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), (Map)params, (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)request, PaymentMethod.Companion.serializer(), $completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepositoryImpl$Companion;", "", "()V", "authorizationSessionOAuthResultsUrl", "", "authorizationSessionUrl", "authorizeSessionUrl", "completeUrl", "listAccountsUrl", "paymentMethodsUrl", "sessionReceiptUrl", "financial-connections_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

