/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.utils;

import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.Logger;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTrackerKt;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ \u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/financialconnections/utils/UriUtils;", "", "logger", "Lcom/stripe/android/core/Logger;", "tracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "(Lcom/stripe/android/core/Logger;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;)V", "compareSchemeAuthorityAndPath", "", "uriString1", "", "uriString2", "getQueryParameter", "uri", "key", "getQueryParameterFromFragment", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toUriOrNull", "Landroid/net/Uri;", "financial-connections_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUriUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriUtils.kt\ncom/stripe/android/financialconnections/utils/UriUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 UriUtils.kt\ncom/stripe/android/financialconnections/utils/UriUtils\n*L\n55#1:81,2\n*E\n"})
public final class UriUtils {
    @NotNull
    private final Logger logger;
    @NotNull
    private final FinancialConnectionsAnalyticsTracker tracker;
    public static final int $stable = 8;

    @Inject
    public UriUtils(@NotNull Logger logger, @NotNull FinancialConnectionsAnalyticsTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.logger = logger;
        this.tracker = tracker;
    }

    public final boolean compareSchemeAuthorityAndPath(@NotNull String uriString1, @NotNull String uriString2) {
        Intrinsics.checkNotNullParameter((Object)uriString1, (String)"uriString1");
        Intrinsics.checkNotNullParameter((Object)uriString2, (String)"uriString2");
        Uri uri1 = this.toUriOrNull(uriString1);
        Uri uri2 = this.toUriOrNull(uriString2);
        if (uri1 == null || uri2 == null) {
            return false;
        }
        return StringsKt.equals$default((String)uri1.getAuthority(), (String)uri2.getAuthority(), (boolean)false, (int)2, null) && StringsKt.equals$default((String)uri1.getScheme(), (String)uri2.getScheme(), (boolean)false, (int)2, null) && StringsKt.equals$default((String)uri1.getPath(), (String)uri2.getPath(), (boolean)false, (int)2, null);
    }

    @Nullable
    public final String getQueryParameter(@NotNull String uri, @NotNull String key) {
        Object object;
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                boolean bl = false;
                Uri uri2 = this.toUriOrNull(uri);
                object = Result.constructor-impl((Object)(uri2 != null ? uri2.getQueryParameter(key) : null));
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable error = throwable = throwable3;
            boolean bl = false;
            FinancialConnectionsAnalyticsTrackerKt.logError(this.tracker, "Could not extract query param " + key + " from URI " + uri, error, this.logger, FinancialConnectionsSessionManifest.Pane.UNEXPECTED_ERROR);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object getQueryParameterFromFragment(@NotNull String uri, @NotNull String key, @NotNull Continuation<? super String> $completion) {
        Object object = this;
        try {
            Object object2;
            List list;
            String string2;
            UriUtils $this$getQueryParameterFromFragment_u24lambda_u243 = object;
            boolean bl = false;
            Uri uri2 = $this$getQueryParameterFromFragment_u24lambda_u243.toUriOrNull(uri);
            if (uri2 != null && (string2 = uri2.getFragment()) != null && (list = StringsKt.split$default((CharSequence)string2, (String[])(object2 = new String[]{"&"}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$forEach$iv;
                object2 = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String param = (String)element$iv;
                    boolean bl2 = false;
                    String[] stringArray = new String[]{"="};
                    List keyValue = StringsKt.split$default((CharSequence)param, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    if (!Intrinsics.areEqual(keyValue.get(0), (Object)key) || keyValue.size() <= 1) continue;
                    return keyValue.get(1);
                }
            }
            return null;
        }
        catch (Throwable bl) {
            block4: {
                Throwable throwable;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 == null) break block4;
                Throwable error = throwable = throwable2;
                boolean bl3 = false;
                FinancialConnectionsAnalyticsTrackerKt.logError(this.tracker, "Could not extract query param " + key + " from URI " + uri, error, this.logger, FinancialConnectionsSessionManifest.Pane.UNEXPECTED_ERROR);
            }
            return Result.isFailure-impl((Object)object) ? null : object;
        }
    }

    private final Uri toUriOrNull(String $this$toUriOrNull) {
        try {
            boolean bl = false;
            return Uri.parse((String)$this$toUriOrNull);
        }
        catch (Throwable throwable) {
            Object object;
            block2: {
                Throwable throwable2;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
                if (throwable3 == null) break block2;
                Throwable error = throwable2 = throwable3;
                boolean bl = false;
                FinancialConnectionsAnalyticsTrackerKt.logError(this.tracker, "Could not parse given URI " + $this$toUriOrNull, error, this.logger, FinancialConnectionsSessionManifest.Pane.UNEXPECTED_ERROR);
            }
            return (Uri)(Result.isFailure-impl((Object)object) ? null : object);
        }
    }
}

