/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.analytics;

import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.exception.FinancialConnectionsError;
import com.stripe.android.financialconnections.exception.WebAuthFlowFailedException;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"toEventParams", "", "", "", "extraMessage", "MAX_LOG_LENGTH", "", "financial-connections_release"})
public final class AnalyticsMappersKt {
    private static final int MAX_LOG_LENGTH = 100;

    @NotNull
    public static final Map<String, String> toEventParams(@NotNull Throwable $this$toEventParams, @Nullable String extraMessage) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)$this$toEventParams, (String)"<this>");
        Throwable throwable = $this$toEventParams;
        if (throwable instanceof WebAuthFlowFailedException) {
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"error", (Object)((WebAuthFlowFailedException)$this$toEventParams).getReason());
            pairArray[1] = TuplesKt.to((Object)"error_type", (Object)((WebAuthFlowFailedException)$this$toEventParams).getReason());
            pairArray[2] = TuplesKt.to((Object)"error_stacktrace", (Object)ExceptionsKt.stackTraceToString((Throwable)$this$toEventParams));
            Object[] objectArray = new String[]{$this$toEventParams.getMessage(), extraMessage};
            pairArray[3] = TuplesKt.to((Object)"error_message", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            pairArray[4] = TuplesKt.to((Object)"code", null);
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else if (throwable instanceof FinancialConnectionsError) {
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"error", (Object)((FinancialConnectionsError)((Object)$this$toEventParams)).getName());
            pairArray[1] = TuplesKt.to((Object)"error_type", (Object)((FinancialConnectionsError)((Object)$this$toEventParams)).getName());
            pairArray[2] = TuplesKt.to((Object)"error_stacktrace", (Object)ExceptionsKt.stackTraceToString((Throwable)$this$toEventParams));
            Object[] objectArray = new String[2];
            Object object = ((FinancialConnectionsError)((Object)$this$toEventParams)).getStripeError();
            if (object == null || (object = object.getMessage()) == null) {
                object = $this$toEventParams.getMessage();
            }
            objectArray[0] = object;
            objectArray[1] = extraMessage;
            pairArray[3] = TuplesKt.to((Object)"error_message", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            Object object2 = ((FinancialConnectionsError)((Object)$this$toEventParams)).getStripeError();
            if (object2 == null || (object2 = object2.getCode()) == null) {
                object2 = String.valueOf(((FinancialConnectionsError)((Object)$this$toEventParams)).getStatusCode());
            }
            pairArray[4] = TuplesKt.to((Object)"code", (Object)object2);
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else if (throwable instanceof StripeException) {
            Pair[] pairArray = new Pair[5];
            Object object = ((StripeException)$this$toEventParams).getStripeError();
            if (object == null || (object = object.getType()) == null) {
                object = $this$toEventParams.getClass().getSimpleName();
            }
            pairArray[0] = TuplesKt.to((Object)"error", (Object)object);
            Object object3 = ((StripeException)$this$toEventParams).getStripeError();
            if (object3 == null || (object3 = object3.getType()) == null) {
                object3 = $this$toEventParams.getClass().getSimpleName();
            }
            pairArray[1] = TuplesKt.to((Object)"error_type", (Object)object3);
            pairArray[2] = TuplesKt.to((Object)"error_stacktrace", (Object)ExceptionsKt.stackTraceToString((Throwable)$this$toEventParams));
            Object[] objectArray = new String[2];
            Object object4 = ((StripeException)$this$toEventParams).getStripeError();
            if (object4 == null || (object4 = object4.getMessage()) == null) {
                object4 = $this$toEventParams.getMessage();
            }
            objectArray[0] = object4 != null ? StringsKt.take((String)object4, (int)100) : null;
            objectArray[1] = extraMessage;
            pairArray[3] = TuplesKt.to((Object)"error_message", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            Object object5 = ((StripeException)$this$toEventParams).getStripeError();
            if (object5 == null || (object5 = object5.getCode()) == null) {
                object5 = String.valueOf(((StripeException)$this$toEventParams).getStatusCode());
            }
            pairArray[4] = TuplesKt.to((Object)"code", (Object)object5);
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else {
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"error", (Object)$this$toEventParams.getClass().getSimpleName());
            pairArray[1] = TuplesKt.to((Object)"error_type", (Object)$this$toEventParams.getClass().getSimpleName());
            pairArray[2] = TuplesKt.to((Object)"error_stacktrace", (Object)ExceptionsKt.stackTraceToString((Throwable)$this$toEventParams));
            Object[] objectArray = new String[2];
            String string2 = $this$toEventParams.getMessage();
            objectArray[0] = string2 != null ? StringsKt.take((String)string2, (int)100) : null;
            objectArray[1] = extraMessage;
            pairArray[3] = TuplesKt.to((Object)"error_message", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            pairArray[4] = TuplesKt.to((Object)"code", null);
            map2 = MapsKt.mapOf((Pair[])pairArray);
        }
        return map2;
    }
}

