/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.browser;

import android.app.Application;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u0010\u001a\u00020\u000f*\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/financialconnections/browser/BrowserManager;", "", "context", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "getContext", "()Landroid/app/Application;", "canOpenHttpsUrl", "", "getPackageToHandleUri", "", "uri", "Landroid/net/Uri;", "createBrowserIntentForUrl", "Landroid/content/Intent;", "toIntent", "getPackageToHandleIntent", "intent", "createCustomTabIntent", "financial-connections_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBrowserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserManager.kt\ncom/stripe/android/financialconnections/browser/BrowserManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class BrowserManager {
    @NotNull
    private final Application context;
    public static final int $stable = 8;

    @Inject
    public BrowserManager(@NotNull Application context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Application getContext() {
        return this.context;
    }

    public final boolean canOpenHttpsUrl() {
        Uri uri = Uri.parse((String)"https://");
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
        return this.getPackageToHandleUri(uri) != null;
    }

    @Nullable
    public final String getPackageToHandleUri(@NotNull Uri uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object object2 = this;
        try {
            BrowserManager $this$getPackageToHandleUri_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$getPackageToHandleUri_u24lambda_u240.getPackageToHandleIntent($this$getPackageToHandleUri_u24lambda_u240.toIntent(uri)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @NotNull
    public final Intent createBrowserIntentForUrl(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent browserIntent = this.toIntent(uri);
        String defaultPackage = this.getPackageToHandleIntent(browserIntent);
        String string2 = defaultPackage;
        return (string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"org.mozilla", (boolean)false, (int)2, null) : false) ? browserIntent : this.createCustomTabIntent(uri);
    }

    private final Intent toIntent(Uri $this$toIntent) {
        return new Intent("android.intent.action.VIEW", $this$toIntent);
    }

    private final String getPackageToHandleIntent(Intent intent) {
        ActivityInfo activityInfo;
        ResolveInfo resolveInfo = this.context.getPackageManager().resolveActivity(intent, 65536);
        return resolveInfo != null && (activityInfo = resolveInfo.activityInfo) != null ? activityInfo.packageName : null;
    }

    private final Intent createCustomTabIntent(Uri uri) {
        CustomTabsIntent customTabsIntent;
        CustomTabsIntent it = customTabsIntent = new CustomTabsIntent.Builder().setShareState(2).build();
        boolean bl = false;
        it.intent.setData(uri);
        Intent intent = customTabsIntent.intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        return intent;
    }
}

