/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.di;

import android.app.Application;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.financialconnections.FinancialConnectionsSheetConfiguration;
import com.stripe.android.financialconnections.di.ActivityRetainedScope;
import dagger.Module;
import dagger.Provides;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/financialconnections/di/FinancialConnectionsSheetConfigurationModule;", "", "<init>", "()V", "providesPublishableKey", "", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheetConfiguration;", "providesStripeAccountId", "providesEnableLogging", "", "providesApplicationId", "application", "Landroid/app/Application;", "providesApiVersion", "Lcom/stripe/android/core/ApiVersion;", "financial-connections_release"})
@StabilityInferred(parameters=1)
public final class FinancialConnectionsSheetConfigurationModule {
    @NotNull
    public static final FinancialConnectionsSheetConfigurationModule INSTANCE = new FinancialConnectionsSheetConfigurationModule();
    public static final int $stable;

    private FinancialConnectionsSheetConfigurationModule() {
    }

    @Provides
    @Named(value="publishableKey")
    @ActivityRetainedScope
    @NotNull
    public final String providesPublishableKey(@NotNull FinancialConnectionsSheetConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration.getPublishableKey();
    }

    @Provides
    @Named(value="stripeAccountId")
    @ActivityRetainedScope
    @Nullable
    public final String providesStripeAccountId(@NotNull FinancialConnectionsSheetConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration.getStripeAccountId();
    }

    @Provides
    @Named(value="enableLogging")
    @ActivityRetainedScope
    public final boolean providesEnableLogging() {
        return false;
    }

    @Provides
    @ActivityRetainedScope
    @Named(value="applicationId")
    @NotNull
    public final String providesApplicationId(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        String string2 = application.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        return string2;
    }

    @Provides
    @ActivityRetainedScope
    @NotNull
    public final ApiVersion providesApiVersion() {
        return new ApiVersion(SetsKt.setOf((Object)"financial_connections_client_api_beta=v1"));
    }
}

