/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.financialconnections.FinancialConnectionsSheetConfiguration;
import com.stripe.android.financialconnections.model.SynchronizeSessionResponse;
import com.stripe.android.financialconnections.repository.FinancialConnectionsManifestRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086B\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;", "", "repository", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "configuration", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheetConfiguration;", "applicationId", "", "<init>", "(Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;Lcom/stripe/android/financialconnections/FinancialConnectionsSheetConfiguration;Ljava/lang/String;)V", "getRepository", "()Lcom/stripe/android/financialconnections/repository/FinancialConnectionsManifestRepository;", "getConfiguration", "()Lcom/stripe/android/financialconnections/FinancialConnectionsSheetConfiguration;", "invoke", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "refetchCondition", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "supportsAppVerification", "", "(Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "RefetchCondition", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class GetOrFetchSync {
    @NotNull
    private final FinancialConnectionsManifestRepository repository;
    @NotNull
    private final FinancialConnectionsSheetConfiguration configuration;
    @NotNull
    private final String applicationId;
    public static final int $stable = 8;

    @Inject
    public GetOrFetchSync(@NotNull FinancialConnectionsManifestRepository repository, @NotNull FinancialConnectionsSheetConfiguration configuration, @Named(value="applicationId") @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.repository = repository;
        this.configuration = configuration;
        this.applicationId = applicationId;
    }

    @NotNull
    public final FinancialConnectionsManifestRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final FinancialConnectionsSheetConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final Object invoke(@NotNull RefetchCondition refetchCondition, boolean supportsAppVerification, @NotNull Continuation<? super SynchronizeSessionResponse> $completion) {
        FinancialConnectionsManifestRepository financialConnectionsManifestRepository = this.repository;
        String string2 = this.configuration.getFinancialConnectionsSessionClientSecret();
        String string3 = this.applicationId;
        KFunction kFunction = (KFunction)new Function1<SynchronizeSessionResponse, Boolean>((Object)refetchCondition){

            public final Boolean invoke(SynchronizeSessionResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((RefetchCondition)this.receiver).shouldReFetch(p0);
            }
        };
        return financialConnectionsManifestRepository.getOrSynchronizeFinancialConnectionsSession(string2, string3, supportsAppVerification, (Function1<? super SynchronizeSessionResponse, Boolean>)((Function1)kFunction), $completion);
    }

    public static /* synthetic */ Object invoke$default(GetOrFetchSync getOrFetchSync, RefetchCondition refetchCondition, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            refetchCondition = RefetchCondition.None.INSTANCE;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return getOrFetchSync.invoke(refetchCondition, bl, (Continuation<? super SynchronizeSessionResponse>)continuation);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "", "shouldReFetch", "", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "None", "Always", "IfMissingActiveAuthSession", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$Always;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$IfMissingActiveAuthSession;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$None;", "financial-connections_release"})
    public static interface RefetchCondition {
        public boolean shouldReFetch(@NotNull SynchronizeSessionResponse var1);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$Always;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "<init>", "()V", "shouldReFetch", "", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "equals", "other", "", "hashCode", "", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class Always
        implements RefetchCondition {
            @NotNull
            public static final Always INSTANCE = new Always();
            public static final int $stable;

            private Always() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return true;
            }

            @NotNull
            public String toString() {
                return "Always";
            }

            public int hashCode() {
                return 1484658098;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Always)) {
                    return false;
                }
                Always cfr_ignored_0 = (Always)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$IfMissingActiveAuthSession;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "<init>", "()V", "shouldReFetch", "", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "equals", "other", "", "hashCode", "", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class IfMissingActiveAuthSession
        implements RefetchCondition {
            @NotNull
            public static final IfMissingActiveAuthSession INSTANCE = new IfMissingActiveAuthSession();
            public static final int $stable;

            private IfMissingActiveAuthSession() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return response.getManifest().getActiveAuthSession() == null;
            }

            @NotNull
            public String toString() {
                return "IfMissingActiveAuthSession";
            }

            public int hashCode() {
                return 1982328450;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IfMissingActiveAuthSession)) {
                    return false;
                }
                IfMissingActiveAuthSession cfr_ignored_0 = (IfMissingActiveAuthSession)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition$None;", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync$RefetchCondition;", "<init>", "()V", "shouldReFetch", "", "response", "Lcom/stripe/android/financialconnections/model/SynchronizeSessionResponse;", "equals", "other", "", "hashCode", "", "toString", "", "financial-connections_release"})
        @StabilityInferred(parameters=1)
        public static final class None
        implements RefetchCondition {
            @NotNull
            public static final None INSTANCE = new None();
            public static final int $stable;

            private None() {
            }

            @Override
            public boolean shouldReFetch(@NotNull SynchronizeSessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return false;
            }

            @NotNull
            public String toString() {
                return "None";
            }

            public int hashCode() {
                return -1660633189;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof None)) {
                    return false;
                }
                None cfr_ignored_0 = (None)other;
                return true;
            }
        }
    }
}

