/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.domain;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.debug.DebugConfiguration;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.utils.Experiment;
import com.stripe.android.financialconnections.utils.ExperimentsKt;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/financialconnections/domain/NativeAuthFlowRouter;", "", "eventTracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "debugConfiguration", "Lcom/stripe/android/financialconnections/debug/DebugConfiguration;", "<init>", "(Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;Lcom/stripe/android/financialconnections/debug/DebugConfiguration;)V", "nativeAuthFlowEnabled", "", "manifest", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest;", "logExposure", "", "nativeKillSwitchActive", "nativeExperienceEnabled", "shouldLogExposure", "Companion", "financial-connections_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNativeAuthFlowRouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeAuthFlowRouter.kt\ncom/stripe/android/financialconnections/domain/NativeAuthFlowRouter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,64:1\n1#2:65\n188#3,3:66\n*S KotlinDebug\n*F\n+ 1 NativeAuthFlowRouter.kt\ncom/stripe/android/financialconnections/domain/NativeAuthFlowRouter\n*L\n41#1:66,3\n*E\n"})
public final class NativeAuthFlowRouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsAnalyticsTracker eventTracker;
    @NotNull
    private final DebugConfiguration debugConfiguration;
    public static final int $stable = 8;
    @NotNull
    private static final String FEATURE_KEY_NATIVE_KILLSWITCH = "bank_connections_mobile_native_version_killswitch";
    @NotNull
    private static final String EXPERIMENT_VALUE_NATIVE_TREATMENT = "treatment";

    @Inject
    public NativeAuthFlowRouter(@NotNull FinancialConnectionsAnalyticsTracker eventTracker, @NotNull DebugConfiguration debugConfiguration) {
        Intrinsics.checkNotNullParameter((Object)eventTracker, (String)"eventTracker");
        Intrinsics.checkNotNullParameter((Object)debugConfiguration, (String)"debugConfiguration");
        this.eventTracker = eventTracker;
        this.debugConfiguration = debugConfiguration;
    }

    public final boolean nativeAuthFlowEnabled(@NotNull FinancialConnectionsSessionManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Boolean bl = this.debugConfiguration.getOverriddenNative$financial_connections_release();
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        boolean killSwitchEnabled = this.nativeKillSwitchActive(manifest);
        return !killSwitchEnabled && this.nativeExperienceEnabled(manifest);
    }

    public final void logExposure(@NotNull FinancialConnectionsSessionManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        if (this.shouldLogExposure(manifest)) {
            ExperimentsKt.trackExposure(this.eventTracker, Experiment.CONNECTIONS_MOBILE_NATIVE, manifest);
        }
    }

    private final boolean nativeKillSwitchActive(FinancialConnectionsSessionManifest manifest) {
        boolean bl;
        block5: {
            Map<String, Boolean> map2 = manifest.getFeatures();
            if (map2 != null) {
                Map<String, Boolean> $this$any$iv = map2;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, Boolean>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Boolean> element$iv;
                        Map.Entry<String, Boolean> it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getKey(), (Object)FEATURE_KEY_NATIVE_KILLSWITCH) && it.getValue() != false)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean nativeExperienceEnabled(FinancialConnectionsSessionManifest manifest) {
        Boolean bl = manifest.isLinkWithStripe();
        boolean isInstantDebits = bl != null ? bl : false;
        return isInstantDebits || Intrinsics.areEqual((Object)ExperimentsKt.experimentAssignment(manifest, Experiment.CONNECTIONS_MOBILE_NATIVE), (Object)EXPERIMENT_VALUE_NATIVE_TREATMENT);
    }

    private final boolean shouldLogExposure(FinancialConnectionsSessionManifest manifest) {
        boolean isForcingNative = this.debugConfiguration.getOverriddenNative$financial_connections_release() != null;
        Boolean bl = manifest.isLinkWithStripe();
        boolean isInstantDebits = bl != null ? bl : false;
        return !isForcingNative && !isInstantDebits && !this.nativeKillSwitchActive(manifest);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/financialconnections/domain/NativeAuthFlowRouter$Companion;", "", "<init>", "()V", "FEATURE_KEY_NATIVE_KILLSWITCH", "", "EXPERIMENT_VALUE_NATIVE_TREATMENT", "financial-connections_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

