/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.accountpicker;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import com.stripe.android.core.Logger;
import com.stripe.android.core.exception.LocalStripeException;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.FinancialConnections;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsEvent;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTrackerKt;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsEvent;
import com.stripe.android.financialconnections.di.FinancialConnectionsSheetNativeComponent;
import com.stripe.android.financialconnections.domain.GetCachedAccountsKt;
import com.stripe.android.financialconnections.domain.GetOrFetchSync;
import com.stripe.android.financialconnections.domain.NativeAuthFlowCoordinator;
import com.stripe.android.financialconnections.domain.PollAuthorizationSessionAccounts;
import com.stripe.android.financialconnections.domain.SaveAccountToLink;
import com.stripe.android.financialconnections.domain.SelectAccounts;
import com.stripe.android.financialconnections.exception.AccountLoadError;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerClickableText;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerState;
import com.stripe.android.financialconnections.features.accountpicker.AccountPickerViewModel;
import com.stripe.android.financialconnections.features.common.ManifestExtensionsKt;
import com.stripe.android.financialconnections.features.notice.NoticeSheetState;
import com.stripe.android.financialconnections.features.notice.PresentSheet;
import com.stripe.android.financialconnections.model.DataAccessNotice;
import com.stripe.android.financialconnections.model.FinancialConnectionsAuthorizationSession;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.model.PartnerAccount;
import com.stripe.android.financialconnections.model.PartnerAccountsList;
import com.stripe.android.financialconnections.model.SynchronizeSessionResponse;
import com.stripe.android.financialconnections.navigation.Destination;
import com.stripe.android.financialconnections.navigation.DestinationMappersKt;
import com.stripe.android.financialconnections.navigation.topappbar.TopAppBarStateUpdate;
import com.stripe.android.financialconnections.presentation.Async;
import com.stripe.android.financialconnections.presentation.FinancialConnectionsViewModel;
import com.stripe.android.financialconnections.repository.ConsumerSessionProvider;
import com.stripe.android.financialconnections.ui.HandleClickableUrl;
import com.stripe.android.financialconnections.utils.MavericksExtensionsKt;
import com.stripe.android.uicore.navigation.NavigationManager;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 @2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002?@Bk\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u001e\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\u000e\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020%J,\u0010,\u001a\u00020 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00101\u001a\u000202H\u0002J\u0006\u00103\u001a\u00020 J\u001e\u00104\u001a\u00020 2\f\u00105\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00106\u001a\u000202H\u0002J\u0006\u00107\u001a\u00020 J\u0006\u00108\u001a\u00020 J\u0006\u00109\u001a\u00020 J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020/J\b\u0010=\u001a\u00020 H\u0002J\u0006\u0010>\u001a\u00020 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel;", "Lcom/stripe/android/financialconnections/presentation/FinancialConnectionsViewModel;", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;", "initialState", "nativeAuthFlowCoordinator", "Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;", "eventTracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "consumerSessionProvider", "Lcom/stripe/android/financialconnections/repository/ConsumerSessionProvider;", "saveAccountToLink", "Lcom/stripe/android/financialconnections/domain/SaveAccountToLink;", "selectAccounts", "Lcom/stripe/android/financialconnections/domain/SelectAccounts;", "getOrFetchSync", "Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;", "navigationManager", "Lcom/stripe/android/uicore/navigation/NavigationManager;", "handleClickableUrl", "Lcom/stripe/android/financialconnections/ui/HandleClickableUrl;", "logger", "Lcom/stripe/android/core/Logger;", "pollAuthorizationSessionAccounts", "Lcom/stripe/android/financialconnections/domain/PollAuthorizationSessionAccounts;", "presentSheet", "Lcom/stripe/android/financialconnections/features/notice/PresentSheet;", "<init>", "(Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;Lcom/stripe/android/financialconnections/repository/ConsumerSessionProvider;Lcom/stripe/android/financialconnections/domain/SaveAccountToLink;Lcom/stripe/android/financialconnections/domain/SelectAccounts;Lcom/stripe/android/financialconnections/domain/GetOrFetchSync;Lcom/stripe/android/uicore/navigation/NavigationManager;Lcom/stripe/android/financialconnections/ui/HandleClickableUrl;Lcom/stripe/android/core/Logger;Lcom/stripe/android/financialconnections/domain/PollAuthorizationSessionAccounts;Lcom/stripe/android/financialconnections/features/notice/PresentSheet;)V", "updateTopAppBar", "Lcom/stripe/android/financialconnections/navigation/topappbar/TopAppBarStateUpdate;", "state", "loadInstitution", "", "loadAccounts", "throwErrorIfNoSelectableAccounts", "accounts", "", "Lcom/stripe/android/financialconnections/model/PartnerAccount;", "manifest", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest;", "onPayloadLoaded", "logErrors", "onAccountClicked", "account", "logAccountSelectionChanges", "idsBefore", "", "", "idsAfter", "isSingleAccount", "", "onSubmit", "submitAccounts", "selectedIds", "isSkipAccountSelection", "selectAnotherBank", "onEnterDetailsManually", "onLoadAccountsAgain", "onClickableTextClick", "Lkotlinx/coroutines/Job;", "uri", "presentDataAccessBottomSheet", "onViewEffectLaunched", "Factory", "Companion", "financial-connections_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAccountPickerViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n2632#2,3:459\n*S KotlinDebug\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel\n*L\n157#1:459,3\n*E\n"})
public final class AccountPickerViewModel
extends FinancialConnectionsViewModel<AccountPickerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsAnalyticsTracker eventTracker;
    @NotNull
    private final ConsumerSessionProvider consumerSessionProvider;
    @NotNull
    private final SaveAccountToLink saveAccountToLink;
    @NotNull
    private final SelectAccounts selectAccounts;
    @NotNull
    private final GetOrFetchSync getOrFetchSync;
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final HandleClickableUrl handleClickableUrl;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PollAuthorizationSessionAccounts pollAuthorizationSessionAccounts;
    @NotNull
    private final PresentSheet presentSheet;
    public static final int $stable = 8;
    @NotNull
    private static final FinancialConnectionsSessionManifest.Pane PANE = FinancialConnectionsSessionManifest.Pane.ACCOUNT_PICKER;

    @AssistedInject
    public AccountPickerViewModel(@Assisted @NotNull AccountPickerState initialState, @NotNull NativeAuthFlowCoordinator nativeAuthFlowCoordinator, @NotNull FinancialConnectionsAnalyticsTracker eventTracker, @NotNull ConsumerSessionProvider consumerSessionProvider, @NotNull SaveAccountToLink saveAccountToLink, @NotNull SelectAccounts selectAccounts2, @NotNull GetOrFetchSync getOrFetchSync, @NotNull NavigationManager navigationManager, @NotNull HandleClickableUrl handleClickableUrl, @NotNull Logger logger, @NotNull PollAuthorizationSessionAccounts pollAuthorizationSessionAccounts, @NotNull PresentSheet presentSheet) {
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)nativeAuthFlowCoordinator, (String)"nativeAuthFlowCoordinator");
        Intrinsics.checkNotNullParameter((Object)eventTracker, (String)"eventTracker");
        Intrinsics.checkNotNullParameter((Object)consumerSessionProvider, (String)"consumerSessionProvider");
        Intrinsics.checkNotNullParameter((Object)saveAccountToLink, (String)"saveAccountToLink");
        Intrinsics.checkNotNullParameter((Object)selectAccounts2, (String)"selectAccounts");
        Intrinsics.checkNotNullParameter((Object)getOrFetchSync, (String)"getOrFetchSync");
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        Intrinsics.checkNotNullParameter((Object)handleClickableUrl, (String)"handleClickableUrl");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)pollAuthorizationSessionAccounts, (String)"pollAuthorizationSessionAccounts");
        Intrinsics.checkNotNullParameter((Object)presentSheet, (String)"presentSheet");
        super(initialState, nativeAuthFlowCoordinator);
        this.eventTracker = eventTracker;
        this.consumerSessionProvider = consumerSessionProvider;
        this.saveAccountToLink = saveAccountToLink;
        this.selectAccounts = selectAccounts2;
        this.getOrFetchSync = getOrFetchSync;
        this.navigationManager = navigationManager;
        this.handleClickableUrl = handleClickableUrl;
        this.logger = logger;
        this.pollAuthorizationSessionAccounts = pollAuthorizationSessionAccounts;
        this.presentSheet = presentSheet;
        this.logErrors();
        this.onPayloadLoaded();
        this.loadInstitution();
        this.loadAccounts();
    }

    @Override
    @NotNull
    public TopAppBarStateUpdate updateTopAppBar(@NotNull AccountPickerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new TopAppBarStateUpdate(PANE, false, MavericksExtensionsKt.getError(state.getPayload()), false, null, false, 56, null);
    }

    private final void loadInstitution() {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super FinancialConnectionsInstitution>, Object>(this, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, false, (Continuation)this, 3, null);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        sync = (SynchronizeSessionResponse)v0;
                        manifest = sync.getManifest();
                        v1 = manifest.getActiveInstitution();
                        if (v1 == null) {
                            var4_5 = "Required value was null.";
                            throw new IllegalArgumentException(var4_5.toString());
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super FinancialConnectionsInstitution> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, AccountPickerViewModel::loadInstitution$lambda$0, 1, null);
    }

    private final void loadAccounts() {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super AccountPickerState.Payload>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            long J$0;
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        state = (AccountPickerState)this.this$0.getStateFlow().getValue();
                        this.L$0 = state;
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, false, (Continuation)this, 3, null);
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        state = (AccountPickerState)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        dataAccessNotice = (v1 = (sync = (SynchronizeSessionResponse)v0).getText()) != null && (v1 = v1.getConsent()) != null ? v1.getDataAccessNotice() : null;
                        manifest = sync.getManifest();
                        v2 = manifest.getActiveAuthSession();
                        if (v2 == null) {
                            var8_7 = "Required value was null.";
                            throw new IllegalArgumentException(var8_7.toString());
                        }
                        activeAuthSession = v2;
                        var8_8 = this.this$0;
                        $i$f$measureTimeMillis = false;
                        startTime$iv = System.currentTimeMillis();
                        $i$a$-measureTimeMillis-AccountPickerViewModel$loadAccounts$1$1 = false;
                        var13_15 = AccountPickerViewModel.access$getPollAuthorizationSessionAccounts$p(var8_8);
                        var14_18 = state.getCanRetry();
                        v3 = var14_18 != false;
                        this.L$0 = sync;
                        this.L$1 = dataAccessNotice;
                        this.L$2 = manifest;
                        this.L$3 = activeAuthSession;
                        this.J$0 = startTime$iv;
                        this.label = 2;
                        v4 = var13_15.invoke(v3, sync, (Continuation<? super PartnerAccountsList>)this);
                        if (v4 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl50
                    }
                    case 2: {
                        $i$f$measureTimeMillis = false;
                        $i$a$-measureTimeMillis-AccountPickerViewModel$loadAccounts$1$1 = false;
                        startTime$iv = this.J$0;
                        activeAuthSession = (FinancialConnectionsAuthorizationSession)this.L$3;
                        manifest = (FinancialConnectionsSessionManifest)this.L$2;
                        dataAccessNotice = (DataAccessNotice)this.L$1;
                        sync = (SynchronizeSessionResponse)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl50:
                        // 2 sources

                        result$iv = (PartnerAccountsList)v4;
                        var7_22 = TuplesKt.to((Object)result$iv, (Object)Boxing.boxLong((long)(System.currentTimeMillis() - startTime$iv)));
                        partnerAccountList = (PartnerAccountsList)var7_22.component1();
                        millis = ((Number)var7_22.component2()).longValue();
                        if (((Collection)partnerAccountList.getData()).isEmpty() == false) {
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.PollAccountsSucceeded(AccountPickerViewModel.access$getPANE$cp(), activeAuthSession.getId(), millis));
                        }
                        $this$sortedBy$iv = partnerAccountList.getData();
                        $i$f$sortedBy = false;
                        accounts = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                PartnerAccount it = (PartnerAccount)a;
                                boolean bl = false;
                                boolean bl2 = !it.getAllowSelection$financial_connections_release();
                                it = (PartnerAccount)b;
                                Comparable comparable = Boolean.valueOf(bl2);
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.getAllowSelection$financial_connections_release()));
                            }
                        });
                        v5 = sync.getText();
                        dataAccessDisclaimer = v5 != null && (v5 = v5.getAccountPicker()) != null ? v5.getDataAccessNotice() : null;
                        AccountPickerViewModel.access$throwErrorIfNoSelectableAccounts(this.this$0, accounts, manifest);
                        v6 = partnerAccountList.getSkipAccountSelection();
                        if (v6 != null) {
                            v7 = v6;
                        } else {
                            v8 = activeAuthSession.getSkipAccountSelection();
                            v7 = v8 != null ? v8 : false;
                        }
                        var13_16 = v7;
                        var14_19 /* !! */  = manifest.getSingleAccount() != false ? AccountPickerState.SelectionMode.Single : AccountPickerState.SelectionMode.Multiple;
                        var15_21 = manifest.getSingleAccount();
                        var16_24 = manifest.getSingleAccount() != false && Intrinsics.areEqual((Object)activeAuthSession.getInstitutionSkipAccountSelection(), (Object)Boxing.boxBoolean((boolean)true)) != false && accounts.size() == 1;
                        var17_25 = manifest.getBusinessName();
                        v9 = manifest.isStripeDirect();
                        var18_26 = v9 != null ? v9 : false;
                        var13_17 = new AccountPickerState.Payload(var13_16 != false, accounts, dataAccessDisclaimer, dataAccessNotice, var14_19 /* !! */ , var15_21 != false, var18_26 != false, var17_25, var16_24 != false);
                        var14_19 /* !! */  = this.this$0;
                        $i$a$-also-AccountPickerViewModel$loadAccounts$1$2 = false;
                        AccountPickerViewModel.access$getEventTracker$p((AccountPickerViewModel)var14_19 /* !! */ ).track(new FinancialConnectionsAnalyticsEvent.PaneLoaded(AccountPickerViewModel.access$getPANE$cp()));
                        return var13_17;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super AccountPickerState.Payload> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, AccountPickerViewModel::loadAccounts$lambda$1, 1, null);
    }

    private final void throwErrorIfNoSelectableAccounts(List<PartnerAccount> accounts, FinancialConnectionsSessionManifest manifest) {
        boolean bl;
        block5: {
            Iterable $this$none$iv = accounts;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PartnerAccount it = (PartnerAccount)element$iv;
                    boolean bl2 = false;
                    if (!it.getAllowSelection$financial_connections_release()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            FinancialConnectionsInstitution financialConnectionsInstitution = manifest.getActiveInstitution();
            if (financialConnectionsInstitution == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            throw new AccountLoadError(manifest.getAllowManualEntry(), true, financialConnectionsInstitution, (StripeException)new LocalStripeException("No accounts available to select.", null));
        }
    }

    private final void onPayloadLoaded() {
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)onPayloadLoaded.1.INSTANCE, (Function2)new Function2<AccountPickerState.Payload, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountPickerState.Payload payload = (AccountPickerState.Payload)this.L$0;
                        if (payload.getSkipAccountSelection()) {
                            void $this$mapTo$iv$iv;
                            List accounts = payload.getSelectableAccounts();
                            AccountPickerViewModel accountPickerViewModel = this.this$0;
                            boolean $i$a$-let-AccountPickerViewModel$onPayloadLoaded$2$22 = false;
                            Iterable $this$map$iv = payload.getSingleAccount() ? CollectionsKt.take((Iterable)accounts, (int)1) : accounts;
                            boolean $i$f$map = false;
                            Iterable $i$a$-let-AccountPickerViewModel$onPayloadLoaded$2$22 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void account;
                                PartnerAccount partnerAccount = (PartnerAccount)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(account.getId());
                            }
                            AccountPickerViewModel.access$submitAccounts(accountPickerViewModel, CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), true);
                        } else if (payload.getUserSelectedSingleAccountInInstitution()) {
                            AccountPickerViewModel.access$submitAccounts(this.this$0, SetsKt.setOf((Object)((PartnerAccount)CollectionsKt.first(payload.getAccounts())).getId()), true);
                        } else if (payload.getSelectionMode() == AccountPickerState.SelectionMode.Single) {
                            PartnerAccount partnerAccount = (PartnerAccount)CollectionsKt.firstOrNull(payload.getSelectableAccounts());
                            Set selectedId = SetsKt.setOfNotNull((Object)(partnerAccount != null ? partnerAccount.getId() : null));
                            FinancialConnectionsSessionManifest.Pane $i$f$map = AccountPickerViewModel.access$getPANE$cp();
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsAutoSelected($i$f$map, selectedId, true));
                            AccountPickerViewModel.access$setState(this.this$0, arg_0 -> onPayloadLoaded.2.invokeSuspend$lambda$2(selectedId, arg_0));
                        } else if (payload.getSelectionMode() == AccountPickerState.SelectionMode.Multiple) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = payload.getSelectableAccounts();
                            boolean $i$f$map = false;
                            Iterable destination$iv$iv = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                PartnerAccount bl = (PartnerAccount)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl2 = false;
                                collection.add(it.getId());
                            }
                            Set selectedIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                            FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsAutoSelected(pane, selectedIds, false));
                            AccountPickerViewModel.access$setState(this.this$0, arg_0 -> onPayloadLoaded.2.invokeSuspend$lambda$4(selectedIds, arg_0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(AccountPickerState.Payload p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final AccountPickerState invokeSuspend$lambda$2(Set $selectedId, AccountPickerState $this$setState) {
                return AccountPickerState.copy$default($this$setState, null, null, false, null, $selectedId, null, 47, null);
            }

            private static final AccountPickerState invokeSuspend$lambda$4(Set $selectedIds, AccountPickerState $this$setState) {
                return AccountPickerState.copy$default($this$setState, null, null, false, null, $selectedIds, null, 47, null);
            }
        }, null, 4, null);
    }

    private final void logErrors() {
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)logErrors.1.INSTANCE, null, (Function2)new Function2<Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        FinancialConnectionsAnalyticsTracker financialConnectionsAnalyticsTracker = AccountPickerViewModel.access$getEventTracker$p(this.this$0);
                        Logger logger = AccountPickerViewModel.access$getLogger$p(this.this$0);
                        FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                        FinancialConnectionsAnalyticsTrackerKt.logError(financialConnectionsAnalyticsTracker, "Error retrieving accounts", it, logger, pane);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Throwable p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        FinancialConnectionsViewModel.onAsync$default(this, (KProperty1)logErrors.3.INSTANCE, null, (Function2)new Function2<Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        FinancialConnectionsAnalyticsTracker financialConnectionsAnalyticsTracker = AccountPickerViewModel.access$getEventTracker$p(this.this$0);
                        Logger logger = AccountPickerViewModel.access$getLogger$p(this.this$0);
                        FinancialConnectionsSessionManifest.Pane pane = AccountPickerViewModel.access$getPANE$cp();
                        FinancialConnectionsAnalyticsTrackerKt.logError(financialConnectionsAnalyticsTracker, "Error selecting accounts", it, logger, pane);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Throwable p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public final void onAccountClicked(@NotNull PartnerAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.withState(arg_0 -> AccountPickerViewModel.onAccountClicked$lambda$6(this, account, arg_0));
    }

    private final void logAccountSelectionChanges(Set<String> idsBefore, Set<String> idsAfter, boolean isSingleAccount) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(idsAfter, idsBefore, this, isSingleAccount, null){
            int label;
            final /* synthetic */ Set<String> $idsAfter;
            final /* synthetic */ Set<String> $idsBefore;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ boolean $isSingleAccount;
            {
                this.$idsAfter = $idsAfter;
                this.$idsBefore = $idsBefore;
                this.this$0 = $receiver;
                this.$isSingleAccount = $isSingleAccount;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string2;
                        FinancialConnectionsSessionManifest.Pane pane;
                        ResultKt.throwOnFailure((Object)object);
                        Set newIds = SetsKt.minus(this.$idsAfter, (Iterable)this.$idsBefore);
                        Set removedIds = SetsKt.minus(this.$idsBefore, (Iterable)this.$idsAfter);
                        if (newIds.size() == 1) {
                            pane = AccountPickerViewModel.access$getPANE$cp();
                            string2 = (String)CollectionsKt.first((Iterable)newIds);
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountSelected(pane, true, this.$isSingleAccount, string2));
                        }
                        if (removedIds.size() == 1) {
                            pane = AccountPickerViewModel.access$getPANE$cp();
                            string2 = (String)CollectionsKt.first((Iterable)removedIds);
                            AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountSelected(pane, false, this.$isSingleAccount, string2));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onSubmit() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.ClickLinkAccounts(AccountPickerViewModel.access$getPANE$cp()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        FinancialConnections.emitEvent-gIAlu-s$financial_connections_release$default(FinancialConnections.INSTANCE, FinancialConnectionsEvent.Name.ACCOUNTS_SELECTED, null, 2, null);
        this.withState(arg_0 -> AccountPickerViewModel.onSubmit$lambda$9(this, arg_0));
    }

    private final void submitAccounts(Set<String> selectedIds, boolean isSkipAccountSelection) {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super PartnerAccountsList>, Object>(this, selectedIds, isSkipAccountSelection, null){
            Object L$0;
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ Set<String> $selectedIds;
            final /* synthetic */ boolean $isSkipAccountSelection;
            {
                this.this$0 = $receiver;
                this.$selectedIds = $selectedIds;
                this.$isSkipAccountSelection = $isSkipAccountSelection;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = AccountPickerViewModel.access$getPANE$cp();
                        AccountPickerViewModel.access$getEventTracker$p(this.this$0).track(new FinancialConnectionsAnalyticsEvent.AccountsSubmitted(var2_3, this.$selectedIds, this.$isSkipAccountSelection));
                        this.label = 1;
                        v0 = GetOrFetchSync.invoke$default(AccountPickerViewModel.access$getGetOrFetchSync$p(this.this$0), null, false, (Continuation)this, 3, null);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        manifest = ((SynchronizeSessionResponse)v0).getManifest();
                        v1 = manifest.getActiveAuthSession();
                        if (v1 == null) {
                            var5_4 = "Required value was null.";
                            throw new IllegalArgumentException(var5_4.toString());
                        }
                        this.L$0 = manifest;
                        this.label = 2;
                        v2 = AccountPickerViewModel.access$getSelectAccounts$p(this.this$0).invoke(this.$selectedIds, v1.getId(), (Continuation<? super PartnerAccountsList>)((Continuation)this));
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        manifest = (FinancialConnectionsSessionManifest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl30:
                        // 2 sources

                        accountsList = (PartnerAccountsList)v2;
                        v3 = AccountPickerViewModel.access$getConsumerSessionProvider$p(this.this$0).provideConsumerSession();
                        v4 = consumerSessionClientSecret = v3 != null ? v3.getClientSecret() : null;
                        if (ManifestExtensionsKt.isDataFlow(manifest) && ManifestExtensionsKt.getCanSaveAccountsToLink(manifest) && consumerSessionClientSecret != null) {
                            this.L$0 = accountsList;
                            this.label = 3;
                            v5 = AccountPickerViewModel.access$getSaveAccountToLink$p(this.this$0).existing(consumerSessionClientSecret, GetCachedAccountsKt.toCachedPartnerAccounts(accountsList.getData()), ManifestExtensionsKt.isDataFlow(manifest), (Continuation<? super FinancialConnectionsSessionManifest>)((Continuation)this));
                            if (v5 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        accountsList = (PartnerAccountsList)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl44:
                        // 2 sources

                        NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)AccountPickerViewModel.access$getNavigationManager$p(this.this$0), (String)Destination.invoke$default(DestinationMappersKt.getDestination(accountsList.getNextPane()), AccountPickerViewModel.access$getPANE$cp(), null, 2, null), null, (boolean)false, (int)6, null);
                        return accountsList;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super PartnerAccountsList> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, AccountPickerViewModel::submitAccounts$lambda$10, 1, null);
    }

    public final void selectAnotherBank() {
        NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.Reset.INSTANCE, PANE, null, 2, null), null, (boolean)false, (int)6, null);
    }

    public final void onEnterDetailsManually() {
        NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.ManualEntry.INSTANCE, PANE, null, 2, null), null, (boolean)false, (int)6, null);
    }

    public final void onLoadAccountsAgain() {
        this.setState(AccountPickerViewModel::onLoadAccountsAgain$lambda$11);
        this.loadAccounts();
    }

    @NotNull
    public final Job onClickableTextClick(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
            int label;
            final /* synthetic */ AccountPickerViewModel this$0;
            final /* synthetic */ String $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Date date = new Date();
                        this.label = 1;
                        Object object3 = AccountPickerViewModel.access$getHandleClickableUrl$p(this.this$0).invoke(AccountPickerViewModel.access$getPANE$cp(), this.$uri, (Function1<? super String, Unit>)((Function1)arg_0 -> onClickableTextClick.1.invokeSuspend$lambda$1(this.this$0, this.$uri, date, arg_0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)AccountPickerClickableText.DATA.getValue(), (Object)new Function2<HandleClickableUrl.DeeplinkPayload, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccountPickerViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AccountPickerViewModel.access$presentDataAccessBottomSheet(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(HandleClickableUrl.DeeplinkPayload p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final AccountPickerState invokeSuspend$lambda$1$lambda$0(String $uri, Date $date, AccountPickerState $this$setState) {
                return AccountPickerState.copy$default($this$setState, null, null, false, null, null, new AccountPickerState.ViewEffect.OpenUrl($uri, $date.getTime()), 31, null);
            }

            private static final Unit invokeSuspend$lambda$1(AccountPickerViewModel this$0, String $uri, Date $date, String it) {
                AccountPickerViewModel.access$setState(this$0, arg_0 -> onClickableTextClick.1.invokeSuspend$lambda$1$lambda$0($uri, $date, arg_0));
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private final void presentDataAccessBottomSheet() {
        Object object = ((AccountPickerState)this.getStateFlow().getValue()).getPayload().invoke();
        if (object == null || (object = ((AccountPickerState.Payload)object).getDataAccessNotice()) == null) {
            return;
        }
        Object dataAccessNotice = object;
        this.eventTracker.track(new FinancialConnectionsAnalyticsEvent.ClickLearnMoreDataAccess(PANE));
        this.presentSheet.invoke(new NoticeSheetState.NoticeSheetContent.DataAccess((DataAccessNotice)dataAccessNotice), PANE);
    }

    public final void onViewEffectLaunched() {
        this.setState(AccountPickerViewModel::onViewEffectLaunched$lambda$12);
    }

    private static final AccountPickerState loadInstitution$lambda$0(AccountPickerState $this$execute, Async it) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AccountPickerState.copy$default($this$execute, it, null, false, null, null, null, 62, null);
    }

    private static final AccountPickerState loadAccounts$lambda$1(AccountPickerState $this$execute, Async it) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AccountPickerState.copy$default($this$execute, null, it, false, null, null, null, 61, null);
    }

    private static final AccountPickerState onAccountClicked$lambda$6$lambda$4$lambda$3(Set $newSelectedIds, AccountPickerState $this$setState) {
        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
        return AccountPickerState.copy$default($this$setState, null, null, false, null, $newSelectedIds, null, 47, null);
    }

    private static final Unit onAccountClicked$lambda$6(AccountPickerViewModel this$0, PartnerAccount $account, AccountPickerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        AccountPickerState.Payload payload = state.getPayload().invoke();
        if (payload != null) {
            Set set;
            AccountPickerState.Payload payload2 = payload;
            boolean bl = false;
            Set<String> selectedIds = state.getSelectedIds();
            switch (WhenMappings.$EnumSwitchMapping$0[payload2.getSelectionMode().ordinal()]) {
                case 1: {
                    set = SetsKt.setOf((Object)$account.getId());
                    break;
                }
                case 2: {
                    if (selectedIds.contains($account.getId())) {
                        set = SetsKt.minus(selectedIds, (Object)$account.getId());
                        break;
                    }
                    set = SetsKt.plus(selectedIds, (Object)$account.getId());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Set newSelectedIds = set;
            this$0.setState(arg_0 -> AccountPickerViewModel.onAccountClicked$lambda$6$lambda$4$lambda$3(newSelectedIds, arg_0));
            this$0.logAccountSelectionChanges(selectedIds, newSelectedIds, payload2.getSingleAccount());
        } else {
            AccountPickerViewModel $this$onAccountClicked_u24lambda_u246_u24lambda_u245 = this$0;
            boolean bl = false;
            Logger.DefaultImpls.error$default((Logger)$this$onAccountClicked_u24lambda_u246_u24lambda_u245.logger, (String)"account clicked without available payload.", null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onSubmit$lambda$9(AccountPickerViewModel this$0, AccountPickerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        AccountPickerState.Payload payload = state.getPayload().invoke();
        if (payload != null) {
            AccountPickerState.Payload it = payload;
            boolean bl = false;
            this$0.submitAccounts(state.getSelectedIds(), false);
        } else {
            AccountPickerViewModel $this$onSubmit_u24lambda_u249_u24lambda_u248 = this$0;
            boolean bl = false;
            Logger.DefaultImpls.error$default((Logger)$this$onSubmit_u24lambda_u249_u24lambda_u248.logger, (String)"account clicked without available payload.", null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final AccountPickerState submitAccounts$lambda$10(AccountPickerState $this$execute, Async it) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AccountPickerState.copy$default($this$execute, null, null, false, it, null, null, 55, null);
    }

    private static final AccountPickerState onLoadAccountsAgain$lambda$11(AccountPickerState $this$setState) {
        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
        return AccountPickerState.copy$default($this$setState, null, null, false, null, null, null, 59, null);
    }

    private static final AccountPickerState onViewEffectLaunched$lambda$12(AccountPickerState $this$setState) {
        Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
        return AccountPickerState.copy$default($this$setState, null, null, false, null, null, null, 31, null);
    }

    public static final /* synthetic */ GetOrFetchSync access$getGetOrFetchSync$p(AccountPickerViewModel $this) {
        return $this.getOrFetchSync;
    }

    public static final /* synthetic */ FinancialConnectionsAnalyticsTracker access$getEventTracker$p(AccountPickerViewModel $this) {
        return $this.eventTracker;
    }

    public static final /* synthetic */ FinancialConnectionsSessionManifest.Pane access$getPANE$cp() {
        return PANE;
    }

    public static final /* synthetic */ void access$throwErrorIfNoSelectableAccounts(AccountPickerViewModel $this, List accounts, FinancialConnectionsSessionManifest manifest) {
        $this.throwErrorIfNoSelectableAccounts(accounts, manifest);
    }

    public static final /* synthetic */ PollAuthorizationSessionAccounts access$getPollAuthorizationSessionAccounts$p(AccountPickerViewModel $this) {
        return $this.pollAuthorizationSessionAccounts;
    }

    public static final /* synthetic */ void access$submitAccounts(AccountPickerViewModel $this, Set selectedIds, boolean isSkipAccountSelection) {
        $this.submitAccounts(selectedIds, isSkipAccountSelection);
    }

    public static final /* synthetic */ void access$setState(AccountPickerViewModel $this, Function1 reducer) {
        $this.setState(reducer);
    }

    public static final /* synthetic */ Logger access$getLogger$p(AccountPickerViewModel $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SelectAccounts access$getSelectAccounts$p(AccountPickerViewModel $this) {
        return $this.selectAccounts;
    }

    public static final /* synthetic */ ConsumerSessionProvider access$getConsumerSessionProvider$p(AccountPickerViewModel $this) {
        return $this.consumerSessionProvider;
    }

    public static final /* synthetic */ SaveAccountToLink access$getSaveAccountToLink$p(AccountPickerViewModel $this) {
        return $this.saveAccountToLink;
    }

    public static final /* synthetic */ NavigationManager access$getNavigationManager$p(AccountPickerViewModel $this) {
        return $this.navigationManager;
    }

    public static final /* synthetic */ HandleClickableUrl access$getHandleClickableUrl$p(AccountPickerViewModel $this) {
        return $this.handleClickableUrl;
    }

    public static final /* synthetic */ void access$presentDataAccessBottomSheet(AccountPickerViewModel $this) {
        $this.presentDataAccessBottomSheet();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion;", "", "<init>", "()V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "parentComponent", "Lcom/stripe/android/financialconnections/di/FinancialConnectionsSheetNativeComponent;", "PANE", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "financial-connections_release"})
    @SourceDebugExtension(value={"SMAP\nAccountPickerViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion\n+ 2 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,458:1\n35#2:459\n77#2,2:460\n*S KotlinDebug\n*F\n+ 1 AccountPickerViewModel.kt\ncom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Companion\n*L\n399#1:459\n400#1:460,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ViewModelProvider.Factory factory(@NotNull FinancialConnectionsSheetNativeComponent parentComponent) {
            void $this$initializer$iv;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            boolean $i$f$viewModelFactory = false;
            InitializerViewModelFactoryBuilder $this$factory_u24lambda_u241 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
            boolean bl = false;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$factory_u24lambda_u241;
            Function1 initializer$iv = arg_0 -> Companion.factory$lambda$1$lambda$0(parentComponent, arg_0);
            boolean $i$f$initializer = false;
            $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(AccountPickerViewModel.class), initializer$iv);
            return initializerViewModelFactoryBuilder.build();
        }

        private static final AccountPickerViewModel factory$lambda$1$lambda$0(FinancialConnectionsSheetNativeComponent $parentComponent, CreationExtras $this$initializer) {
            Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
            return $parentComponent.getAccountPickerViewModelFactory().create(new AccountPickerState(null, null, false, null, null, null, 63, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @AssistedFactory
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel$Factory;", "", "create", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerViewModel;", "initialState", "Lcom/stripe/android/financialconnections/features/accountpicker/AccountPickerState;", "financial-connections_release"})
    public static interface Factory {
        @NotNull
        public AccountPickerViewModel create(@NotNull AccountPickerState var1);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccountPickerState.SelectionMode.values().length];
            try {
                nArray[AccountPickerState.SelectionMode.Single.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountPickerState.SelectionMode.Multiple.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

