/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.accountupdate;

import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import com.stripe.android.core.Logger;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTracker;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsAnalyticsTrackerKt;
import com.stripe.android.financialconnections.di.FinancialConnectionsSheetNativeComponent;
import com.stripe.android.financialconnections.domain.NativeAuthFlowCoordinator;
import com.stripe.android.financialconnections.domain.UpdateLocalManifest;
import com.stripe.android.financialconnections.exception.UnclassifiedError;
import com.stripe.android.financialconnections.features.accountupdate.AccountUpdateRequiredState;
import com.stripe.android.financialconnections.features.notice.NoticeSheetState;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.model.FinancialConnectionsSessionManifest;
import com.stripe.android.financialconnections.navigation.Destination;
import com.stripe.android.financialconnections.navigation.topappbar.TopAppBarStateUpdate;
import com.stripe.android.financialconnections.presentation.Async;
import com.stripe.android.financialconnections.presentation.FinancialConnectionsViewModel;
import com.stripe.android.financialconnections.repository.AccountUpdateRequiredContentRepository;
import com.stripe.android.financialconnections.repository.CoreAuthorizationPendingNetworkingRepairRepository;
import com.stripe.android.uicore.navigation.NavigationManager;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%BK\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0006\u0010\u0019\u001a\u00020\u0015J$\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020\u0015J\b\u0010#\u001a\u00020\u0015H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel;", "Lcom/stripe/android/financialconnections/presentation/FinancialConnectionsViewModel;", "Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredState;", "initialState", "nativeAuthFlowCoordinator", "Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;", "updateRequiredContentRepository", "Lcom/stripe/android/financialconnections/repository/AccountUpdateRequiredContentRepository;", "pendingRepairRepository", "Lcom/stripe/android/financialconnections/repository/CoreAuthorizationPendingNetworkingRepairRepository;", "navigationManager", "Lcom/stripe/android/uicore/navigation/NavigationManager;", "eventTracker", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;", "updateLocalManifest", "Lcom/stripe/android/financialconnections/domain/UpdateLocalManifest;", "logger", "Lcom/stripe/android/core/Logger;", "<init>", "(Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredState;Lcom/stripe/android/financialconnections/domain/NativeAuthFlowCoordinator;Lcom/stripe/android/financialconnections/repository/AccountUpdateRequiredContentRepository;Lcom/stripe/android/financialconnections/repository/CoreAuthorizationPendingNetworkingRepairRepository;Lcom/stripe/android/uicore/navigation/NavigationManager;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsAnalyticsTracker;Lcom/stripe/android/financialconnections/domain/UpdateLocalManifest;Lcom/stripe/android/core/Logger;)V", "loadContent", "", "updateTopAppBar", "Lcom/stripe/android/financialconnections/navigation/topappbar/TopAppBarStateUpdate;", "state", "handleContinue", "openBankAuthRepair", "institution", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsInstitution;", "authorization", "", "referrer", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "openPartnerAuth", "handleCancel", "onCleared", "Factory", "Companion", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class AccountUpdateRequiredViewModel
extends FinancialConnectionsViewModel<AccountUpdateRequiredState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AccountUpdateRequiredContentRepository updateRequiredContentRepository;
    @NotNull
    private final CoreAuthorizationPendingNetworkingRepairRepository pendingRepairRepository;
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final FinancialConnectionsAnalyticsTracker eventTracker;
    @NotNull
    private final UpdateLocalManifest updateLocalManifest;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;
    @NotNull
    private static final FinancialConnectionsSessionManifest.Pane PANE = FinancialConnectionsSessionManifest.Pane.ACCOUNT_UPDATE_REQUIRED;

    @AssistedInject
    public AccountUpdateRequiredViewModel(@Assisted @NotNull AccountUpdateRequiredState initialState, @NotNull NativeAuthFlowCoordinator nativeAuthFlowCoordinator, @NotNull AccountUpdateRequiredContentRepository updateRequiredContentRepository, @NotNull CoreAuthorizationPendingNetworkingRepairRepository pendingRepairRepository, @NotNull NavigationManager navigationManager, @NotNull FinancialConnectionsAnalyticsTracker eventTracker, @NotNull UpdateLocalManifest updateLocalManifest, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)nativeAuthFlowCoordinator, (String)"nativeAuthFlowCoordinator");
        Intrinsics.checkNotNullParameter((Object)updateRequiredContentRepository, (String)"updateRequiredContentRepository");
        Intrinsics.checkNotNullParameter((Object)pendingRepairRepository, (String)"pendingRepairRepository");
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        Intrinsics.checkNotNullParameter((Object)eventTracker, (String)"eventTracker");
        Intrinsics.checkNotNullParameter((Object)updateLocalManifest, (String)"updateLocalManifest");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(initialState, nativeAuthFlowCoordinator);
        this.updateRequiredContentRepository = updateRequiredContentRepository;
        this.pendingRepairRepository = pendingRepairRepository;
        this.navigationManager = navigationManager;
        this.eventTracker = eventTracker;
        this.updateLocalManifest = updateLocalManifest;
        this.logger = logger;
        this.loadContent();
    }

    private final void loadContent() {
        FinancialConnectionsViewModel.execute$default(this, (Function1)new Function1<Continuation<? super NoticeSheetState.NoticeSheetContent.UpdateRequired>, Object>(this, null){
            int label;
            final /* synthetic */ AccountUpdateRequiredViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountUpdateRequiredContentRepository.State state = (AccountUpdateRequiredContentRepository.State)AccountUpdateRequiredViewModel.access$getUpdateRequiredContentRepository$p(this.this$0).get();
                        NoticeSheetState.NoticeSheetContent.UpdateRequired updateRequired = state != null ? state.getPayload() : null;
                        if (updateRequired == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        return updateRequired;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super NoticeSheetState.NoticeSheetContent.UpdateRequired> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, AccountUpdateRequiredViewModel::loadContent$lambda$0, 1, null);
    }

    @Override
    @Nullable
    public TopAppBarStateUpdate updateTopAppBar(@NotNull AccountUpdateRequiredState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return null;
    }

    public final void handleContinue() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountUpdateRequiredViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccountUpdateRequiredState state = (AccountUpdateRequiredState)this.this$0.getStateFlow().getValue();
                        FinancialConnectionsSessionManifest.Pane referrer = state.getReferrer();
                        NoticeSheetState.NoticeSheetContent.UpdateRequired updateRequired = state.getPayload().invoke();
                        NoticeSheetState.NoticeSheetContent.UpdateRequired.Type type = updateRequired != null ? updateRequired.getType() : null;
                        if (type == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        NoticeSheetState.NoticeSheetContent.UpdateRequired.Type type2 = type;
                        if (type2 instanceof NoticeSheetState.NoticeSheetContent.UpdateRequired.Type.Repair) {
                            AccountUpdateRequiredViewModel.access$openBankAuthRepair(this.this$0, ((NoticeSheetState.NoticeSheetContent.UpdateRequired.Type.Repair)type2).getInstitution(), ((NoticeSheetState.NoticeSheetContent.UpdateRequired.Type.Repair)type2).getAuthorization(), referrer);
                        } else if (type2 instanceof NoticeSheetState.NoticeSheetContent.UpdateRequired.Type.Supportability) {
                            AccountUpdateRequiredViewModel.access$openPartnerAuth(this.this$0, ((NoticeSheetState.NoticeSheetContent.UpdateRequired.Type.Supportability)type2).getInstitution(), referrer);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void openBankAuthRepair(FinancialConnectionsInstitution institution, String authorization, FinancialConnectionsSessionManifest.Pane referrer) {
        if (institution != null && authorization != null) {
            this.updateLocalManifest.invoke((Function1<? super FinancialConnectionsSessionManifest, FinancialConnectionsSessionManifest>)((Function1)arg_0 -> AccountUpdateRequiredViewModel.openBankAuthRepair$lambda$1(institution, arg_0)));
            this.pendingRepairRepository.set(authorization);
            NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.BankAuthRepair.INSTANCE, referrer, null, 2, null), null, (boolean)false, (int)6, null);
        } else {
            boolean missingAuth = authorization == null;
            boolean missingInstitution = institution == null;
            FinancialConnectionsAnalyticsTrackerKt.logError(this.eventTracker, "Unable to open repair flow (missing auth: " + missingAuth + ", missing institution: " + missingInstitution + ").", (Throwable)((Object)new UnclassifiedError("UpdateRepairAccountError", null, 2, null)), this.logger, PANE);
            NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.InstitutionPicker.INSTANCE, referrer, null, 2, null), null, (boolean)false, (int)6, null);
        }
    }

    private final void openPartnerAuth(FinancialConnectionsInstitution institution, FinancialConnectionsSessionManifest.Pane referrer) {
        if (institution != null) {
            this.updateLocalManifest.invoke((Function1<? super FinancialConnectionsSessionManifest, FinancialConnectionsSessionManifest>)((Function1)arg_0 -> AccountUpdateRequiredViewModel.openPartnerAuth$lambda$2(institution, arg_0)));
            NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.PartnerAuth.INSTANCE, referrer, null, 2, null), null, (boolean)false, (int)6, null);
        } else {
            NavigationManager.DefaultImpls.tryNavigateTo$default((NavigationManager)this.navigationManager, (String)Destination.invoke$default(Destination.InstitutionPicker.INSTANCE, referrer, null, 2, null), null, (boolean)false, (int)6, null);
        }
    }

    public final void handleCancel() {
        this.navigationManager.tryNavigateBack();
    }

    protected void onCleared() {
        this.updateRequiredContentRepository.clear();
        super.onCleared();
    }

    private static final AccountUpdateRequiredState loadContent$lambda$0(AccountUpdateRequiredState $this$execute, Async it) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AccountUpdateRequiredState.copy$default($this$execute, null, it, 1, null);
    }

    private static final FinancialConnectionsSessionManifest openBankAuthRepair$lambda$1(FinancialConnectionsInstitution $institution, FinancialConnectionsSessionManifest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FinancialConnectionsSessionManifest.copy$default(it, false, false, null, false, false, null, false, false, false, false, false, false, null, null, null, null, false, false, null, null, null, null, null, null, $institution, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -16777217, 16383, null);
    }

    private static final FinancialConnectionsSessionManifest openPartnerAuth$lambda$2(FinancialConnectionsInstitution $institution, FinancialConnectionsSessionManifest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FinancialConnectionsSessionManifest.copy$default(it, false, false, null, false, false, null, false, false, false, false, false, false, null, null, null, null, false, false, null, null, null, null, null, null, $institution, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -16777217, 16383, null);
    }

    public static final /* synthetic */ AccountUpdateRequiredContentRepository access$getUpdateRequiredContentRepository$p(AccountUpdateRequiredViewModel $this) {
        return $this.updateRequiredContentRepository;
    }

    public static final /* synthetic */ void access$openBankAuthRepair(AccountUpdateRequiredViewModel $this, FinancialConnectionsInstitution institution, String authorization, FinancialConnectionsSessionManifest.Pane referrer) {
        $this.openBankAuthRepair(institution, authorization, referrer);
    }

    public static final /* synthetic */ void access$openPartnerAuth(AccountUpdateRequiredViewModel $this, FinancialConnectionsInstitution institution, FinancialConnectionsSessionManifest.Pane referrer) {
        $this.openPartnerAuth(institution, referrer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel$Companion;", "", "<init>", "()V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "parentComponent", "Lcom/stripe/android/financialconnections/di/FinancialConnectionsSheetNativeComponent;", "arguments", "Landroid/os/Bundle;", "PANE", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "getPANE$financial_connections_release", "()Lcom/stripe/android/financialconnections/model/FinancialConnectionsSessionManifest$Pane;", "financial-connections_release"})
    @SourceDebugExtension(value={"SMAP\nAccountUpdateRequiredViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountUpdateRequiredViewModel.kt\ncom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel$Companion\n+ 2 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,156:1\n35#2:157\n77#2,2:158\n*S KotlinDebug\n*F\n+ 1 AccountUpdateRequiredViewModel.kt\ncom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel$Companion\n*L\n136#1:157\n137#1:158,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ViewModelProvider.Factory factory(@NotNull FinancialConnectionsSheetNativeComponent parentComponent, @Nullable Bundle arguments) {
            void $this$initializer$iv;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            boolean $i$f$viewModelFactory = false;
            InitializerViewModelFactoryBuilder $this$factory_u24lambda_u241 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
            boolean bl = false;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$factory_u24lambda_u241;
            Function1 initializer$iv = arg_0 -> Companion.factory$lambda$1$lambda$0(parentComponent, arguments, arg_0);
            boolean $i$f$initializer = false;
            $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(AccountUpdateRequiredViewModel.class), initializer$iv);
            return initializerViewModelFactoryBuilder.build();
        }

        @NotNull
        public final FinancialConnectionsSessionManifest.Pane getPANE$financial_connections_release() {
            return PANE;
        }

        private static final AccountUpdateRequiredViewModel factory$lambda$1$lambda$0(FinancialConnectionsSheetNativeComponent $parentComponent, Bundle $arguments, CreationExtras $this$initializer) {
            Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
            return $parentComponent.getAccountUpdateRequiredViewModelFactory().create(new AccountUpdateRequiredState($arguments));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @AssistedFactory
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel$Factory;", "", "create", "Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredViewModel;", "initialState", "Lcom/stripe/android/financialconnections/features/accountupdate/AccountUpdateRequiredState;", "financial-connections_release"})
    public static interface Factory {
        @NotNull
        public AccountUpdateRequiredViewModel create(@NotNull AccountUpdateRequiredState var1);
    }
}

