/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.error;

import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.financialconnections.ElementsSessionContext;
import com.stripe.android.financialconnections.features.error.FinancialConnectionsAttestationError;
import com.stripe.attestation.AttestationError;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u00a8\u0006\u0004"}, d2={"toAttestationErrorIfApplicable", "", "sdkPrefillDetails", "Lcom/stripe/android/financialconnections/ElementsSessionContext$PrefillDetails;", "financial-connections_release"})
public final class ErrorExtKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Throwable toAttestationErrorIfApplicable(@NotNull Throwable $this$toAttestationErrorIfApplicable, @Nullable ElementsSessionContext.PrefillDetails sdkPrefillDetails) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$this$toAttestationErrorIfApplicable, (String)"<this>");
        if ($this$toAttestationErrorIfApplicable instanceof APIException) {
            StripeError stripeError = ((APIException)$this$toAttestationErrorIfApplicable).getStripeError();
            if (Intrinsics.areEqual((Object)(stripeError != null ? stripeError.getCode() : null), (Object)"link_failed_to_attest_request")) {
                AttestationError.ErrorType errorType = AttestationError.ErrorType.BACKEND_VERDICT_FAILED;
                Object object = ((APIException)$this$toAttestationErrorIfApplicable).getStripeError();
                if (object == null || (object = object.getMessage()) == null) {
                    object = "An unknown error occurred";
                }
                Object object2 = object;
                APIException aPIException = (APIException)$this$toAttestationErrorIfApplicable;
                throwable = new FinancialConnectionsAttestationError(errorType, sdkPrefillDetails, (String)object2, (Throwable)aPIException);
                return throwable;
            }
        }
        if (!($this$toAttestationErrorIfApplicable instanceof AttestationError)) {
            throwable = $this$toAttestationErrorIfApplicable;
            return throwable;
        }
        AttestationError.ErrorType errorType = ((AttestationError)$this$toAttestationErrorIfApplicable).getErrorType();
        String string2 = $this$toAttestationErrorIfApplicable.getMessage();
        if (string2 == null) {
            string2 = "An unknown error occurred";
        }
        String string3 = string2;
        AttestationError attestationError = (AttestationError)$this$toAttestationErrorIfApplicable;
        throwable = new FinancialConnectionsAttestationError(errorType, sdkPrefillDetails, string3, (Throwable)attestationError);
        return throwable;
    }
}

