/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.error;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.tooling.preview.PreviewParameterProvider;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.financialconnections.exception.InstitutionPlannedDowntimeError;
import com.stripe.android.financialconnections.exception.InstitutionUnplannedDowntimeError;
import com.stripe.android.financialconnections.features.error.ErrorState;
import com.stripe.android.financialconnections.model.FinancialConnectionsInstitution;
import com.stripe.android.financialconnections.presentation.Async;
import kotlin.Metadata;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\u0002H\u0002J\b\u0010\n\u001a\u00020\u0002H\u0002J\b\u0010\u000b\u001a\u00020\u0002H\u0002J\b\u0010\f\u001a\u00020\u0002H\u0002J\b\u0010\r\u001a\u00020\u0002H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/financialconnections/features/error/ErrorPreviewParameterProvider;", "Landroidx/compose/ui/tooling/preview/PreviewParameterProvider;", "Lcom/stripe/android/financialconnections/features/error/ErrorState;", "<init>", "()V", "values", "Lkotlin/sequences/Sequence;", "getValues", "()Lkotlin/sequences/Sequence;", "loading", "unclassified", "unclassifiedWithManualEntry", "expectedDowntime", "unexpectedDowntime", "institution", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsInstitution;", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class ErrorPreviewParameterProvider
implements PreviewParameterProvider<ErrorState> {
    @NotNull
    private final Sequence<ErrorState> values;
    public static final int $stable = 8;

    public ErrorPreviewParameterProvider() {
        Object[] objectArray = new ErrorState[]{this.loading(), this.unclassified(), this.unclassifiedWithManualEntry(), this.expectedDowntime(), this.unexpectedDowntime()};
        this.values = SequencesKt.sequenceOf((Object[])objectArray);
    }

    @NotNull
    public Sequence<ErrorState> getValues() {
        return this.values;
    }

    private final ErrorState loading() {
        return new ErrorState(new Async.Loading(null, 1, null));
    }

    private final ErrorState unclassified() {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An unknown error occurred.");
        return new ErrorState((Async<ErrorState.Payload>)new Async.Success<ErrorState.Payload>(new ErrorState.Payload(illegalArgumentException, true, false)));
    }

    private final ErrorState unclassifiedWithManualEntry() {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An unknown error occurred.");
        return new ErrorState((Async<ErrorState.Payload>)new Async.Success<ErrorState.Payload>(new ErrorState.Payload(illegalArgumentException, true, true)));
    }

    private final ErrorState expectedDowntime() {
        InstitutionPlannedDowntimeError institutionPlannedDowntimeError = new InstitutionPlannedDowntimeError(this.institution(), true, true, 10000L, (StripeException)new APIException(null, null, 0, null, null, 31, null));
        return new ErrorState((Async<ErrorState.Payload>)new Async.Success<ErrorState.Payload>(new ErrorState.Payload((Throwable)((Object)institutionPlannedDowntimeError), true, true)));
    }

    private final ErrorState unexpectedDowntime() {
        InstitutionUnplannedDowntimeError institutionUnplannedDowntimeError = new InstitutionUnplannedDowntimeError(this.institution(), true, (StripeException)new APIException(null, null, 0, null, null, 31, null));
        return new ErrorState((Async<ErrorState.Payload>)new Async.Success<ErrorState.Payload>(new ErrorState.Payload((Throwable)((Object)institutionUnplannedDowntimeError), true, true)));
    }

    private final FinancialConnectionsInstitution institution() {
        return new FinancialConnectionsInstitution(false, "3", false, "Random Institution", null, null, null, "Random Institution url");
    }
}

