/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.features.manualentry;

import androidx.annotation.StringRes;
import com.stripe.android.financialconnections.R;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0007H\u0002R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/financialconnections/features/manualentry/Validator;", "", "<init>", "()V", "getRoutingErrorIdOrNull", "", "input", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getAccountErrorIdOrNull", "getAccountConfirmIdOrNull", "accountInput", "accountConfirmInput", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "isUSRoutingNumber", "", "ROUTING_NUMBER_LENGTH", "ACCOUNT_NUMBER_MAX_LENGTH", "financial-connections_release"})
@SourceDebugExtension(value={"SMAP\nManualEntryFormState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualEntryFormState.kt\ncom/stripe/android/financialconnections/features/manualentry/Validator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,84:1\n1133#2,4:85\n*S KotlinDebug\n*F\n+ 1 ManualEntryFormState.kt\ncom/stripe/android/financialconnections/features/manualentry/Validator\n*L\n72#1:85,4\n*E\n"})
final class Validator {
    @NotNull
    public static final Validator INSTANCE = new Validator();
    private static final int ROUTING_NUMBER_LENGTH = 9;
    private static final int ACCOUNT_NUMBER_MAX_LENGTH = 17;

    private Validator() {
    }

    @StringRes
    @Nullable
    public final Integer getRoutingErrorIdOrNull(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ((CharSequence)input).length() == 0 ? Integer.valueOf(R.string.stripe_validation_routing_required) : (input.length() != 9 ? Integer.valueOf(R.string.stripe_validation_routing_too_short) : (!this.isUSRoutingNumber(input) ? Integer.valueOf(R.string.stripe_validation_no_us_routing) : null));
    }

    @StringRes
    @Nullable
    public final Integer getAccountErrorIdOrNull(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ((CharSequence)input).length() == 0 ? Integer.valueOf(R.string.stripe_validation_account_required) : (input.length() > 17 ? Integer.valueOf(R.string.stripe_validation_account_too_long) : null);
    }

    @StringRes
    @Nullable
    public final Integer getAccountConfirmIdOrNull(@NotNull String accountInput, @NotNull String accountConfirmInput) {
        Intrinsics.checkNotNullParameter((Object)accountInput, (String)"accountInput");
        Intrinsics.checkNotNullParameter((Object)accountConfirmInput, (String)"accountConfirmInput");
        return this.getAccountErrorIdOrNull(accountInput) == null && !Intrinsics.areEqual((Object)accountInput, (Object)accountConfirmInput) ? Integer.valueOf(R.string.stripe_validation_account_confirm_mismatch) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUSRoutingNumber(String $this$isUSRoutingNumber) {
        boolean bl;
        Function1 usRoutingFactor = Validator::isUSRoutingNumber$lambda$0;
        if (new Regex("^\\d{9}$").matches((CharSequence)$this$isUSRoutingNumber)) {
            void $this$foldIndexed$iv;
            CharSequence charSequence = $this$isUSRoutingNumber;
            int initial$iv = 0;
            boolean $i$f$foldIndexed = false;
            int index$iv = 0;
            int accumulator$iv = initial$iv;
            for (int i = 0; i < $this$foldIndexed$iv.length(); ++i) {
                void current;
                void sum;
                char element$iv = $this$foldIndexed$iv.charAt(i);
                int n = index$iv++;
                char c = element$iv;
                int n2 = accumulator$iv;
                int idx = n;
                boolean bl2 = false;
                accumulator$iv = sum + CharsKt.digitToInt((char)current, (int)10) * ((Number)usRoutingFactor.invoke((Object)idx)).intValue();
            }
            int total = accumulator$iv;
            bl = total % 10 == 0;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final int isUSRoutingNumber$lambda$0(int it) {
        int n;
        switch (it % 3) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 7;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }
}

