/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.network;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.Logger;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.AuthenticationException;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.exception.PermissionException;
import com.stripe.android.core.exception.RateLimitException;
import com.stripe.android.core.model.parsers.StripeErrorJsonParser;
import com.stripe.android.core.networking.RequestId;
import com.stripe.android.core.networking.ResponseJsonKt;
import com.stripe.android.core.networking.StripeNetworkClient;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.core.networking.StripeResponse;
import com.stripe.android.financialconnections.analytics.FinancialConnectionsResponseEventEmitter;
import com.stripe.android.financialconnections.network.FinancialConnectionsRequestExecutor;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J*\u0010\f\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0015\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00110\u0017H\u0082@\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;", "", "stripeNetworkClient", "Lcom/stripe/android/core/networking/StripeNetworkClient;", "eventEmitter", "Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsResponseEventEmitter;", "json", "Lkotlinx/serialization/json/Json;", "logger", "Lcom/stripe/android/core/Logger;", "<init>", "(Lcom/stripe/android/core/networking/StripeNetworkClient;Lcom/stripe/android/financialconnections/analytics/FinancialConnectionsResponseEventEmitter;Lkotlinx/serialization/json/Json;Lcom/stripe/android/core/Logger;)V", "execute", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "(Lcom/stripe/android/core/networking/StripeRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Response", "responseSerializer", "Lkotlinx/serialization/KSerializer;", "(Lcom/stripe/android/core/networking/StripeRequest;Lkotlinx/serialization/KSerializer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeInternal", "decodeResponse", "Lkotlin/Function1;", "(Lcom/stripe/android/core/networking/StripeRequest;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleApiError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "response", "Lcom/stripe/android/core/networking/StripeResponse;", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class FinancialConnectionsRequestExecutor {
    @NotNull
    private final StripeNetworkClient stripeNetworkClient;
    @NotNull
    private final FinancialConnectionsResponseEventEmitter eventEmitter;
    @NotNull
    private final Json json;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    @Inject
    public FinancialConnectionsRequestExecutor(@NotNull StripeNetworkClient stripeNetworkClient, @NotNull FinancialConnectionsResponseEventEmitter eventEmitter, @NotNull Json json, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)stripeNetworkClient, (String)"stripeNetworkClient");
        Intrinsics.checkNotNullParameter((Object)eventEmitter, (String)"eventEmitter");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.stripeNetworkClient = stripeNetworkClient;
        this.eventEmitter = eventEmitter;
        this.json = json;
        this.logger = logger;
    }

    @Nullable
    public final Object execute(@NotNull StripeRequest request, @NotNull Continuation<? super String> $completion) throws InvalidRequestException, AuthenticationException, APIException {
        return this.executeInternal(request, FinancialConnectionsRequestExecutor::execute$lambda$0, $completion);
    }

    @Nullable
    public final <Response> Object execute(@NotNull StripeRequest request, @NotNull KSerializer<Response> responseSerializer, @NotNull Continuation<? super Response> $completion) throws InvalidRequestException, AuthenticationException, APIException {
        return this.executeInternal(request, arg_0 -> FinancialConnectionsRequestExecutor.execute$lambda$1(this, responseSerializer, arg_0), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final <Response> Object executeInternal(StripeRequest var1_1, Function1<? super String, ? extends Response> var2_2, Continuation<? super Response> $completion) throws InvalidRequestException, AuthenticationException, APIException {
        if (!($completion instanceof executeInternal.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FinancialConnectionsRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FinancialConnectionsRequestExecutor.access$executeInternal(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this;
                $this$executeInternal_u24lambda_u242 = var4_7;
                $i$a$-runCatching-FinancialConnectionsRequestExecutor$executeInternal$2 = false;
                $this$executeInternal_u24lambda_u242.logger.debug("Executing " + request.getMethod().getCode() + " request to " + request.getUrl());
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = decodeResponse;
                $continuation.label = 1;
                v0 = $this$executeInternal_u24lambda_u242.stripeNetworkClient.executeRequest(request, $continuation);
                ** if (v0 != var10_6) goto lbl26
lbl25:
                // 1 sources

                return var10_6;
lbl26:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                $i$a$-runCatching-FinancialConnectionsRequestExecutor$executeInternal$2 = false;
                decodeResponse = (Function1)$continuation.L$2;
                request = (StripeRequest)$continuation.L$1;
                this = (FinancialConnectionsRequestExecutor)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    $this$executeInternal_u24lambda_u242 = Result.constructor-impl((Object)((StripeResponse)v0));
                }
                catch (Throwable $i$a$-runCatching-FinancialConnectionsRequestExecutor$executeInternal$2) {
                    $this$executeInternal_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-FinancialConnectionsRequestExecutor$executeInternal$2));
                }
                var4_7 = $this$executeInternal_u24lambda_u242;
                v1 = Result.exceptionOrNull-impl((Object)var4_7);
                if (v1 == null) {
                    response = (StripeResponse)var4_7;
                    $i$a$-fold-FinancialConnectionsRequestExecutor$executeInternal$3 = false;
                    this.eventEmitter.emitIfPresent((StripeResponse<String>)response);
                    if (response.getCode() == 202) {
                        throw this.handleApiError((StripeResponse<String>)response);
                    }
                    if (response.isError()) {
                        throw this.handleApiError((StripeResponse<String>)response);
                    }
                    v2 = response.getBody();
                    if (v2 == null) {
                        var7_11 = "Required value was null.";
                        throw new IllegalArgumentException(var7_11.toString());
                    }
                } else {
                    it = v1;
                    $i$a$-fold-FinancialConnectionsRequestExecutor$executeInternal$4 = false;
                    throw new APIConnectionException("Failed to execute " + request, it);
                }
                return decodeResponse.invoke(v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Exception handleApiError(StripeResponse<String> response) throws InvalidRequestException, AuthenticationException, APIException {
        Throwable throwable;
        RequestId requestId = response.getRequestId();
        String requestId2 = requestId != null ? requestId.getValue() : null;
        int responseCode = response.getCode();
        StripeError stripeError = new StripeErrorJsonParser().parse(ResponseJsonKt.responseJson(response));
        switch (responseCode) {
            case 202: 
            case 400: 
            case 404: {
                throwable = (Throwable)new InvalidRequestException(stripeError, requestId2, responseCode, null, null, 24, null);
                break;
            }
            case 401: {
                throwable = (Throwable)new AuthenticationException(stripeError, requestId2);
                break;
            }
            case 403: {
                throwable = (Throwable)new PermissionException(stripeError, requestId2);
                break;
            }
            case 429: {
                throwable = (Throwable)new RateLimitException(stripeError, requestId2, null, null, 12, null);
                break;
            }
            default: {
                throwable = (Throwable)new APIException(stripeError, requestId2, responseCode, null, null, 24, null);
            }
        }
        throw throwable;
    }

    private static final String execute$lambda$0(String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return body;
    }

    private static final Object execute$lambda$1(FinancialConnectionsRequestExecutor this$0, KSerializer $responseSerializer, String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this$0.json.decodeFromString((DeserializationStrategy)$responseSerializer, body);
    }

    public static final /* synthetic */ Object access$executeInternal(FinancialConnectionsRequestExecutor $this, StripeRequest request, Function1 decodeResponse, Continuation $completion) {
        return $this.executeInternal(request, decodeResponse, $completion);
    }
}

