/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.repository;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.frauddetection.FraudDetectionData;
import com.stripe.android.core.frauddetection.FraudDetectionDataRepository;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.financialconnections.ElementsSessionContext;
import com.stripe.android.financialconnections.model.FinancialConnectionsAccountList;
import com.stripe.android.financialconnections.model.FinancialConnectionsSession;
import com.stripe.android.financialconnections.model.GetFinancialConnectionsAcccountsParams;
import com.stripe.android.financialconnections.model.MixedOAuthParams;
import com.stripe.android.financialconnections.network.FinancialConnectionsRequestExecutor;
import com.stripe.android.financialconnections.repository.FinancialConnectionsRepository;
import com.stripe.android.financialconnections.repository.api.ProvideApiRequestOptions;
import com.stripe.android.financialconnections.utils.BillingDetailsExtensionsKt;
import com.stripe.android.financialconnections.utils.CollectionsKt;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0018J(\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096@\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepositoryImpl;", "Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepository;", "requestExecutor", "Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;", "provideApiRequestOptions", "Lcom/stripe/android/financialconnections/repository/api/ProvideApiRequestOptions;", "fraudDetectionDataRepository", "Lcom/stripe/android/core/frauddetection/FraudDetectionDataRepository;", "apiRequestFactory", "Lcom/stripe/android/core/networking/ApiRequest$Factory;", "<init>", "(Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;Lcom/stripe/android/financialconnections/repository/api/ProvideApiRequestOptions;Lcom/stripe/android/core/frauddetection/FraudDetectionDataRepository;Lcom/stripe/android/core/networking/ApiRequest$Factory;)V", "getFinancialConnectionsAccounts", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsAccountList;", "getFinancialConnectionsAcccountsParams", "Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;", "(Lcom/stripe/android/financialconnections/model/GetFinancialConnectionsAcccountsParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFinancialConnectionsSession", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSession;", "clientSecret", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postCompleteFinancialConnectionsSessions", "terminalError", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postAuthorizationSessionOAuthResults", "Lcom/stripe/android/financialconnections/model/MixedOAuthParams;", "sessionId", "createPaymentMethod", "paymentDetailsId", "consumerSessionClientSecret", "billingDetails", "Lcom/stripe/android/financialconnections/ElementsSessionContext$BillingDetails;", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/financialconnections/ElementsSessionContext$BillingDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "financial-connections_release"})
@StabilityInferred(parameters=0)
public final class FinancialConnectionsRepositoryImpl
implements FinancialConnectionsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsRequestExecutor requestExecutor;
    @NotNull
    private final ProvideApiRequestOptions provideApiRequestOptions;
    @NotNull
    private final FraudDetectionDataRepository fraudDetectionDataRepository;
    @NotNull
    private final ApiRequest.Factory apiRequestFactory;
    public static final int $stable = 8;
    @NotNull
    private static final String listAccountsUrl = "https://api.stripe.com/v1/link_account_sessions/list_accounts";
    @NotNull
    private static final String sessionReceiptUrl = "https://api.stripe.com/v1/link_account_sessions/session_receipt";
    @NotNull
    public static final String authorizationSessionUrl = "https://api.stripe.com/v1/connections/auth_sessions";
    @NotNull
    private static final String completeUrl = "https://api.stripe.com/v1/link_account_sessions/complete";
    @NotNull
    private static final String authorizationSessionOAuthResultsUrl = "https://api.stripe.com/v1/connections/auth_sessions/oauth_results";
    @NotNull
    public static final String authorizeSessionUrl = "https://api.stripe.com/v1/connections/auth_sessions/authorized";
    @NotNull
    private static final String paymentMethodsUrl = "https://api.stripe.com/v1/payment_methods";

    @Inject
    public FinancialConnectionsRepositoryImpl(@NotNull FinancialConnectionsRequestExecutor requestExecutor, @NotNull ProvideApiRequestOptions provideApiRequestOptions, @NotNull FraudDetectionDataRepository fraudDetectionDataRepository, @NotNull ApiRequest.Factory apiRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)provideApiRequestOptions, (String)"provideApiRequestOptions");
        Intrinsics.checkNotNullParameter((Object)fraudDetectionDataRepository, (String)"fraudDetectionDataRepository");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        this.requestExecutor = requestExecutor;
        this.provideApiRequestOptions = provideApiRequestOptions;
        this.fraudDetectionDataRepository = fraudDetectionDataRepository;
        this.apiRequestFactory = apiRequestFactory;
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsAccounts(@NotNull GetFinancialConnectionsAcccountsParams getFinancialConnectionsAcccountsParams, @NotNull Continuation<? super FinancialConnectionsAccountList> $completion) {
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createGet$default((ApiRequest.Factory)this.apiRequestFactory, (String)listAccountsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), getFinancialConnectionsAcccountsParams.toParamMap(), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsAccountList.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object getFinancialConnectionsSession(@NotNull String clientSecret, @NotNull Continuation<? super FinancialConnectionsSession> $completion) {
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createGet$default((ApiRequest.Factory)this.apiRequestFactory, (String)sessionReceiptUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret)), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsSession.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object postCompleteFinancialConnectionsSessions(@NotNull String clientSecret, @Nullable String terminalError, @NotNull Continuation<? super FinancialConnectionsSession> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_secret", (Object)clientSecret), TuplesKt.to((Object)"terminal_error", (Object)terminalError)};
        ApiRequest financialConnectionsRequest = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)completeUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(true), (Map)CollectionsKt.filterNotNullValues((Map)MapsKt.mapOf((Pair[])pairArray)), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)financialConnectionsRequest, FinancialConnectionsSession.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object postAuthorizationSessionOAuthResults(@NotNull String clientSecret, @NotNull String sessionId, @NotNull Continuation<? super MixedOAuthParams> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)sessionId), TuplesKt.to((Object)"client_secret", (Object)clientSecret)};
        ApiRequest request = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)authorizationSessionOAuthResultsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(true), (Map)MapsKt.mapOf((Pair[])pairArray), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)request, MixedOAuthParams.Companion.serializer(), $completion);
    }

    @Override
    @Nullable
    public Object createPaymentMethod(@NotNull String paymentDetailsId, @NotNull String consumerSessionClientSecret, @Nullable ElementsSessionContext.BillingDetails billingDetails, @NotNull Continuation<? super String> $completion) {
        Map map2;
        Map map3;
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)"link");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"credentials", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"consumer_session_client_secret", (Object)consumerSessionClientSecret))), TuplesKt.to((Object)"payment_details_id", (Object)paymentDetailsId)};
        pairArray[1] = TuplesKt.to((Object)"link", (Object)MapsKt.mapOf((Pair[])pairArray2));
        Map linkParams = MapsKt.mapOf((Pair[])pairArray);
        ElementsSessionContext.BillingDetails billingDetails2 = billingDetails;
        if (billingDetails2 != null) {
            ElementsSessionContext.BillingDetails it = billingDetails2;
            boolean bl = false;
            map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"billing_details", (Object)BillingDetailsExtensionsKt.toApiParams((ElementsSessionContext.BillingDetails)billingDetails)));
        } else {
            map3 = map2 = null;
        }
        if (map3 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map billingParams = map2;
        FraudDetectionData fraudDetectionData = this.fraudDetectionDataRepository.getCached();
        Map map4 = fraudDetectionData != null ? fraudDetectionData.getParams() : null;
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        Map fraudDetectionParams = map4;
        ApiRequest request = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)paymentMethodsUrl, (ApiRequest.Options)this.provideApiRequestOptions.invoke(false), (Map)MapsKt.plus((Map)MapsKt.plus((Map)linkParams, (Map)billingParams), (Map)fraudDetectionParams), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)request, $completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/financialconnections/repository/FinancialConnectionsRepositoryImpl$Companion;", "", "<init>", "()V", "listAccountsUrl", "", "sessionReceiptUrl", "authorizationSessionUrl", "completeUrl", "authorizationSessionOAuthResultsUrl", "authorizeSessionUrl", "paymentMethodsUrl", "financial-connections_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

