/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.financialconnections.repository.api;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.financialconnections.network.FinancialConnectionsRequestExecutor;
import com.stripe.android.financialconnections.repository.api.FinancialConnectionsConsumersApiService;
import com.stripe.android.financialconnections.utils.CollectionsKt;
import com.stripe.android.model.ConsumerSessionLookup;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/financialconnections/repository/api/FinancialConnectionsConsumersApiServiceImpl;", "Lcom/stripe/android/financialconnections/repository/api/FinancialConnectionsConsumersApiService;", "requestExecutor", "Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;", "apiOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "apiRequestFactory", "Lcom/stripe/android/core/networking/ApiRequest$Factory;", "<init>", "(Lcom/stripe/android/financialconnections/network/FinancialConnectionsRequestExecutor;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/core/networking/ApiRequest$Factory;)V", "postConsumerSession", "Lcom/stripe/android/model/ConsumerSessionLookup;", "email", "", "clientSecret", "requestSurface", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "financial-connections_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
final class FinancialConnectionsConsumersApiServiceImpl
implements FinancialConnectionsConsumersApiService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FinancialConnectionsRequestExecutor requestExecutor;
    @NotNull
    private final ApiRequest.Options apiOptions;
    @NotNull
    private final ApiRequest.Factory apiRequestFactory;
    @Deprecated
    @NotNull
    public static final String consumerSessionsUrl = "https://api.stripe.com/v1/connections/link_account_sessions/consumer_sessions";

    public FinancialConnectionsConsumersApiServiceImpl(@NotNull FinancialConnectionsRequestExecutor requestExecutor, @NotNull ApiRequest.Options apiOptions, @NotNull ApiRequest.Factory apiRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)apiOptions, (String)"apiOptions");
        Intrinsics.checkNotNullParameter((Object)apiRequestFactory, (String)"apiRequestFactory");
        this.requestExecutor = requestExecutor;
        this.apiOptions = apiOptions;
        this.apiRequestFactory = apiRequestFactory;
    }

    @Override
    @Nullable
    public Object postConsumerSession(@NotNull String email2, @NotNull String clientSecret, @NotNull String requestSurface, @NotNull Continuation<? super ConsumerSessionLookup> $completion) {
        Pair[] pairArray = new Pair[3];
        String string2 = email2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        pairArray[0] = TuplesKt.to((Object)"email_address", (Object)string2);
        pairArray[1] = TuplesKt.to((Object)"client_secret", (Object)clientSecret);
        pairArray[2] = TuplesKt.to((Object)"request_surface", (Object)requestSurface);
        ApiRequest request = ApiRequest.Factory.createPost$default((ApiRequest.Factory)this.apiRequestFactory, (String)consumerSessionsUrl, (ApiRequest.Options)this.apiOptions, (Map)CollectionsKt.filterNotNullValues((Map)MapsKt.mapOf((Pair[])pairArray)), (boolean)false, (int)8, null);
        return this.requestExecutor.execute((StripeRequest)request, ConsumerSessionLookup.Companion.serializer(), $completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/financialconnections/repository/api/FinancialConnectionsConsumersApiServiceImpl$Companion;", "", "<init>", "()V", "consumerSessionsUrl", "", "financial-connections_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

