/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.webview;

import android.os.Handler;
import android.webkit.JavascriptInterface;
import androidx.annotation.RestrictTo;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.IHCaptchaVerifier;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.encode.EncodeKt;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\b\u0010\u0013\u001a\u00020\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0004\u001a\u00020\t8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaJSInterface;", "Ljava/io/Serializable;", "handler", "Landroid/os/Handler;", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "captchaVerifier", "Lcom/stripe/hcaptcha/IHCaptchaVerifier;", "(Landroid/os/Handler;Lcom/stripe/hcaptcha/config/HCaptchaConfig;Lcom/stripe/hcaptcha/IHCaptchaVerifier;)V", "", "getConfig", "()Ljava/lang/String;", "config$delegate", "Lkotlin/Lazy;", "onError", "", "errCode", "", "onLoaded", "onOpen", "onPass", "token", "Companion", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HCaptchaJSInterface
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient Handler handler;
    @NotNull
    private final transient IHCaptchaVerifier captchaVerifier;
    @NotNull
    private final Lazy config$delegate;
    private static final long serialVersionUID = -4830797392637553617L;
    @NotNull
    public static final String JS_INTERFACE_TAG = "JSInterface";

    public HCaptchaJSInterface(@NotNull Handler handler, @NotNull HCaptchaConfig config2, @NotNull IHCaptchaVerifier captchaVerifier) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)captchaVerifier, (String)"captchaVerifier");
        this.handler = handler;
        this.captchaVerifier = captchaVerifier;
        this.config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(config2){
            final /* synthetic */ HCaptchaConfig $config;
            {
                this.$config = $config;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return EncodeKt.encodeToJson((SerializationStrategy)HCaptchaConfig.Companion.serializer(), this.$config);
            }
        }));
    }

    @JavascriptInterface
    @NotNull
    public final String getConfig() {
        Lazy lazy = this.config$delegate;
        return (String)lazy.getValue();
    }

    @JavascriptInterface
    public final void onPass(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.handler.post(() -> HCaptchaJSInterface.onPass$lambda$0(this, token));
    }

    @JavascriptInterface
    public final void onError(int errCode) {
        HCaptchaError error = HCaptchaError.Companion.fromId(errCode);
        this.handler.post(() -> HCaptchaJSInterface.onError$lambda$1(this, error));
    }

    @JavascriptInterface
    public final void onLoaded() {
        this.handler.post(() -> HCaptchaJSInterface.onLoaded$lambda$2(this));
    }

    @JavascriptInterface
    public final void onOpen() {
        this.handler.post(() -> HCaptchaJSInterface.onOpen$lambda$3(this));
    }

    private static final void onPass$lambda$0(HCaptchaJSInterface this$0, String $token) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        this$0.captchaVerifier.onSuccess($token);
    }

    private static final void onError$lambda$1(HCaptchaJSInterface this$0, HCaptchaError $error) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
        this$0.captchaVerifier.onFailure(new HCaptchaException($error, null, 2, null));
    }

    private static final void onLoaded$lambda$2(HCaptchaJSInterface this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.captchaVerifier.onLoaded();
    }

    private static final void onOpen$lambda$3(HCaptchaJSInterface this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.captchaVerifier.onOpen();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaJSInterface$Companion;", "", "()V", "JS_INTERFACE_TAG", "", "serialVersionUID", "", "hcaptcha_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

