/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RestrictTo;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.HCaptchaStateListener;
import com.stripe.hcaptcha.IHCaptchaVerifier;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.config.HCaptchaInternalConfig;
import com.stripe.hcaptcha.webview.HCaptchaDebugInfo;
import com.stripe.hcaptcha.webview.HCaptchaJSInterface;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000  2\u00020\u0001:\u0003 !\"B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper;", "", "handler", "Landroid/os/Handler;", "context", "Landroid/content/Context;", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "internalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "captchaVerifier", "Lcom/stripe/hcaptcha/IHCaptchaVerifier;", "listener", "Lcom/stripe/hcaptcha/HCaptchaStateListener;", "webView", "Landroid/webkit/WebView;", "(Landroid/os/Handler;Landroid/content/Context;Lcom/stripe/hcaptcha/config/HCaptchaConfig;Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;Lcom/stripe/hcaptcha/IHCaptchaVerifier;Lcom/stripe/hcaptcha/HCaptchaStateListener;Landroid/webkit/WebView;)V", "getConfig$hcaptcha_release", "()Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "getListener$hcaptcha_release", "()Lcom/stripe/hcaptcha/HCaptchaStateListener;", "getWebView$hcaptcha_release", "()Landroid/webkit/WebView;", "destroy", "", "reset", "resetAndExecute", "setupWebView", "shouldRetry", "", "exception", "Lcom/stripe/hcaptcha/HCaptchaException;", "Companion", "HCaptchaWebChromeClient", "HCaptchaWebClient", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nHCaptchaWebViewHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCaptchaWebViewHelper.kt\ncom/stripe/hcaptcha/webview/HCaptchaWebViewHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class HCaptchaWebViewHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final HCaptchaConfig config;
    @NotNull
    private final HCaptchaInternalConfig internalConfig;
    @NotNull
    private final IHCaptchaVerifier captchaVerifier;
    @NotNull
    private final HCaptchaStateListener listener;
    @NotNull
    private final WebView webView;
    @NotNull
    private static final String LOG_TAG = "hCaptchaWebView";

    public HCaptchaWebViewHelper(@NotNull Handler handler, @NotNull Context context, @NotNull HCaptchaConfig config2, @NotNull HCaptchaInternalConfig internalConfig, @NotNull IHCaptchaVerifier captchaVerifier, @NotNull HCaptchaStateListener listener2, @NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
        Intrinsics.checkNotNullParameter((Object)captchaVerifier, (String)"captchaVerifier");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.context = context;
        this.config = config2;
        this.internalConfig = internalConfig;
        this.captchaVerifier = captchaVerifier;
        this.listener = listener2;
        this.webView = webView;
        this.setupWebView(handler);
    }

    @NotNull
    public final HCaptchaConfig getConfig$hcaptcha_release() {
        return this.config;
    }

    @NotNull
    public final HCaptchaStateListener getListener$hcaptcha_release() {
        return this.listener;
    }

    @NotNull
    public final WebView getWebView$hcaptcha_release() {
        return this.webView;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private final void setupWebView(Handler handler) {
        HCaptchaJSInterface jsInterface = new HCaptchaJSInterface(handler, this.config, this.captchaVerifier);
        HCaptchaDebugInfo debugInfo2 = new HCaptchaDebugInfo(this.context);
        WebSettings webSettings = this.webView.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"getSettings(...)");
        WebSettings settings = webSettings;
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
        settings.setCacheMode(-1);
        settings.setGeolocationEnabled(false);
        settings.setAllowFileAccess(false);
        settings.setAllowContentAccess(false);
        this.webView.setWebViewClient((WebViewClient)new HCaptchaWebClient(handler, this.listener));
        this.webView.setWebChromeClient((WebChromeClient)new HCaptchaWebChromeClient());
        this.webView.setBackgroundColor(0);
        if (this.config.getDisableHardwareAcceleration()) {
            this.webView.setLayerType(1, null);
        }
        this.webView.addJavascriptInterface((Object)jsInterface, "JSInterface");
        this.webView.addJavascriptInterface((Object)debugInfo2, "JSDI");
        this.webView.loadDataWithBaseURL(this.config.getHost(), (String)this.internalConfig.getHtmlProvider().invoke(), "text/html", "UTF-8", null);
    }

    public final void destroy() {
        this.webView.removeJavascriptInterface("JSInterface");
        this.webView.removeJavascriptInterface("JSDI");
        ViewParent parent = this.webView.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.webView);
        }
        this.webView.destroy();
    }

    public final void resetAndExecute() {
        this.webView.loadUrl("javascript:resetAndExecute();");
    }

    public final void reset() {
        this.webView.loadUrl("javascript:reset();");
    }

    public final boolean shouldRetry(@NotNull HCaptchaException exception) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Function2<HCaptchaConfig, HCaptchaException, Boolean> function2 = this.config.getRetryPredicate();
        if (function2 != null) {
            Function2<HCaptchaConfig, HCaptchaException, Boolean> it = function2;
            boolean bl2 = false;
            bl = (Boolean)it.invoke((Object)this.config, (Object)exception);
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper$Companion;", "", "()V", "LOG_TAG", "", "hcaptcha_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper$HCaptchaWebChromeClient;", "Landroid/webkit/WebChromeClient;", "()V", "onConsoleMessage", "", "consoleMessage", "Landroid/webkit/ConsoleMessage;", "onProgressChanged", "", "view", "Landroid/webkit/WebView;", "newProgress", "", "hcaptcha_release"})
    private static final class HCaptchaWebChromeClient
    extends WebChromeClient {
        public boolean onConsoleMessage(@NotNull ConsoleMessage consoleMessage) {
            Intrinsics.checkNotNullParameter((Object)consoleMessage, (String)"consoleMessage");
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onConsoleMessage " + consoleMessage.message()));
            return true;
        }

        public void onProgressChanged(@NotNull WebView view, int newProgress) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onProgressChanged " + newProgress + "%"));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J$\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u001a\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper$HCaptchaWebClient;", "Landroid/webkit/WebViewClient;", "handler", "Landroid/os/Handler;", "listener", "Lcom/stripe/hcaptcha/HCaptchaStateListener;", "(Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper;Landroid/os/Handler;Lcom/stripe/hcaptcha/HCaptchaStateListener;)V", "onLoadResource", "", "view", "Landroid/webkit/WebView;", "url", "", "onPageFinished", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "onReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "shouldInterceptRequest", "stripUrl", "hcaptcha_release"})
    @SourceDebugExtension(value={"SMAP\nHCaptchaWebViewHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCaptchaWebViewHelper.kt\ncom/stripe/hcaptcha/webview/HCaptchaWebViewHelper$HCaptchaWebClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,165:1\n731#2,9:166\n37#3,2:175\n*S KotlinDebug\n*F\n+ 1 HCaptchaWebViewHelper.kt\ncom/stripe/hcaptcha/webview/HCaptchaWebViewHelper$HCaptchaWebClient\n*L\n100#1:166,9\n100#1:175,2\n*E\n"})
    private final class HCaptchaWebClient
    extends WebViewClient {
        @NotNull
        private final Handler handler;
        @NotNull
        private final HCaptchaStateListener listener;

        public HCaptchaWebClient(@NotNull Handler handler, HCaptchaStateListener listener2) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.handler = handler;
            this.listener = listener2;
        }

        /*
         * WARNING - void declaration
         */
        private final String stripUrl(String url) {
            Object object;
            block7: {
                block6: {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    object = url;
                    if (object == null) break block6;
                    String it = object;
                    boolean bl = false;
                    Object object2 = it;
                    Regex regex = new Regex("[?#]");
                    int n = 0;
                    object2 = regex.split((CharSequence)object2, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it2 = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            if (((CharSequence)it2).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String string = thisCollection$iv.toArray(new String[0])[0] + "...";
                    object = string;
                    if (string != null) break block7;
                }
                object = "null";
            }
            return object;
        }

        @Nullable
        public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Uri requestUri = request.getUrl();
            if (requestUri != null && requestUri.getScheme() != null && Intrinsics.areEqual((Object)requestUri.getScheme(), (Object)"http")) {
                this.handler.post(() -> HCaptchaWebClient.shouldInterceptRequest$lambda$2(HCaptchaWebViewHelper.this, this, requestUri));
            }
            return super.shouldInterceptRequest(view, request);
        }

        public void onReceivedHttpError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceResponse errorResponse) {
            super.onReceivedHttpError(view, request, errorResponse);
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)"[webview] onReceivedHttpError");
        }

        public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onPageStarted " + this.stripUrl(url)));
        }

        public void onLoadResource(@Nullable WebView view, @Nullable String url) {
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onLoadResource " + this.stripUrl(url)));
        }

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onPageFinished " + this.stripUrl(url)));
        }

        public void onReceivedError(@NotNull WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.onReceivedError(view, request, error);
            if (Build.VERSION.SDK_INT >= 23) {
                WebResourceError webResourceError = error;
                WebResourceError webResourceError2 = error;
                Log.d((String)HCaptchaWebViewHelper.LOG_TAG, (String)("[webview] onReceivedError \"" + (webResourceError != null ? webResourceError.getDescription() : null) + "\" (" + (webResourceError2 != null ? Integer.valueOf(webResourceError2.getErrorCode()) : null) + ")"));
            }
        }

        private static final void shouldInterceptRequest$lambda$2(HCaptchaWebViewHelper this$0, HCaptchaWebClient this$1, Uri $requestUri) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            this$0.getWebView$hcaptcha_release().removeJavascriptInterface("JSInterface");
            this$0.getWebView$hcaptcha_release().removeJavascriptInterface("JSDI");
            this$1.listener.getOnFailure().invoke((Object)new HCaptchaException(HCaptchaError.INSECURE_HTTP_REQUEST_ERROR, "Insecure resource " + $requestUri + " requested"));
        }
    }
}

