/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.InflateException;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.stripe.hcaptcha.HCaptchaCompat;
import com.stripe.hcaptcha.HCaptchaError;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.HCaptchaStateListener;
import com.stripe.hcaptcha.IHCaptchaVerifier;
import com.stripe.hcaptcha.R;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.config.HCaptchaInternalConfig;
import com.stripe.hcaptcha.config.HCaptchaSize;
import com.stripe.hcaptcha.webview.HCaptchaWebView;
import com.stripe.hcaptcha.webview.HCaptchaWebViewHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\"\u0010)\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/stripe/hcaptcha/HCaptchaDialogFragment;", "Landroidx/fragment/app/DialogFragment;", "Lcom/stripe/hcaptcha/IHCaptchaVerifier;", "<init>", "()V", "webViewHelper", "Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper;", "loadingContainer", "Landroid/widget/LinearLayout;", "defaultDimAmount", "", "readyForInteraction", "", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onStart", "onCancel", "dialogInterface", "Landroid/content/DialogInterface;", "hideLoadingContainer", "onLoaded", "onOpen", "onFailure", "exception", "Lcom/stripe/hcaptcha/HCaptchaException;", "onSuccess", "result", "", "startVerification", "activity", "Landroidx/fragment/app/FragmentActivity;", "reset", "prepareRootView", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "prepareWebView", "Lcom/stripe/hcaptcha/webview/HCaptchaWebView;", "rootView", "Companion", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nHCaptchaDialogFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCaptchaDialogFragment.kt\ncom/stripe/hcaptcha/HCaptchaDialogFragment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1#2:304\n*E\n"})
public final class HCaptchaDialogFragment
extends DialogFragment
implements IHCaptchaVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HCaptchaWebViewHelper webViewHelper;
    @Nullable
    private LinearLayout loadingContainer;
    private float defaultDimAmount = 0.6f;
    private boolean readyForInteraction;
    private static final String TAG = HCaptchaDialogFragment.class.getSimpleName();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(2, R.style.StripeHCaptchaDialogTheme);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
            Object listener = null;
            try {
                void $this$onCreateView_u24lambda_u240;
                Bundle args = this.getArguments();
                if (args == null) {
                    this.dismiss();
                    return null;
                }
                listener = HCaptchaCompat.INSTANCE.getStateListener(args);
                if (listener == null) {
                    this.dismiss();
                    return null;
                }
                HCaptchaConfig config = HCaptchaCompat.INSTANCE.getConfig(args);
                if (config == null) {
                    this.dismiss();
                    ((HCaptchaStateListener)listener).getOnFailure().invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
                    return null;
                }
                HCaptchaInternalConfig internalConfig = HCaptchaCompat.INSTANCE.getInternalConfig(args);
                if (internalConfig == null) {
                    this.dismiss();
                    ((HCaptchaStateListener)listener).getOnFailure().invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
                    return null;
                }
                View rootView = this.prepareRootView(inflater, container, config);
                HCaptchaWebView webView = this.prepareWebView(rootView, config);
                View view = rootView.findViewById(R.id.loadingContainer);
                LinearLayout linearLayout = (LinearLayout)view;
                HCaptchaDialogFragment hCaptchaDialogFragment = this;
                boolean bl = false;
                $this$onCreateView_u24lambda_u240.setVisibility(config.getLoading() ? 0 : 8);
                hCaptchaDialogFragment.loadingContainer = (LinearLayout)view;
                Handler handler = new Handler(Looper.getMainLooper());
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
                this.webViewHelper = new HCaptchaWebViewHelper(handler, context, config, internalConfig, this, (HCaptchaStateListener)listener, webView);
                this.readyForInteraction = false;
                return rootView;
            }
            catch (AssertionError e) {
                this.dismiss();
                Object object = listener;
                if (object == null || (object = object.getOnFailure()) == null) break block9;
                Function1<HCaptchaException, Unit> it = object;
                boolean bl = false;
                it.invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
            }
            catch (BadParcelableException e) {
                this.dismiss();
                Object object = listener;
                if (object == null || (object = object.getOnFailure()) == null) break block9;
                Function1<HCaptchaException, Unit> it = object;
                boolean bl = false;
                it.invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
            }
            catch (InflateException e) {
                this.dismiss();
                Object object = listener;
                if (object == null || (object = object.getOnFailure()) == null) break block9;
                Function1<HCaptchaException, Unit> it = object;
                boolean bl = false;
                it.invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
            }
            catch (ClassCastException e) {
                this.dismiss();
                Object object = listener;
                if (object == null || (object = object.getOnFailure()) == null) break block9;
                Function1<HCaptchaException, Unit> it = object;
                boolean bl = false;
                it.invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
            }
        }
        return null;
    }

    public void onDestroy() {
        block0: {
            super.onDestroy();
            HCaptchaWebViewHelper hCaptchaWebViewHelper = this.webViewHelper;
            if (hCaptchaWebViewHelper == null) break block0;
            hCaptchaWebViewHelper.destroy();
        }
    }

    public void onStart() {
        Dialog dialog;
        super.onStart();
        Dialog dialog2 = dialog = this.getDialog();
        Window window = dialog2 != null ? dialog2.getWindow() : null;
        HCaptchaWebViewHelper webViewHelper = this.webViewHelper;
        if (dialog != null && window != null && webViewHelper != null) {
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.defaultDimAmount = window.getAttributes().dimAmount;
            if (!webViewHelper.getConfig$hcaptcha_release().getLoading()) {
                window.clearFlags(2);
                window.setDimAmount(0.0f);
            }
        }
    }

    public void onCancel(@NotNull DialogInterface dialogInterface) {
        Intrinsics.checkNotNullParameter((Object)dialogInterface, (String)"dialogInterface");
        super.onCancel(dialogInterface);
        this.onFailure(new HCaptchaException(HCaptchaError.CHALLENGE_CLOSED, null, 2, null));
    }

    private final void hideLoadingContainer() {
        block1: {
            Dialog dialog;
            block0: {
                LinearLayout linearLayout;
                Object object = this.webViewHelper;
                boolean bl = object != null && (object = ((HCaptchaWebViewHelper)object).getConfig$hcaptcha_release()) != null ? ((HCaptchaConfig)object).getLoading() : false;
                if (!bl) break block0;
                LinearLayout linearLayout2 = this.loadingContainer;
                if (linearLayout2 == null) break block1;
                LinearLayout $this$hideLoadingContainer_u24lambda_u245 = linearLayout = linearLayout2;
                boolean bl2 = false;
                $this$hideLoadingContainer_u24lambda_u245.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter($this$hideLoadingContainer_u24lambda_u245){
                    final /* synthetic */ LinearLayout $this_apply;
                    {
                        this.$this_apply = $receiver;
                    }

                    public void onAnimationEnd(Animator animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        this.$this_apply.setVisibility(8);
                    }
                });
                break block1;
            }
            Dialog dialog2 = this.getDialog();
            if (dialog2 == null || (dialog2 = dialog2.getWindow()) == null) break block1;
            Dialog $this$hideLoadingContainer_u24lambda_u246 = dialog = dialog2;
            boolean bl = false;
            $this$hideLoadingContainer_u24lambda_u246.addFlags(2);
            $this$hideLoadingContainer_u24lambda_u246.setDimAmount(this.defaultDimAmount);
        }
    }

    @Override
    public void onLoaded() {
        Object object = this.webViewHelper;
        if ((object != null && (object = ((HCaptchaWebViewHelper)object).getConfig$hcaptcha_release()) != null ? ((HCaptchaConfig)object).getSize() : null) != HCaptchaSize.INVISIBLE) {
            this.readyForInteraction = true;
            this.hideLoadingContainer();
        }
    }

    @Override
    public void onOpen() {
        block1: {
            Object object = this.webViewHelper;
            if ((object != null && (object = ((HCaptchaWebViewHelper)object).getConfig$hcaptcha_release()) != null ? ((HCaptchaConfig)object).getSize() : null) == HCaptchaSize.INVISIBLE) {
                this.hideLoadingContainer();
            }
            this.readyForInteraction = true;
            Object object2 = this.webViewHelper;
            if (object2 == null || (object2 = ((HCaptchaWebViewHelper)object2).getListener$hcaptcha_release()) == null) break block1;
            ((HCaptchaStateListener)object2).getOnOpen();
        }
    }

    @Override
    public void onFailure(@NotNull HCaptchaException exception) {
        block3: {
            HCaptchaWebViewHelper hCaptchaWebViewHelper;
            boolean silentRetry;
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            HCaptchaWebViewHelper hCaptchaWebViewHelper2 = this.webViewHelper;
            boolean bl = hCaptchaWebViewHelper2 != null ? hCaptchaWebViewHelper2.shouldRetry(exception) : (silentRetry = false);
            if (this.isAdded() && !silentRetry) {
                this.dismissAllowingStateLoss();
            }
            HCaptchaWebViewHelper hCaptchaWebViewHelper3 = this.webViewHelper;
            if (hCaptchaWebViewHelper3 == null) break block3;
            HCaptchaWebViewHelper $this$onFailure_u24lambda_u247 = hCaptchaWebViewHelper = hCaptchaWebViewHelper3;
            boolean bl2 = false;
            if (silentRetry) {
                $this$onFailure_u24lambda_u247.resetAndExecute();
            } else {
                $this$onFailure_u24lambda_u247.getListener$hcaptcha_release().getOnFailure().invoke((Object)exception);
            }
        }
    }

    @Override
    public void onSuccess(@NotNull String result) {
        block1: {
            Function1<String, Unit> function1;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (this.isAdded()) {
                this.dismissAllowingStateLoss();
            }
            if ((function1 = this.webViewHelper) == null || (function1 = function1.getListener$hcaptcha_release()) == null || (function1 = function1.getOnSuccess()) == null) break block1;
            Function1<String, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)result);
        }
    }

    @Override
    public void startVerification(@NotNull FragmentActivity activity) {
        block3: {
            Fragment oldFragment;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
            FragmentManager fragmentManager2 = fragmentManager;
            Fragment fragment = oldFragment = fragmentManager2.findFragmentByTag(TAG);
            boolean bl = fragment != null ? fragment.isAdded() : false;
            if (bl) {
                return;
            }
            try {
                this.show(fragmentManager2, TAG);
            }
            catch (IllegalStateException e) {
                Function1<HCaptchaException, Unit> function1 = this.webViewHelper;
                if (function1 == null || (function1 = function1.getListener$hcaptcha_release()) == null || (function1 = function1.getOnFailure()) == null) break block3;
                Function1<HCaptchaException, Unit> it = function1;
                boolean bl2 = false;
                it.invoke((Object)new HCaptchaException(HCaptchaError.ERROR, null, 2, null));
            }
        }
    }

    @Override
    public void reset() {
        if (this.webViewHelper != null) {
            HCaptchaWebViewHelper hCaptchaWebViewHelper = this.webViewHelper;
            Intrinsics.checkNotNull((Object)hCaptchaWebViewHelper);
            hCaptchaWebViewHelper.reset();
        }
        if (this.isAdded()) {
            this.dismissAllowingStateLoss();
        }
    }

    private final View prepareRootView(LayoutInflater inflater, ViewGroup container, HCaptchaConfig config) {
        View view = inflater.inflate(R.layout.stripe_hcaptcha_fragment, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"inflate(...)");
        View rootView = view;
        rootView.setFocusableInTouchMode(true);
        rootView.requestFocus();
        rootView.setOnKeyListener((arg_0, arg_1, arg_2) -> HCaptchaDialogFragment.prepareRootView$lambda$10(this, config, arg_0, arg_1, arg_2));
        return rootView;
    }

    private final HCaptchaWebView prepareWebView(View rootView, HCaptchaConfig config) {
        HCaptchaWebView webView = (HCaptchaWebView)rootView.findViewById(R.id.webView);
        if (!config.getLoading()) {
            webView.setOnTouchListener((arg_0, arg_1) -> HCaptchaDialogFragment.prepareWebView$lambda$12(this, arg_0, arg_1));
        }
        Intrinsics.checkNotNull((Object)((Object)webView));
        return webView;
    }

    private static final boolean prepareRootView$lambda$10(HCaptchaDialogFragment this$0, HCaptchaConfig $config, View view, int keyCode, KeyEvent event) {
        boolean withoutLoadingUI;
        boolean backDown;
        boolean bl = backDown = keyCode == 4 && event.getAction() == 0;
        if (!backDown) {
            return false;
        }
        boolean bl2 = withoutLoadingUI = !this$0.readyForInteraction && !$config.getLoading();
        if (withoutLoadingUI) {
            return true;
        }
        HCaptchaWebViewHelper hCaptchaWebViewHelper = this$0.webViewHelper;
        return hCaptchaWebViewHelper != null ? hCaptchaWebViewHelper.shouldRetry(new HCaptchaException(HCaptchaError.CHALLENGE_CLOSED, null, 2, null)) : false;
    }

    private static final boolean prepareWebView$lambda$12(HCaptchaDialogFragment this$0, View view, MotionEvent event) {
        FragmentActivity fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this$0.readyForInteraction && this$0.isAdded() && (fragmentActivity = this$0.getActivity()) != null) {
            FragmentActivity $this$prepareWebView_u24lambda_u2412_u24lambda_u2411 = fragmentActivity;
            boolean bl = false;
            $this$prepareWebView_u24lambda_u2412_u24lambda_u2411.dispatchTouchEvent(event);
            return true;
        }
        return view.performClick();
    }

    @JvmStatic
    @NotNull
    public static final HCaptchaDialogFragment newInstance(@NotNull HCaptchaConfig config, @NotNull HCaptchaInternalConfig internalConfig, @NotNull HCaptchaStateListener listener) {
        return Companion.newInstance(config, internalConfig, listener);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/stripe/hcaptcha/HCaptchaDialogFragment$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "newInstance", "Lcom/stripe/hcaptcha/HCaptchaDialogFragment;", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "internalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "listener", "Lcom/stripe/hcaptcha/HCaptchaStateListener;", "hcaptcha_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HCaptchaDialogFragment newInstance(@NotNull HCaptchaConfig config, @NotNull HCaptchaInternalConfig internalConfig, @NotNull HCaptchaStateListener listener) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            HCaptchaDialogFragment hCaptchaDialogFragment = new HCaptchaDialogFragment();
            hCaptchaDialogFragment.setArguments(HCaptchaCompat.INSTANCE.storeValues(config, internalConfig, listener));
            return hCaptchaDialogFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

