/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.webview;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.JavascriptInterface;
import androidx.annotation.RestrictTo;
import com.stripe.hcaptcha.encode.EncodeKt;
import dalvik.system.DexFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaDebugInfo;", "Ljava/io/Serializable;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "debugInfo$delegate", "Lkotlin/Lazy;", "sysDebug", "getSysDebug", "sysDebug$delegate", "", "packageName", "packageCode", "roBuildProps", "", "Companion", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nHCaptchaDebugInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCaptchaDebugInfo.kt\ncom/stripe/hcaptcha/webview/HCaptchaDebugInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n1#2:120\n739#3,9:121\n37#4:130\n36#4,3:131\n*S KotlinDebug\n*F\n+ 1 HCaptchaDebugInfo.kt\ncom/stripe/hcaptcha/webview/HCaptchaDebugInfo\n*L\n96#1:121,9\n96#1:130\n96#1:131,3\n*E\n"})
public final class HCaptchaDebugInfo
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy debugInfo$delegate;
    @NotNull
    private final Lazy sysDebug$delegate;
    private static final long serialVersionUID = -2969617621043154137L;
    @NotNull
    public static final String JS_INTERFACE_TAG = "JSDI";
    @NotNull
    private static final String GET_PROP_BIN = "/system/bin/getprop";
    @NotNull
    private static final String CHARSET_NAME = "UTF-8";

    public HCaptchaDebugInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.debugInfo$delegate = LazyKt.lazy(() -> HCaptchaDebugInfo.debugInfo_delegate$lambda$0(this));
        this.sysDebug$delegate = LazyKt.lazy(() -> HCaptchaDebugInfo.sysDebug_delegate$lambda$1(this));
    }

    @JavascriptInterface
    @NotNull
    public final String getDebugInfo() {
        Lazy lazy = this.debugInfo$delegate;
        return (String)lazy.getValue();
    }

    @JavascriptInterface
    @NotNull
    public final String getSysDebug() {
        Lazy lazy = this.sysDebug$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> debugInfo(String packageName, String packageCode) throws IOException, NoSuchAlgorithmException {
        List result = new ArrayList(512);
        MessageDigest androidMd5 = MessageDigest.getInstance("MD5");
        MessageDigest appMd5 = MessageDigest.getInstance("MD5");
        MessageDigest depsMd5 = MessageDigest.getInstance("MD5");
        try (DexFile dexFile = new DexFile(packageCode);){
            Enumeration classes = dexFile.entries();
            while (classes.hasMoreElements()) {
                String cls = (String)classes.nextElement();
                Intrinsics.checkNotNull((Object)cls);
                if (StringsKt.startsWith$default((String)cls, (String)"com.google.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)cls, (String)"android.", (boolean)false, (int)2, null)) {
                    Charset charset = Charset.forName(CHARSET_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                    byte[] byArray = cls.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    androidMd5.update(byArray);
                    continue;
                }
                String string = packageName;
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith$default((String)cls, (String)string, (boolean)false, (int)2, null)) {
                    Charset charset = Charset.forName(CHARSET_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                    byte[] byArray = cls.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    appMd5.update(byArray);
                    continue;
                }
                Charset charset = Charset.forName(CHARSET_NAME);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray = cls.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                depsMd5.update(byArray);
            }
        }
        String hexFormat = "%032x";
        Object[] objectArray = new Object[]{new BigInteger(1, androidMd5.digest())};
        String string = String.format(hexFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        result.add("sys_" + string);
        objectArray = new Object[]{new BigInteger(1, depsMd5.digest())};
        String string2 = String.format(hexFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        result.add("deps_" + string2);
        objectArray = new Object[]{new BigInteger(1, appMd5.digest())};
        String string3 = String.format(hexFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        result.add("app_" + string3);
        result.add("aver_" + Build.VERSION.RELEASE);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, String> roBuildProps() throws IOException {
        Process getpropProcess = null;
        Map props = new HashMap();
        try {
            Object object = new String[]{GET_PROP_BIN};
            getpropProcess = new ProcessBuilder((String)object).start();
            object = new BufferedReader(new InputStreamReader(getpropProcess.getInputStream(), CHARSET_NAME));
            Throwable throwable = null;
            try {
                BufferedReader br = (BufferedReader)object;
                boolean bl = false;
                String line = null;
                StringBuilder entry = new StringBuilder();
                while (true) {
                    String value;
                    String key;
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    String string = br.readLine();
                    Object it = string;
                    boolean $i$a$-also-HCaptchaDebugInfo$roBuildProps$1$22 = false;
                    line = it;
                    if (string == null) break;
                    if (!StringsKt.endsWith$default((String)line, (String)"]", (boolean)false, (int)2, null)) {
                        entry.append(line);
                        continue;
                    }
                    entry.replace(0, entry.length() == 0 ? 0 : entry.length() - 1, line);
                    String string2 = entry.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    it = string2;
                    Regex $i$a$-also-HCaptchaDebugInfo$roBuildProps$1$22 = new Regex("]: \\[");
                    int n = 0;
                    it = $i$a$-also-HCaptchaDebugInfo$roBuildProps$1$22.split((CharSequence)it, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it2 = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            if (((CharSequence)it2).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parsedLine = thisCollection$iv.toArray(new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)parsedLine[0].substring(1), (String)"substring(...)");
                    if (!StringsKt.startsWith$default((String)key, (String)"ro", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)parsedLine[1].substring(0, parsedLine[1].length() - 2), (String)"substring(...)");
                    props.put(key, value);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        finally {
            Process process = getpropProcess;
            if (process != null) {
                process.destroy();
            }
        }
        return props;
    }

    private static final String debugInfo_delegate$lambda$0(HCaptchaDebugInfo this$0) {
        String string;
        try {
            string = EncodeKt.encodeToJson((SerializationStrategy)BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)), this$0.debugInfo(this$0.context.getPackageName(), this$0.context.getPackageCodePath()));
        }
        catch (IOException e) {
            Log.d((String)JS_INTERFACE_TAG, (String)"Cannot build debugInfo");
            string = "[]";
        }
        return string;
    }

    private static final String sysDebug_delegate$lambda$1(HCaptchaDebugInfo this$0) {
        String string;
        try {
            string = EncodeKt.encodeToJson((SerializationStrategy)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)), this$0.roBuildProps());
        }
        catch (IOException e) {
            Log.d((String)JS_INTERFACE_TAG, (String)"Cannot build sysDebug");
            string = "{}";
        }
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaDebugInfo$Companion;", "", "<init>", "()V", "serialVersionUID", "", "JS_INTERFACE_TAG", "", "GET_PROP_BIN", "CHARSET_NAME", "hcaptcha_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

