/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.hcaptcha.webview;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import com.stripe.hcaptcha.HCaptchaException;
import com.stripe.hcaptcha.HCaptchaStateListener;
import com.stripe.hcaptcha.IHCaptchaVerifier;
import com.stripe.hcaptcha.R;
import com.stripe.hcaptcha.config.HCaptchaConfig;
import com.stripe.hcaptcha.config.HCaptchaInternalConfig;
import com.stripe.hcaptcha.webview.HCaptchaWebView;
import com.stripe.hcaptcha.webview.HCaptchaWebViewHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/hcaptcha/webview/HCaptchaHeadlessWebView;", "Lcom/stripe/hcaptcha/IHCaptchaVerifier;", "activity", "Landroid/app/Activity;", "config", "Lcom/stripe/hcaptcha/config/HCaptchaConfig;", "internalConfig", "Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;", "listener", "Lcom/stripe/hcaptcha/HCaptchaStateListener;", "<init>", "(Landroid/app/Activity;Lcom/stripe/hcaptcha/config/HCaptchaConfig;Lcom/stripe/hcaptcha/config/HCaptchaInternalConfig;Lcom/stripe/hcaptcha/HCaptchaStateListener;)V", "webViewHelper", "Lcom/stripe/hcaptcha/webview/HCaptchaWebViewHelper;", "webViewLoaded", "", "shouldExecuteOnLoad", "shouldResetOnLoad", "startVerification", "", "Landroidx/fragment/app/FragmentActivity;", "onFailure", "exception", "Lcom/stripe/hcaptcha/HCaptchaException;", "onSuccess", "result", "", "onLoaded", "onOpen", "reset", "hcaptcha_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HCaptchaHeadlessWebView
implements IHCaptchaVerifier {
    @NotNull
    private final HCaptchaStateListener listener;
    @NotNull
    private final HCaptchaWebViewHelper webViewHelper;
    private boolean webViewLoaded;
    private boolean shouldExecuteOnLoad;
    private boolean shouldResetOnLoad;

    public HCaptchaHeadlessWebView(@NotNull Activity activity, @NotNull HCaptchaConfig config, @NotNull HCaptchaInternalConfig internalConfig, @NotNull HCaptchaStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        WebView webView = new HCaptchaWebView((Context)activity);
        webView.setId(R.id.webView);
        webView.setVisibility(8);
        if (webView.getParent() == null) {
            View view = activity.getWindow().getDecorView().getRootView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ViewGroup rootView = (ViewGroup)view;
            rootView.addView((View)webView);
        }
        this.webViewHelper = new HCaptchaWebViewHelper(new Handler(Looper.getMainLooper()), (Context)activity, config, internalConfig, this, this.listener, webView);
    }

    @Override
    public void startVerification(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.webViewLoaded) {
            this.webViewHelper.resetAndExecute();
        } else {
            this.shouldExecuteOnLoad = true;
        }
    }

    @Override
    public void onFailure(@NotNull HCaptchaException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        boolean silentRetry = this.webViewHelper.shouldRetry(exception);
        if (silentRetry) {
            this.webViewHelper.resetAndExecute();
        } else {
            this.listener.getOnFailure().invoke((Object)exception);
        }
    }

    @Override
    public void onSuccess(@NotNull String result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.listener.getOnSuccess().invoke((Object)result);
    }

    @Override
    public void onLoaded() {
        this.webViewLoaded = true;
        if (this.shouldResetOnLoad) {
            this.shouldResetOnLoad = false;
            this.reset();
        } else if (this.shouldExecuteOnLoad) {
            this.shouldExecuteOnLoad = false;
            this.webViewHelper.resetAndExecute();
        }
    }

    @Override
    public void onOpen() {
        this.listener.getOnOpen().invoke();
    }

    @Override
    public void reset() {
        if (this.webViewLoaded) {
            this.webViewHelper.reset();
            WebView webView = this.webViewHelper.getWebView$hcaptcha_release();
            if (webView.getParent() != null) {
                ViewParent viewParent = webView.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                ((ViewGroup)viewParent).removeView((View)webView);
            }
        } else {
            this.shouldResetOnLoad = true;
        }
    }
}

