/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.app.Application;
import android.content.Context;
import androidx.activity.result.ActivityResultCaller;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.injection.WeakMapInjectorRegistry;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.confirmation.ConfirmationManager;
import com.stripe.android.link.injection.DaggerLinkViewModelFactoryComponent;
import com.stripe.android.link.injection.LinkViewModelFactoryComponent;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.link.model.Navigator;
import com.stripe.android.link.ui.cardedit.CardEditViewModel;
import com.stripe.android.link.ui.paymentmethod.PaymentMethodViewModel;
import com.stripe.android.link.ui.signup.SignUpViewModel;
import com.stripe.android.link.ui.verification.VerificationViewModel;
import com.stripe.android.link.ui.wallet.WalletViewModel;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.ui.core.injection.NonFallbackInjector;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001$B'\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/stripe/android/link/LinkActivityViewModel;", "Landroidx/lifecycle/ViewModel;", "args", "Lcom/stripe/android/link/LinkActivityContract$Args;", "linkAccountManager", "Lcom/stripe/android/link/account/LinkAccountManager;", "navigator", "Lcom/stripe/android/link/model/Navigator;", "confirmationManager", "Lcom/stripe/android/link/confirmation/ConfirmationManager;", "(Lcom/stripe/android/link/LinkActivityContract$Args;Lcom/stripe/android/link/account/LinkAccountManager;Lcom/stripe/android/link/model/Navigator;Lcom/stripe/android/link/confirmation/ConfirmationManager;)V", "injector", "Lcom/stripe/android/ui/core/injection/NonFallbackInjector;", "getInjector", "()Lcom/stripe/android/ui/core/injection/NonFallbackInjector;", "setInjector", "(Lcom/stripe/android/ui/core/injection/NonFallbackInjector;)V", "linkAccount", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/link/model/LinkAccount;", "getLinkAccount", "()Lkotlinx/coroutines/flow/StateFlow;", "getLinkAccountManager", "()Lcom/stripe/android/link/account/LinkAccountManager;", "getNavigator", "()Lcom/stripe/android/link/model/Navigator;", "assertStripeIntentIsValid", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "logout", "onBackPressed", "setupPaymentLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "unregisterFromActivity", "Factory", "link_release"})
public final class LinkActivityViewModel
extends ViewModel {
    @NotNull
    private final LinkAccountManager linkAccountManager;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final ConfirmationManager confirmationManager;
    public NonFallbackInjector injector;
    @NotNull
    private final StateFlow<LinkAccount> linkAccount;

    @Inject
    public LinkActivityViewModel(@NotNull LinkActivityContract.Args args, @NotNull LinkAccountManager linkAccountManager, @NotNull Navigator navigator, @NotNull ConfirmationManager confirmationManager) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)linkAccountManager, (String)"linkAccountManager");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)confirmationManager, (String)"confirmationManager");
        this.linkAccountManager = linkAccountManager;
        this.navigator = navigator;
        this.confirmationManager = confirmationManager;
        this.linkAccount = this.linkAccountManager.getLinkAccount();
        this.assertStripeIntentIsValid(args.getStripeIntent$link_release());
    }

    @NotNull
    public final LinkAccountManager getLinkAccountManager() {
        return this.linkAccountManager;
    }

    @NotNull
    public final Navigator getNavigator() {
        return this.navigator;
    }

    @NotNull
    public final NonFallbackInjector getInjector() {
        NonFallbackInjector nonFallbackInjector = this.injector;
        if (nonFallbackInjector != null) {
            return nonFallbackInjector;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"injector");
        return null;
    }

    public final void setInjector(@NotNull NonFallbackInjector nonFallbackInjector) {
        Intrinsics.checkNotNullParameter((Object)nonFallbackInjector, (String)"<set-?>");
        this.injector = nonFallbackInjector;
    }

    @NotNull
    public final StateFlow<LinkAccount> getLinkAccount() {
        return this.linkAccount;
    }

    public final void setupPaymentLauncher(@NotNull ActivityResultCaller activityResultCaller) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        this.confirmationManager.setupPaymentLauncher(activityResultCaller);
    }

    public final void onBackPressed() {
        this.navigator.onBack(true);
    }

    public final void logout() {
        this.navigator.cancel(LinkActivityResult.Canceled.Reason.LoggedOut);
        this.linkAccountManager.logout();
    }

    public final void unregisterFromActivity() {
        this.confirmationManager.invalidatePaymentLauncher();
    }

    private final void assertStripeIntentIsValid(StripeIntent stripeIntent) {
        block8: {
            Object object;
            Object object2 = this;
            try {
                String string;
                LinkActivityViewModel $this$assertStripeIntentIsValid_u24lambda_u2d1 = object2;
                boolean bl = false;
                if (stripeIntent.getId() == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (stripeIntent.getClientSecret() == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                PaymentIntent paymentIntent = stripeIntent instanceof PaymentIntent ? (PaymentIntent)stripeIntent : null;
                if (paymentIntent != null) {
                    PaymentIntent it = paymentIntent;
                    boolean bl2 = false;
                    if (((PaymentIntent)stripeIntent).getAmount() == null) {
                        String string4 = "Required value was null.";
                        throw new IllegalArgumentException(string4.toString());
                    }
                    string = ((PaymentIntent)stripeIntent).getCurrency();
                    if (string == null) {
                        String string5 = "Required value was null.";
                        throw new IllegalArgumentException(string5.toString());
                    }
                } else {
                    string = null;
                }
                object = Result.constructor-impl(string);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block8;
            Object it = object = throwable;
            boolean bl = false;
            this.navigator.dismiss(new LinkActivityResult.Failed((Throwable)it));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001bB!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ%\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/link/LinkActivityViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "Lcom/stripe/android/core/injection/Injectable;", "Lcom/stripe/android/link/LinkActivityViewModel$Factory$FallbackInitializeParam;", "applicationSupplier", "Lkotlin/Function0;", "Landroid/app/Application;", "starterArgsSupplier", "Lcom/stripe/android/link/LinkActivityContract$Args;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "injector", "Lcom/stripe/android/ui/core/injection/NonFallbackInjector;", "viewModel", "Lcom/stripe/android/link/LinkActivityViewModel;", "getViewModel", "()Lcom/stripe/android/link/LinkActivityViewModel;", "setViewModel", "(Lcom/stripe/android/link/LinkActivityViewModel;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "fallbackInitialize", "", "arg", "FallbackInitializeParam", "link_release"})
    public static final class Factory
    implements ViewModelProvider.Factory,
    Injectable<FallbackInitializeParam> {
        @NotNull
        private final Function0<Application> applicationSupplier;
        @NotNull
        private final Function0<LinkActivityContract.Args> starterArgsSupplier;
        @Inject
        public LinkActivityViewModel viewModel;
        private NonFallbackInjector injector;

        public Factory(@NotNull Function0<? extends Application> applicationSupplier, @NotNull Function0<LinkActivityContract.Args> starterArgsSupplier) {
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            this.applicationSupplier = applicationSupplier;
            this.starterArgsSupplier = starterArgsSupplier;
        }

        @NotNull
        public final LinkActivityViewModel getViewModel() {
            LinkActivityViewModel linkActivityViewModel = this.viewModel;
            if (linkActivityViewModel != null) {
                return linkActivityViewModel;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            return null;
        }

        public final void setViewModel(@NotNull LinkActivityViewModel linkActivityViewModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)linkActivityViewModel), (String)"<set-?>");
            this.viewModel = linkActivityViewModel;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            logger = Logger.Companion.getInstance(false);
            starterArgs = (LinkActivityContract.Args)this.starterArgsSupplier.invoke();
            var4_4 = starterArgs.getInjectionParams$link_release();
            if (var4_4 == null || (var5_5 = var4_4.getInjectorKey()) == null) ** GOTO lbl-1000
            it = var5_5;
            $i$a$-let-LinkActivityViewModel$Factory$create$1 = false;
            var6_9 = WeakMapInjectorRegistry.INSTANCE.retrieve(it);
            if (var6_9 == null) ** GOTO lbl-1000
            it = var6_9;
            $i$a$-let-LinkActivityViewModel$Factory$create$2 = false;
            var7_12 = it instanceof NonFallbackInjector ? (NonFallbackInjector)it : null;
            if (var7_12 != null) {
                it = var7_12;
                $i$a$-let-LinkActivityViewModel$Factory$create$3 = false;
                logger.info("Injector available, injecting dependencies into " + this.getClass().getCanonicalName());
                this.injector = it;
                it.inject((Injectable)this);
                v0 = Unit.INSTANCE;
            } else lbl-1000:
            // 3 sources

            {
                v0 = null;
            }
            if (v0 == null) {
                $this$create_u24lambda_u2d3 = this;
                $i$a$-run-LinkActivityViewModel$Factory$create$4 = false;
                logger.info("Injector unavailable, initializing dependencies of " + $this$create_u24lambda_u2d3.getClass().getCanonicalName());
                v1 = (Application)$this$create_u24lambda_u2d3.applicationSupplier.invoke();
                v2 = starterArgs.getInjectionParams$link_release();
                v3 = v2 != null ? v2.getEnableLogging() : false;
                v4 = starterArgs.getInjectionParams$link_release();
                if (v4 == null || (v4 = v4.getPublishableKey()) == null) {
                    v4 = PaymentConfiguration.Companion.getInstance((Context)$this$create_u24lambda_u2d3.applicationSupplier.invoke()).getPublishableKey();
                }
                v5 = starterArgs.getInjectionParams$link_release() != null ? starterArgs.getInjectionParams$link_release().getStripeAccountId() : PaymentConfiguration.Companion.getInstance((Context)$this$create_u24lambda_u2d3.applicationSupplier.invoke()).getStripeAccountId();
                v6 = starterArgs.getInjectionParams$link_release();
                if (v6 == null || (v6 = v6.getProductUsage()) == null) {
                    v6 = SetsKt.emptySet();
                }
                $this$create_u24lambda_u2d3.fallbackInitialize(new FallbackInitializeParam(v1, starterArgs, v3, (String)v4, v5, (Set<String>)v6));
            }
            v7 = this.getViewModel();
            v8 = this.injector;
            if (v8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"injector");
                v8 = null;
            }
            v7.setInjector(v8);
            v9 = this.getViewModel();
            Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type T of com.stripe.android.link.LinkActivityViewModel.Factory.create");
            return (T)v9;
        }

        public void fallbackInitialize(@NotNull FallbackInitializeParam arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            LinkViewModelFactoryComponent viewModelComponent2 = DaggerLinkViewModelFactoryComponent.builder().context((Context)arg.getApplication()).enableLogging(arg.getEnableLogging()).publishableKeyProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$arg.getPublishableKey();
                }
            })).stripeAccountIdProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return this.$arg.getStripeAccountId();
                }
            })).productUsage(arg.getProductUsage()).starterArgs(arg.getStarterArgs()).build();
            this.injector = new NonFallbackInjector(viewModelComponent2){
                final /* synthetic */ LinkViewModelFactoryComponent $viewModelComponent;
                {
                    this.$viewModelComponent = $viewModelComponent;
                }

                public void inject(@NotNull Injectable<?> injectable) {
                    Intrinsics.checkNotNullParameter(injectable, (String)"injectable");
                    Injectable<?> injectable2 = injectable;
                    if (injectable2 instanceof Factory) {
                        this.$viewModelComponent.inject((Factory)injectable);
                    } else if (injectable2 instanceof SignUpViewModel.Factory) {
                        this.$viewModelComponent.inject((SignUpViewModel.Factory)injectable);
                    } else if (injectable2 instanceof VerificationViewModel.Factory) {
                        this.$viewModelComponent.inject((VerificationViewModel.Factory)injectable);
                    } else if (injectable2 instanceof WalletViewModel.Factory) {
                        this.$viewModelComponent.inject((WalletViewModel.Factory)injectable);
                    } else if (injectable2 instanceof PaymentMethodViewModel.Factory) {
                        this.$viewModelComponent.inject((PaymentMethodViewModel.Factory)injectable);
                    } else if (injectable2 instanceof CardEditViewModel.Factory) {
                        this.$viewModelComponent.inject((CardEditViewModel.Factory)injectable);
                    } else {
                        throw new IllegalArgumentException("invalid Injectable " + injectable + " requested in " + this);
                    }
                }
            };
            viewModelComponent2.inject(this);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u00c6\u0003JM\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/stripe/android/link/LinkActivityViewModel$Factory$FallbackInitializeParam;", "", "application", "Landroid/app/Application;", "starterArgs", "Lcom/stripe/android/link/LinkActivityContract$Args;", "enableLogging", "", "publishableKey", "", "stripeAccountId", "productUsage", "", "(Landroid/app/Application;Lcom/stripe/android/link/LinkActivityContract$Args;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getApplication", "()Landroid/app/Application;", "getEnableLogging", "()Z", "getProductUsage", "()Ljava/util/Set;", "getPublishableKey", "()Ljava/lang/String;", "getStarterArgs", "()Lcom/stripe/android/link/LinkActivityContract$Args;", "getStripeAccountId", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "link_release"})
        public static final class FallbackInitializeParam {
            @NotNull
            private final Application application;
            @NotNull
            private final LinkActivityContract.Args starterArgs;
            private final boolean enableLogging;
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final Set<String> productUsage;

            public FallbackInitializeParam(@NotNull Application application, @NotNull LinkActivityContract.Args starterArgs2, boolean enableLogging, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)starterArgs2, (String)"starterArgs");
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                this.application = application;
                this.starterArgs = starterArgs2;
                this.enableLogging = enableLogging;
                this.publishableKey = publishableKey;
                this.stripeAccountId = stripeAccountId;
                this.productUsage = productUsage;
            }

            @NotNull
            public final Application getApplication() {
                return this.application;
            }

            @NotNull
            public final LinkActivityContract.Args getStarterArgs() {
                return this.starterArgs;
            }

            public final boolean getEnableLogging() {
                return this.enableLogging;
            }

            @NotNull
            public final String getPublishableKey() {
                return this.publishableKey;
            }

            @Nullable
            public final String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> getProductUsage() {
                return this.productUsage;
            }

            @NotNull
            public final Application component1() {
                return this.application;
            }

            @NotNull
            public final LinkActivityContract.Args component2() {
                return this.starterArgs;
            }

            public final boolean component3() {
                return this.enableLogging;
            }

            @NotNull
            public final String component4() {
                return this.publishableKey;
            }

            @Nullable
            public final String component5() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> component6() {
                return this.productUsage;
            }

            @NotNull
            public final FallbackInitializeParam copy(@NotNull Application application, @NotNull LinkActivityContract.Args starterArgs2, boolean enableLogging, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)starterArgs2, (String)"starterArgs");
                Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                return new FallbackInitializeParam(application, starterArgs2, enableLogging, publishableKey, stripeAccountId, productUsage);
            }

            public static /* synthetic */ FallbackInitializeParam copy$default(FallbackInitializeParam fallbackInitializeParam, Application application, LinkActivityContract.Args args, boolean bl, String string, String string2, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    application = fallbackInitializeParam.application;
                }
                if ((n & 2) != 0) {
                    args = fallbackInitializeParam.starterArgs;
                }
                if ((n & 4) != 0) {
                    bl = fallbackInitializeParam.enableLogging;
                }
                if ((n & 8) != 0) {
                    string = fallbackInitializeParam.publishableKey;
                }
                if ((n & 0x10) != 0) {
                    string2 = fallbackInitializeParam.stripeAccountId;
                }
                if ((n & 0x20) != 0) {
                    set = fallbackInitializeParam.productUsage;
                }
                return fallbackInitializeParam.copy(application, args, bl, string, string2, set);
            }

            @NotNull
            public String toString() {
                return "FallbackInitializeParam(application=" + this.application + ", starterArgs=" + this.starterArgs + ", enableLogging=" + this.enableLogging + ", publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", productUsage=" + this.productUsage + ')';
            }

            public int hashCode() {
                int result = this.application.hashCode();
                result = result * 31 + this.starterArgs.hashCode();
                int n = this.enableLogging ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                result = result * 31 + this.publishableKey.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result = result * 31 + ((Object)this.productUsage).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FallbackInitializeParam)) {
                    return false;
                }
                FallbackInitializeParam fallbackInitializeParam = (FallbackInitializeParam)other;
                if (!Intrinsics.areEqual((Object)this.application, (Object)fallbackInitializeParam.application)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.starterArgs, (Object)fallbackInitializeParam.starterArgs)) {
                    return false;
                }
                if (this.enableLogging != fallbackInitializeParam.enableLogging) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)fallbackInitializeParam.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)fallbackInitializeParam.stripeAccountId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.productUsage, fallbackInitializeParam.productUsage);
            }
        }
    }
}

