/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.account;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.link.account.CookieStore;
import com.stripe.android.link.account.EncryptedStore;
import java.security.MessageDigest;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000f\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u000f\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\f\u0010\u001d\u001a\u00020\u000b*\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/link/account/CookieStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "store", "Lcom/stripe/android/link/account/EncryptedStore;", "(Lcom/stripe/android/link/account/EncryptedStore;)V", "clear", "", "getAuthSessionCookie", "", "getAuthSessionCookie$link_release", "getNewUserEmail", "getNewUserEmail$link_release", "isEmailLoggedOut", "", "email", "isEmailLoggedOut$link_release", "logout", "logout$link_release", "storeLoggedOutEmail", "storeLoggedOutEmail$link_release", "storeNewUserEmail", "storeNewUserEmail$link_release", "updateAuthSessionCookie", "cookie", "updateAuthSessionCookie$link_release", "(Ljava/lang/String;)Lkotlin/Unit;", "sha256", "Companion", "link_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class CookieStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptedStore store;
    public static final int $stable = 8;
    @NotNull
    public static final String AUTH_SESSION_COOKIE = "auth_session_cookie";
    @NotNull
    public static final String LOGGED_OUT_EMAIL_HASH = "logged_out_email_hash";
    @NotNull
    public static final String SIGNED_UP_EMAIL = "signed_up_email";
    @NotNull
    private static final String[] allCookies;

    @Inject
    public CookieStore(@NotNull EncryptedStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    public CookieStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new EncryptedStore(context));
    }

    public final void clear() {
        String[] $this$forEach$iv = allCookies;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.store.delete(it);
        }
    }

    @Nullable
    public final Unit updateAuthSessionCookie$link_release(@Nullable String cookie) {
        Unit unit;
        String string = cookie;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) {
                this.store.delete(AUTH_SESSION_COOKIE);
            } else {
                this.store.write(AUTH_SESSION_COOKIE, it);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final String getAuthSessionCookie$link_release() {
        return this.store.read(AUTH_SESSION_COOKIE);
    }

    public final void logout$link_release(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.storeLoggedOutEmail$link_release(email);
        this.store.delete(AUTH_SESSION_COOKIE);
    }

    public final boolean isEmailLoggedOut$link_release(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return Intrinsics.areEqual((Object)this.store.read(LOGGED_OUT_EMAIL_HASH), (Object)this.sha256(email));
    }

    public final void storeLoggedOutEmail$link_release(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.store.write(LOGGED_OUT_EMAIL_HASH, this.sha256(email));
    }

    public final void storeNewUserEmail$link_release(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.store.write(SIGNED_UP_EMAIL, email);
    }

    @Nullable
    public final String getNewUserEmail$link_release() {
        String string;
        String it = string = this.store.read(SIGNED_UP_EMAIL);
        boolean bl = false;
        this.store.delete(SIGNED_UP_EMAIL);
        return string;
    }

    private final String sha256(String $this$sha256) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = $this$sha256.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"SHA-256\").d\u2026yteArray(Charsets.UTF_8))");
        return ArraysKt.joinToString$default((byte[])byArray2, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.1.INSTANCE, (int)30, null);
    }

    static {
        String[] stringArray = new String[]{AUTH_SESSION_COOKIE, LOGGED_OUT_EMAIL_HASH, SIGNED_UP_EMAIL};
        allCookies = stringArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/stripe/android/link/account/CookieStore$Companion;", "", "()V", "AUTH_SESSION_COOKIE", "", "LOGGED_OUT_EMAIL_HASH", "SIGNED_UP_EMAIL", "allCookies", "", "getAllCookies", "()[Ljava/lang/String;", "[Ljava/lang/String;", "link_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getAllCookies() {
            return allCookies;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

