/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.account;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/link/account/EncryptedStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "masterKey", "Landroidx/security/crypto/MasterKey;", "sharedPreferences", "Landroid/content/SharedPreferences;", "delete", "", "key", "", "read", "write", "value", "Companion", "link_release"})
public final class EncryptedStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MasterKey masterKey;
    @NotNull
    private final SharedPreferences sharedPreferences;
    @Deprecated
    @NotNull
    public static final String FILE_NAME = "LinkStore";

    @Inject
    public EncryptedStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026256_GCM)\n        .build()");
        this.masterKey = masterKey;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context.getApplicationContext(), (String)FILE_NAME, (MasterKey)this.masterKey, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n        context.\u2026onScheme.AES256_GCM\n    )");
        this.sharedPreferences = sharedPreferences;
    }

    public final void write(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences.Editor $this$write_u24lambda_u2d0 = this.sharedPreferences.edit();
        boolean bl = false;
        $this$write_u24lambda_u2d0.putString(key, value);
        $this$write_u24lambda_u2d0.apply();
    }

    @Nullable
    public final String read(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getString(key, null);
    }

    public final void delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor $this$delete_u24lambda_u2d1 = this.sharedPreferences.edit();
        boolean bl = false;
        $this$delete_u24lambda_u2d1.remove(key);
        $this$delete_u24lambda_u2d1.apply();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/link/account/EncryptedStore$Companion;", "", "()V", "FILE_NAME", "", "link_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

