/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.analytics;

import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.link.analytics.LinkEvent;
import com.stripe.android.link.analytics.LinkEventsReporter;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000fH\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/link/analytics/DefaultLinkEventsReporter;", "Lcom/stripe/android/link/analytics/LinkEventsReporter;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "logger", "Lcom/stripe/android/core/Logger;", "(Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/core/Logger;)V", "signupStartMillis", "", "Ljava/lang/Long;", "durationInSecondsFromStart", "", "", "", "start", "(Ljava/lang/Long;)Ljava/util/Map;", "fireEvent", "", "event", "Lcom/stripe/android/link/analytics/LinkEvent;", "additionalParams", "", "on2FACancel", "on2FAComplete", "on2FAFailure", "on2FAStart", "on2FAStartFailure", "onAccountLookupFailure", "onInlineSignupCheckboxChecked", "onSignupCompleted", "isInline", "", "onSignupFailure", "onSignupFlowPresented", "onSignupStarted", "link_release"})
public final class DefaultLinkEventsReporter
implements LinkEventsReporter {
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Logger logger;
    @Nullable
    private Long signupStartMillis;

    @Inject
    public DefaultLinkEventsReporter(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @IOContext @NotNull CoroutineContext workContext, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)paymentAnalyticsRequestFactory, (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.workContext = workContext;
        this.logger = logger;
    }

    @Override
    public void onInlineSignupCheckboxChecked() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpCheckboxChecked.INSTANCE, null, 2, null);
    }

    @Override
    public void onSignupFlowPresented() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpFlowPresented.INSTANCE, null, 2, null);
    }

    @Override
    public void onSignupStarted(boolean isInline) {
        this.signupStartMillis = System.currentTimeMillis();
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpStart.INSTANCE, null, 2, null);
    }

    @Override
    public void onSignupCompleted(boolean isInline) {
        this.fireEvent(LinkEvent.SignUpComplete.INSTANCE, this.durationInSecondsFromStart(this.signupStartMillis));
        this.signupStartMillis = null;
    }

    @Override
    public void onSignupFailure(boolean isInline) {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpFailure.INSTANCE, null, 2, null);
    }

    @Override
    public void onAccountLookupFailure() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.AccountLookupFailure.INSTANCE, null, 2, null);
    }

    @Override
    public void on2FAStart() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.TwoFAStart.INSTANCE, null, 2, null);
    }

    @Override
    public void on2FAStartFailure() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.TwoFAStartFailure.INSTANCE, null, 2, null);
    }

    @Override
    public void on2FAComplete() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.TwoFAComplete.INSTANCE, null, 2, null);
    }

    @Override
    public void on2FAFailure() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.TwoFAFailure.INSTANCE, null, 2, null);
    }

    @Override
    public void on2FACancel() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.TwoFACancel.INSTANCE, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Map<String, Float> durationInSecondsFromStart(Long start) {
        Long l = start;
        Long l2 = l;
        if (l == null) return null;
        long it = ((Number)l2).longValue();
        boolean bl = false;
        Long l3 = System.currentTimeMillis() - it;
        long it2 = ((Number)l3).longValue();
        boolean bl2 = false;
        if (it2 <= 0L) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Long l4 = l3;
        l2 = l4;
        if (l4 == null) return null;
        it2 = ((Number)l2).longValue();
        boolean bl4 = false;
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"duration", (Object)Float.valueOf((float)it2 / 1000.0f)));
        return map2;
    }

    private final void fireEvent(LinkEvent event, Map<String, ? extends Object> additionalParams) {
        this.logger.debug("Link event: " + event.getEventName() + ' ' + additionalParams);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, additionalParams, null){
            int label;
            final /* synthetic */ DefaultLinkEventsReporter this$0;
            final /* synthetic */ LinkEvent $event;
            final /* synthetic */ Map<String, Object> $additionalParams;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$additionalParams = $additionalParams;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AnalyticsRequestExecutor analyticsRequestExecutor = DefaultLinkEventsReporter.access$getAnalyticsRequestExecutor$p(this.this$0);
                        PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory = DefaultLinkEventsReporter.access$getPaymentAnalyticsRequestFactory$p(this.this$0);
                        AnalyticsEvent analyticsEvent = this.$event;
                        Map map2 = this.$additionalParams;
                        if (map2 == null) {
                            map2 = MapsKt.emptyMap();
                        }
                        analyticsRequestExecutor.executeAsync(paymentAnalyticsRequestFactory.createRequest(analyticsEvent, map2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void fireEvent$default(DefaultLinkEventsReporter defaultLinkEventsReporter, LinkEvent linkEvent, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = null;
        }
        defaultLinkEventsReporter.fireEvent(linkEvent, map2);
    }

    public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(DefaultLinkEventsReporter $this) {
        return $this.analyticsRequestExecutor;
    }

    public static final /* synthetic */ PaymentAnalyticsRequestFactory access$getPaymentAnalyticsRequestFactory$p(DefaultLinkEventsReporter $this) {
        return $this.paymentAnalyticsRequestFactory;
    }
}

