/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.confirmation;

import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.payments.paymentlauncher.PaymentLauncher;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherContract;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncherAssistedFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\b\u0001\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\bJ/\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u001c\u0010\u0014\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nj\u0002`\u000e\u00f8\u0001\u0000J\u0006\u0010\u0015\u001a\u00020\rJ\u0017\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bR+\u0010\t\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r\u0018\u00010\nj\u0004\u0018\u0001`\u000eX\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/link/confirmation/ConfirmationManager;", "", "paymentLauncherFactory", "Lcom/stripe/android/payments/paymentlauncher/StripePaymentLauncherAssistedFactory;", "publishableKeyProvider", "Lkotlin/Function0;", "", "stripeAccountIdProvider", "(Lcom/stripe/android/payments/paymentlauncher/StripePaymentLauncherAssistedFactory;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "completionCallback", "Lkotlin/Function1;", "Lkotlin/Result;", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "", "Lcom/stripe/android/link/confirmation/PaymentConfirmationCallback;", "paymentLauncher", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncher;", "confirmStripeIntent", "confirmStripeIntentParams", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "onResult", "invalidatePaymentLauncher", "onPaymentResult", "paymentResult", "(Lcom/stripe/android/payments/paymentlauncher/PaymentResult;)Lkotlin/Unit;", "setupPaymentLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "link_release"})
public final class ConfirmationManager {
    @NotNull
    private final StripePaymentLauncherAssistedFactory paymentLauncherFactory;
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final Function0<String> stripeAccountIdProvider;
    @Nullable
    private PaymentLauncher paymentLauncher;
    @Nullable
    private Function1<? super Result<? extends PaymentResult>, Unit> completionCallback;

    @Inject
    public ConfirmationManager(@NotNull StripePaymentLauncherAssistedFactory paymentLauncherFactory, @Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Named(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider) {
        Intrinsics.checkNotNullParameter((Object)paymentLauncherFactory, (String)"paymentLauncherFactory");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
        this.paymentLauncherFactory = paymentLauncherFactory;
        this.publishableKeyProvider = publishableKeyProvider;
        this.stripeAccountIdProvider = stripeAccountIdProvider;
    }

    public final void setupPaymentLauncher(@NotNull ActivityResultCaller activityResultCaller) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        ActivityResultLauncher activityResultLauncher2 = activityResultCaller.registerForActivityResult((ActivityResultContract)new PaymentLauncherContract(), p0 -> this.onPaymentResult((PaymentResult)p0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"activityResultCaller.reg\u2026ymentResult\n            )");
        this.paymentLauncher = (PaymentLauncher)this.paymentLauncherFactory.create(this.publishableKeyProvider, this.stripeAccountIdProvider, activityResultLauncher2);
    }

    public final void invalidatePaymentLauncher() {
        this.paymentLauncher = null;
    }

    public final void confirmStripeIntent(@NotNull ConfirmStripeIntentParams confirmStripeIntentParams, @NotNull Function1<? super Result<? extends PaymentResult>, Unit> onResult) {
        Throwable it;
        Object $this$confirmStripeIntent_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)confirmStripeIntentParams, (String)"confirmStripeIntentParams");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        this.completionCallback = onResult;
        Object object = this;
        try {
            $this$confirmStripeIntent_u24lambda_u2d0 = object;
            boolean bl = false;
            PaymentLauncher paymentLauncher = ((ConfirmationManager)$this$confirmStripeIntent_u24lambda_u2d0).paymentLauncher;
            if (paymentLauncher == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$confirmStripeIntent_u24lambda_u2d0 = Result.constructor-impl((Object)paymentLauncher);
        }
        catch (Throwable bl) {
            $this$confirmStripeIntent_u24lambda_u2d0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$confirmStripeIntent_u24lambda_u2d0;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            it = (PaymentLauncher)object;
            boolean bl = false;
            ConfirmStripeIntentParams confirmStripeIntentParams2 = confirmStripeIntentParams;
            if (confirmStripeIntentParams2 instanceof ConfirmPaymentIntentParams) {
                it.confirm((ConfirmPaymentIntentParams)confirmStripeIntentParams);
            } else if (confirmStripeIntentParams2 instanceof ConfirmSetupIntentParams) {
                it.confirm((ConfirmSetupIntentParams)confirmStripeIntentParams);
            }
        } else {
            it = throwable;
            boolean bl = false;
            onResult.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
        }
    }

    private final Unit onPaymentResult(PaymentResult paymentResult) {
        Unit unit;
        Function1<? super Result<? extends PaymentResult>, Unit> function1 = this.completionCallback;
        if (function1 != null) {
            Function1<? super Result<? extends PaymentResult>, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)paymentResult)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

