/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.model;

import com.stripe.android.link.model.AccountStatus;
import com.stripe.android.model.ConsumerSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u0004\u0018\u00010\nJ\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0003H\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\u0010*\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/link/model/LinkAccount;", "", "consumerSession", "Lcom/stripe/android/model/ConsumerSession;", "(Lcom/stripe/android/model/ConsumerSession;)V", "accountStatus", "Lcom/stripe/android/link/model/AccountStatus;", "getAccountStatus", "()Lcom/stripe/android/link/model/AccountStatus;", "clientSecret", "", "getClientSecret", "()Ljava/lang/String;", "email", "getEmail", "isVerified", "", "()Z", "redactedPhoneNumber", "getRedactedPhoneNumber", "getAuthSessionCookie", "containsSMSSessionStarted", "containsVerifiedSMSSession", "isVerifiedForSignup", "link_release"})
public final class LinkAccount {
    @NotNull
    private final ConsumerSession consumerSession;
    @NotNull
    private final String redactedPhoneNumber;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final String email;
    private final boolean isVerified;
    @NotNull
    private final AccountStatus accountStatus;

    public LinkAccount(@NotNull ConsumerSession consumerSession) {
        Intrinsics.checkNotNullParameter((Object)consumerSession, (String)"consumerSession");
        this.consumerSession = consumerSession;
        this.redactedPhoneNumber = this.consumerSession.getRedactedPhoneNumber();
        this.clientSecret = this.consumerSession.getClientSecret();
        this.email = this.consumerSession.getEmailAddress();
        boolean bl = this.isVerified = this.containsVerifiedSMSSession(this.consumerSession) || this.isVerifiedForSignup(this.consumerSession);
        this.accountStatus = this.isVerified ? AccountStatus.Verified : (this.containsSMSSessionStarted(this.consumerSession) ? AccountStatus.VerificationStarted : AccountStatus.NeedsVerification);
    }

    @NotNull
    public final String getRedactedPhoneNumber() {
        return this.redactedPhoneNumber;
    }

    @NotNull
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    public final boolean isVerified() {
        return this.isVerified;
    }

    @NotNull
    public final AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    @Nullable
    public final String getAuthSessionCookie() {
        return this.consumerSession.getAuthSessionClientSecret();
    }

    private final boolean containsSMSSessionStarted(ConsumerSession $this$containsSMSSessionStarted) {
        Object v1;
        block1: {
            Iterable iterable = $this$containsSMSSessionStarted.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                boolean bl2 = it.getType() == ConsumerSession.VerificationSession.SessionType.Sms && it.getState() == ConsumerSession.VerificationSession.SessionState.Started;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }

    private final boolean containsVerifiedSMSSession(ConsumerSession $this$containsVerifiedSMSSession) {
        Object v1;
        block1: {
            Iterable iterable = $this$containsVerifiedSMSSession.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                boolean bl2 = it.getType() == ConsumerSession.VerificationSession.SessionType.Sms && it.getState() == ConsumerSession.VerificationSession.SessionState.Verified;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }

    private final boolean isVerifiedForSignup(ConsumerSession $this$isVerifiedForSignup) {
        Object v1;
        block1: {
            Iterable iterable = $this$isVerifiedForSignup.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                boolean bl2 = it.getType() == ConsumerSession.VerificationSession.SessionType.SignUp && it.getState() == ConsumerSession.VerificationSession.SessionState.Started;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }
}

