/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.model;

import androidx.lifecycle.FlowLiveDataConversions;
import androidx.lifecycle.LiveData;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavHostController;
import androidx.navigation.NavOptionsBuilder;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkScreen;
import com.stripe.android.link.model.Navigator;
import com.stripe.android.link.model.NavigatorKt;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u0012\u0012\f\u0012\n  *\u0004\u0018\u0001H\u001fH\u001f\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u001f2\u0006\u0010!\u001a\u00020\"J\r\u0010#\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u0012\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0012J\u001d\u0010,\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0001\u00a2\u0006\u0002\u0010.R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lcom/stripe/android/link/model/Navigator;", "", "()V", "navigationController", "Landroidx/navigation/NavHostController;", "getNavigationController", "()Landroidx/navigation/NavHostController;", "setNavigationController", "(Landroidx/navigation/NavHostController;)V", "onDismiss", "Lkotlin/Function1;", "Lcom/stripe/android/link/LinkActivityResult;", "", "getOnDismiss", "()Lkotlin/jvm/functions/Function1;", "setOnDismiss", "(Lkotlin/jvm/functions/Function1;)V", "userNavigationEnabled", "", "getUserNavigationEnabled", "()Z", "setUserNavigationEnabled", "(Z)V", "cancel", "reason", "Lcom/stripe/android/link/LinkActivityResult$Canceled$Reason;", "dismiss", "result", "(Lcom/stripe/android/link/LinkActivityResult;)Lkotlin/Unit;", "getResultFlow", "Lkotlinx/coroutines/flow/Flow;", "T", "kotlin.jvm.PlatformType", "key", "", "isOnRootScreen", "()Ljava/lang/Boolean;", "navigateTo", "target", "Lcom/stripe/android/link/LinkScreen;", "clearBackStack", "(Lcom/stripe/android/link/LinkScreen;Z)Lkotlin/Unit;", "onBack", "userInitiated", "setResult", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlin/Unit;", "link_release"})
public final class Navigator {
    private boolean userNavigationEnabled = true;
    @Nullable
    private NavHostController navigationController;
    @Nullable
    private Function1<? super LinkActivityResult, Unit> onDismiss;

    @Inject
    public Navigator() {
    }

    public final boolean getUserNavigationEnabled() {
        return this.userNavigationEnabled;
    }

    public final void setUserNavigationEnabled(boolean bl) {
        this.userNavigationEnabled = bl;
    }

    @Nullable
    public final NavHostController getNavigationController() {
        return this.navigationController;
    }

    public final void setNavigationController(@Nullable NavHostController navHostController) {
        this.navigationController = navHostController;
    }

    @Nullable
    public final Function1<LinkActivityResult, Unit> getOnDismiss() {
        return this.onDismiss;
    }

    public final void setOnDismiss(@Nullable Function1<? super LinkActivityResult, Unit> function1) {
        this.onDismiss = function1;
    }

    @Nullable
    public final Unit navigateTo(@NotNull LinkScreen target, boolean clearBackStack) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        NavHostController navHostController = this.navigationController;
        if (navHostController != null) {
            NavHostController navController = navHostController;
            boolean bl = false;
            navController.navigate(target.getRoute(), (Function1)new Function1<NavOptionsBuilder, Unit>(clearBackStack, navController){
                final /* synthetic */ boolean $clearBackStack;
                final /* synthetic */ NavHostController $navController;
                {
                    this.$clearBackStack = $clearBackStack;
                    this.$navController = $navController;
                    super(1);
                }

                public final void invoke(@NotNull NavOptionsBuilder $this$navigate) {
                    Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
                    if (this.$clearBackStack) {
                        $this$navigate.popUpTo(((NavBackStackEntry)this.$navController.getBackQueue().first()).getDestination().getId(), (Function1)navigateTo.1.1.INSTANCE);
                    }
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static /* synthetic */ Unit navigateTo$default(Navigator navigator, LinkScreen linkScreen, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return navigator.navigateTo(linkScreen, bl);
    }

    @Nullable
    public final Unit setResult(@NotNull String key, @NotNull Object value) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        NavHostController navHostController = this.navigationController;
        if (navHostController != null && (navHostController = navHostController.getPreviousBackStackEntry()) != null && (navHostController = navHostController.getSavedStateHandle()) != null) {
            navHostController.set(key, value);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final <T> Flow<T> getResultFlow(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        NavHostController navHostController = this.navigationController;
        return navHostController != null && (navHostController = navHostController.getCurrentBackStackEntry()) != null && (navHostController = navHostController.getSavedStateHandle()) != null && (navHostController = navHostController.getLiveData(key)) != null ? FlowLiveDataConversions.asFlow((LiveData)((LiveData)navHostController)) : null;
    }

    public final void onBack(boolean userInitiated) {
        block2: {
            if (userInitiated && !this.userNavigationEnabled) break block2;
            NavHostController navHostController = this.navigationController;
            if (navHostController != null) {
                NavHostController navController = navHostController;
                boolean bl = false;
                if (!navController.popBackStack()) {
                    this.cancel(LinkActivityResult.Canceled.Reason.BackPressed);
                }
            }
        }
    }

    @Nullable
    public final Unit dismiss(@NotNull LinkActivityResult result) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Function1<? super LinkActivityResult, Unit> function1 = this.onDismiss;
        if (function1 != null) {
            function1.invoke((Object)result);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void cancel(@NotNull LinkActivityResult.Canceled.Reason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        this.dismiss(new LinkActivityResult.Canceled(reason));
    }

    @Nullable
    public final Boolean isOnRootScreen() {
        NavHostController navHostController = this.navigationController;
        return navHostController != null ? Boolean.valueOf(NavigatorKt.isOnRootScreen(navHostController)) : null;
    }
}

