/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.Context;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.injection.Injector;
import com.stripe.android.core.injection.InjectorKey;
import com.stripe.android.core.injection.UIContext;
import com.stripe.android.core.injection.WeakMapInjectorRegistry;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityViewModel;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.injection.DaggerLinkPaymentLauncherComponent;
import com.stripe.android.link.injection.LinkPaymentLauncherComponent;
import com.stripe.android.link.injection.NonFallbackInjectable;
import com.stripe.android.link.injection.NonFallbackInjector;
import com.stripe.android.link.model.AccountStatus;
import com.stripe.android.link.ui.inline.InlineSignupViewModel;
import com.stripe.android.link.ui.paymentmethod.FormViewModel;
import com.stripe.android.link.ui.paymentmethod.PaymentMethodViewModel;
import com.stripe.android.link.ui.signup.SignUpViewModel;
import com.stripe.android.link.ui.verification.VerificationViewModel;
import com.stripe.android.link.ui.wallet.WalletViewModel;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.ui.core.forms.resources.ResourceRepository;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0095\u0001\b\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0010\b\u0001\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0014\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\"07J!\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u00020>2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\rH\u0002R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Lcom/stripe/android/link/LinkPaymentLauncher;", "Lcom/stripe/android/link/injection/NonFallbackInjectable;", "merchantName", "", "customerEmail", "context", "Landroid/content/Context;", "productUsage", "", "publishableKeyProvider", "Lkotlin/Function0;", "stripeAccountIdProvider", "enableLogging", "", "ioContext", "Lkotlin/coroutines/CoroutineContext;", "uiContext", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "resourceRepository", "Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;", "(Ljava/lang/String;Ljava/lang/String;Landroid/content/Context;Ljava/util/Set;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ZLkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;)V", "accountStatus", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/android/link/model/AccountStatus;", "getAccountStatus", "()Lkotlinx/coroutines/flow/Flow;", "setAccountStatus", "(Lkotlinx/coroutines/flow/Flow;)V", "args", "Lcom/stripe/android/link/LinkActivityContract$Args;", "injector", "Lcom/stripe/android/link/injection/NonFallbackInjector;", "getInjector$link_release", "()Lcom/stripe/android/link/injection/NonFallbackInjector;", "setInjector$link_release", "(Lcom/stripe/android/link/injection/NonFallbackInjector;)V", "injectorKey", "getInjectorKey$annotations", "()V", "launcherComponentBuilder", "Lcom/stripe/android/link/injection/LinkPaymentLauncherComponent$Builder;", "linkAccountManager", "Lcom/stripe/android/link/account/LinkAccountManager;", "getLinkAccountManager$link_release", "()Lcom/stripe/android/link/account/LinkAccountManager;", "setLinkAccountManager$link_release", "(Lcom/stripe/android/link/account/LinkAccountManager;)V", "present", "", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "setup", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "completePayment", "(Lcom/stripe/android/model/StripeIntent;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupDependencies", "Lcom/stripe/android/link/injection/LinkPaymentLauncherComponent;", "link_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class LinkPaymentLauncher
implements NonFallbackInjectable {
    @NotNull
    private final String merchantName;
    @Nullable
    private final String customerEmail;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final Function0<String> stripeAccountIdProvider;
    private final boolean enableLogging;
    @Nullable
    private LinkActivityContract.Args args;
    @NotNull
    private final LinkPaymentLauncherComponent.Builder launcherComponentBuilder;
    @NotNull
    private final String injectorKey;
    @Nullable
    private NonFallbackInjector injector;
    public LinkAccountManager linkAccountManager;
    public Flow<? extends AccountStatus> accountStatus;
    public static final int $stable = 8;

    @AssistedInject
    public LinkPaymentLauncher(@Assisted(value="merchantName") @NotNull String merchantName, @Assisted(value="customerEmail") @Nullable String customerEmail, @NotNull Context context, @Named(value="productUsage") @NotNull Set<String> productUsage, @Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Named(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider, @Named(value="enableLogging") boolean enableLogging, @IOContext @NotNull CoroutineContext ioContext, @UIContext @NotNull CoroutineContext uiContext, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull StripeRepository stripeRepository, @NotNull ResourceRepository resourceRepository) {
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
        Intrinsics.checkNotNullParameter((Object)ioContext, (String)"ioContext");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)paymentAnalyticsRequestFactory, (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        this.merchantName = merchantName;
        this.customerEmail = customerEmail;
        this.productUsage = productUsage;
        this.publishableKeyProvider = publishableKeyProvider;
        this.stripeAccountIdProvider = stripeAccountIdProvider;
        this.enableLogging = enableLogging;
        this.launcherComponentBuilder = DaggerLinkPaymentLauncherComponent.builder().merchantName(this.merchantName).customerEmail(this.customerEmail).context(context).ioContext(ioContext).uiContext(uiContext).analyticsRequestFactory(paymentAnalyticsRequestFactory).analyticsRequestExecutor(analyticsRequestExecutor).stripeRepository(stripeRepository).resourceRepository(resourceRepository).enableLogging(this.enableLogging).publishableKeyProvider(this.publishableKeyProvider).stripeAccountIdProvider(this.stripeAccountIdProvider).productUsage(this.productUsage);
        String string = Reflection.getOrCreateKotlinClass(LinkPaymentLauncher.class).getSimpleName();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.injectorKey = WeakMapInjectorRegistry.INSTANCE.nextKey(string);
    }

    @InjectorKey
    private static /* synthetic */ void getInjectorKey$annotations() {
    }

    @Nullable
    public final NonFallbackInjector getInjector$link_release() {
        return this.injector;
    }

    public final void setInjector$link_release(@Nullable NonFallbackInjector nonFallbackInjector) {
        this.injector = nonFallbackInjector;
    }

    @NotNull
    public final LinkAccountManager getLinkAccountManager$link_release() {
        LinkAccountManager linkAccountManager = this.linkAccountManager;
        if (linkAccountManager != null) {
            return linkAccountManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"linkAccountManager");
        return null;
    }

    public final void setLinkAccountManager$link_release(@NotNull LinkAccountManager linkAccountManager) {
        Intrinsics.checkNotNullParameter((Object)linkAccountManager, (String)"<set-?>");
        this.linkAccountManager = linkAccountManager;
    }

    @NotNull
    public final Flow<AccountStatus> getAccountStatus() {
        Flow<? extends AccountStatus> flow = this.accountStatus;
        if (flow != null) {
            return flow;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"accountStatus");
        return null;
    }

    public final void setAccountStatus(@NotNull Flow<? extends AccountStatus> flow) {
        Intrinsics.checkNotNullParameter(flow, (String)"<set-?>");
        this.accountStatus = flow;
    }

    @Nullable
    public final Object setup(@NotNull StripeIntent stripeIntent, boolean completePayment2, @NotNull Continuation<? super AccountStatus> $completion) {
        LinkPaymentLauncherComponent component = this.setupDependencies(stripeIntent, completePayment2);
        this.setAccountStatus(component.getLinkAccountManager().getAccountStatus());
        this.setLinkAccountManager$link_release(component.getLinkAccountManager());
        return FlowKt.first(this.getAccountStatus(), $completion);
    }

    public final void present(@NotNull ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher) {
        Intrinsics.checkNotNullParameter(activityResultLauncher, (String)"activityResultLauncher");
        if (this.args == null) {
            boolean bl = false;
            String string = "Must call setup before presenting";
            throw new IllegalArgumentException(string.toString());
        }
        activityResultLauncher.launch((Object)this.args);
    }

    private final LinkPaymentLauncherComponent setupDependencies(StripeIntent stripeIntent, boolean completePayment2) {
        LinkActivityContract.Args args = new LinkActivityContract.Args(stripeIntent, completePayment2, this.merchantName, this.customerEmail, new LinkActivityContract.Args.InjectionParams(this.injectorKey, this.productUsage, this.enableLogging, (String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke()));
        LinkPaymentLauncherComponent component = this.launcherComponentBuilder.starterArgs(args).build();
        NonFallbackInjector injector2 = new NonFallbackInjector(component){
            final /* synthetic */ LinkPaymentLauncherComponent $component;
            {
                this.$component = $component;
            }

            public void inject(@NotNull Injectable<?> injectable) {
                Intrinsics.checkNotNullParameter(injectable, (String)"injectable");
                Injectable<?> injectable2 = injectable;
                if (injectable2 instanceof LinkActivityViewModel.Factory) {
                    this.$component.inject((LinkActivityViewModel.Factory)injectable);
                } else if (injectable2 instanceof SignUpViewModel.Factory) {
                    this.$component.inject((SignUpViewModel.Factory)injectable);
                } else if (injectable2 instanceof VerificationViewModel.Factory) {
                    this.$component.inject((VerificationViewModel.Factory)injectable);
                } else if (injectable2 instanceof WalletViewModel.Factory) {
                    this.$component.inject((WalletViewModel.Factory)injectable);
                } else if (injectable2 instanceof InlineSignupViewModel.Factory) {
                    this.$component.inject((InlineSignupViewModel.Factory)injectable);
                } else if (injectable2 instanceof PaymentMethodViewModel.Factory) {
                    this.$component.inject((PaymentMethodViewModel.Factory)injectable);
                } else if (injectable2 instanceof FormViewModel.Factory) {
                    this.$component.inject((FormViewModel.Factory)injectable);
                } else {
                    throw new IllegalArgumentException("invalid Injectable " + injectable + " requested in " + this);
                }
            }
        };
        WeakMapInjectorRegistry.INSTANCE.register((Injector)injector2, this.injectorKey);
        this.args = args;
        this.injector = injector2;
        return component;
    }

    @Override
    @NotNull
    public Void fallbackInitialize(@NotNull Unit arg) {
        return NonFallbackInjectable.DefaultImpls.fallbackInitialize(this, arg);
    }
}

