/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.account;

import com.stripe.android.link.account.CookieStore;
import com.stripe.android.link.account.EncryptedStore;
import java.security.MessageDigest;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/link/account/CookieStore;", "", "store", "Lcom/stripe/android/link/account/EncryptedStore;", "(Lcom/stripe/android/link/account/EncryptedStore;)V", "getAuthSessionCookie", "", "isEmailLoggedOut", "", "email", "logout", "", "storeLoggedOutEmail", "updateAuthSessionCookie", "cookie", "(Ljava/lang/String;)Lkotlin/Unit;", "sha256", "Companion", "link_release"})
public final class CookieStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptedStore store;
    @NotNull
    public static final String AUTH_SESSION_COOKIE = "auth_session_cookie";
    @NotNull
    public static final String LOGGED_OUT_EMAIL_HASH = "logged_out_email_hash";

    @Inject
    public CookieStore(@NotNull EncryptedStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Nullable
    public final Unit updateAuthSessionCookie(@Nullable String cookie) {
        Unit unit;
        String string = cookie;
        if (string == null) {
            unit = null;
        } else {
            String it = string;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) {
                this.store.delete(AUTH_SESSION_COOKIE);
            } else {
                this.store.write(AUTH_SESSION_COOKIE, it);
            }
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @Nullable
    public final String getAuthSessionCookie() {
        return this.store.read(AUTH_SESSION_COOKIE);
    }

    public final void logout(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.storeLoggedOutEmail(email);
        this.store.delete(AUTH_SESSION_COOKIE);
    }

    public final boolean isEmailLoggedOut(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return Intrinsics.areEqual((Object)this.store.read(LOGGED_OUT_EMAIL_HASH), (Object)this.sha256(email));
    }

    public final void storeLoggedOutEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.store.write(LOGGED_OUT_EMAIL_HASH, this.sha256(email));
    }

    private final String sha256(String $this$sha256) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = $this$sha256.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"SHA-256\").d\u2026yteArray(Charsets.UTF_8))");
        return ArraysKt.joinToString$default((byte[])byArray2, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/link/account/CookieStore$Companion;", "", "()V", "AUTH_SESSION_COOKIE", "", "LOGGED_OUT_EMAIL_HASH", "link_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

