/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.Context;
import android.content.Intent;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkActivityResultKt;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.LinkForegroundActivity;
import com.stripe.android.link.serialization.PopupPayload;
import com.stripe.android.networking.StripeRepository;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0010\u0011B\u000f\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/link/LinkActivityContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "Lcom/stripe/android/link/LinkActivityResult;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "(Lcom/stripe/android/networking/StripeRepository;)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Args", "Result", "link_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class LinkActivityContract
extends ActivityResultContract<Args, LinkActivityResult> {
    @NotNull
    private final StripeRepository stripeRepository;
    public static final int $stable = 8;

    @Inject
    public LinkActivityContract(@NotNull StripeRepository stripeRepository) {
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        this.stripeRepository = stripeRepository;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PaymentConfiguration paymentConfiguration = PaymentConfiguration.Companion.getInstance(context);
        PopupPayload payload = PopupPayload.Companion.create(input.getConfiguration$link_release(), context, paymentConfiguration.getPublishableKey(), paymentConfiguration.getStripeAccountId(), StripeRepository.DefaultImpls.buildPaymentUserAgent$default((StripeRepository)this.stripeRepository, null, (int)1, null));
        return LinkForegroundActivity.Companion.createIntent(context, payload.toUrl());
    }

    @NotNull
    public LinkActivityResult parseResult(int resultCode, @Nullable Intent intent) {
        return LinkActivityResultKt.createLinkActivityResult(resultCode, intent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\bJ\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/link/LinkActivityContract$Args;", "", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "(Lcom/stripe/android/link/LinkConfiguration;)V", "getConfiguration$link_release", "()Lcom/stripe/android/link/LinkConfiguration;", "component1", "component1$link_release", "copy", "equals", "", "other", "hashCode", "", "toString", "", "link_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=0)
    public static final class Args {
        @NotNull
        private final LinkConfiguration configuration;
        public static final int $stable = 8;

        public Args(@NotNull LinkConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.configuration = configuration;
        }

        @NotNull
        public final LinkConfiguration getConfiguration$link_release() {
            return this.configuration;
        }

        @NotNull
        public final LinkConfiguration component1$link_release() {
            return this.configuration;
        }

        @NotNull
        public final Args copy(@NotNull LinkConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new Args(configuration);
        }

        public static /* synthetic */ Args copy$default(Args args, LinkConfiguration linkConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                linkConfiguration = args.configuration;
            }
            return args.copy(linkConfiguration);
        }

        @NotNull
        public String toString() {
            return "Args(configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            return this.configuration.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.configuration, (Object)args.configuration);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/link/LinkActivityContract$Result;", "", "linkResult", "Lcom/stripe/android/link/LinkActivityResult;", "(Lcom/stripe/android/link/LinkActivityResult;)V", "getLinkResult", "()Lcom/stripe/android/link/LinkActivityResult;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "link_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @StabilityInferred(parameters=1)
    public static final class Result {
        @NotNull
        private final LinkActivityResult linkResult;
        public static final int $stable;

        public Result(@NotNull LinkActivityResult linkResult) {
            Intrinsics.checkNotNullParameter((Object)linkResult, (String)"linkResult");
            this.linkResult = linkResult;
        }

        @NotNull
        public final LinkActivityResult getLinkResult() {
            return this.linkResult;
        }

        @NotNull
        public final LinkActivityResult component1() {
            return this.linkResult;
        }

        @NotNull
        public final Result copy(@NotNull LinkActivityResult linkResult) {
            Intrinsics.checkNotNullParameter((Object)linkResult, (String)"linkResult");
            return new Result(linkResult);
        }

        public static /* synthetic */ Result copy$default(Result result, LinkActivityResult linkActivityResult, int n, Object object) {
            if ((n & 1) != 0) {
                linkActivityResult = result.linkResult;
            }
            return result.copy(linkActivityResult);
        }

        @NotNull
        public String toString() {
            return "Result(linkResult=" + this.linkResult + ")";
        }

        public int hashCode() {
            return this.linkResult.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            return Intrinsics.areEqual((Object)this.linkResult, (Object)result.linkResult);
        }
    }
}

