/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.Logger;
import com.stripe.android.core.exception.ExceptionUtilsKt;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.utils.DurationProvider;
import com.stripe.android.link.analytics.LinkEvent;
import com.stripe.android.link.analytics.LinkEventsReporter;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0019J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0015H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\u001bH\u0016J\b\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00062"}, d2={"Lcom/stripe/android/link/analytics/DefaultLinkEventsReporter;", "Lcom/stripe/android/link/analytics/LinkEventsReporter;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "logger", "Lcom/stripe/android/core/Logger;", "durationProvider", "Lcom/stripe/android/core/utils/DurationProvider;", "(Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lcom/stripe/android/payments/core/analytics/ErrorReporter;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/core/Logger;Lcom/stripe/android/core/utils/DurationProvider;)V", "analyticsValue", "", "Lcom/stripe/android/link/analytics/LinkEventsReporter$SessionState;", "getAnalyticsValue", "(Lcom/stripe/android/link/analytics/LinkEventsReporter$SessionState;)Ljava/lang/String;", "durationInSecondsFromStart", "", "", "duration", "Lkotlin/time/Duration;", "durationInSecondsFromStart-BwNAW2A", "fireEvent", "", "event", "Lcom/stripe/android/link/analytics/LinkEvent;", "additionalParams", "", "onAccountLookupFailure", "error", "", "onInlineSignupCheckboxChecked", "onInvalidSessionState", "state", "onPopupCancel", "onPopupError", "onPopupLogout", "onPopupShow", "onPopupSkipped", "onPopupSuccess", "onSignupCompleted", "isInline", "", "onSignupFailure", "onSignupStarted", "Companion", "link_release"})
@StabilityInferred(parameters=0)
public final class DefaultLinkEventsReporter
implements LinkEventsReporter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DurationProvider durationProvider;
    public static final int $stable = 8;
    @NotNull
    private static final String FIELD_SESSION_STATE = "sessionState";
    @NotNull
    private static final String VALUE_REQUIRES_SIGN_UP = "requiresSignUp";
    @NotNull
    private static final String VALUE_REQUIRES_VERIFICATION = "requiresVerification";
    @NotNull
    private static final String VALUE_VERIFIED = "verified";
    @NotNull
    private static final String FIELD_ERROR_MESSAGE = "error_message";

    @Inject
    public DefaultLinkEventsReporter(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @NotNull ErrorReporter errorReporter, @IOContext @NotNull CoroutineContext workContext, @NotNull Logger logger, @NotNull DurationProvider durationProvider) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)paymentAnalyticsRequestFactory, (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)durationProvider, (String)"durationProvider");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.errorReporter = errorReporter;
        this.workContext = workContext;
        this.logger = logger;
        this.durationProvider = durationProvider;
    }

    @Override
    public void onInvalidSessionState(@NotNull LinkEventsReporter.SessionState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Map params = MapsKt.mapOf((Pair)TuplesKt.to((Object)FIELD_SESSION_STATE, (Object)this.getAnalyticsValue(state)));
        ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.UnexpectedErrorEvent.LINK_INVALID_SESSION_STATE), null, null, (int)6, null);
        this.fireEvent(LinkEvent.SignUpFailureInvalidSessionState.INSTANCE, params);
    }

    @Override
    public void onInlineSignupCheckboxChecked() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpCheckboxChecked.INSTANCE, null, 2, null);
    }

    @Override
    public void onSignupStarted(boolean isInline) {
        DurationProvider.DefaultImpls.start$default((DurationProvider)this.durationProvider, (DurationProvider.Key)DurationProvider.Key.LinkSignup, (boolean)false, (int)2, null);
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.SignUpStart.INSTANCE, null, 2, null);
    }

    @Override
    public void onSignupCompleted(boolean isInline) {
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.LinkSignup);
        this.fireEvent(LinkEvent.SignUpComplete.INSTANCE, this.durationInSecondsFromStart-BwNAW2A(duration));
    }

    @Override
    public void onSignupFailure(boolean isInline, @NotNull Throwable error) {
        Map preferredParams;
        Map map2;
        Map map3;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof InvalidRequestException) {
            Object object = ((InvalidRequestException)error).getStripeError();
            if (object != null && (object = object.getMessage()) != null) {
                Object it = object;
                boolean bl = false;
                map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)FIELD_ERROR_MESSAGE, (Object)it));
            } else {
                map3 = null;
            }
        } else {
            map3 = null;
        }
        if ((map2 = (preferredParams = map3)) == null) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)FIELD_ERROR_MESSAGE, (Object)ExceptionUtilsKt.getSafeAnalyticsMessage((Throwable)error)));
        }
        Map params = MapsKt.plus(map2, (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        this.fireEvent(LinkEvent.SignUpFailure.INSTANCE, params);
    }

    @Override
    public void onAccountLookupFailure(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Map params = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)FIELD_ERROR_MESSAGE, (Object)ExceptionUtilsKt.getSafeAnalyticsMessage((Throwable)error))), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        this.fireEvent(LinkEvent.AccountLookupFailure.INSTANCE, params);
    }

    @Override
    public void onPopupShow() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.PopupShow.INSTANCE, null, 2, null);
    }

    @Override
    public void onPopupSuccess() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.PopupSuccess.INSTANCE, null, 2, null);
    }

    @Override
    public void onPopupCancel() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.PopupCancel.INSTANCE, null, 2, null);
    }

    @Override
    public void onPopupError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Map params = MapsKt.mapOf((Pair)TuplesKt.to((Object)FIELD_ERROR_MESSAGE, (Object)ExceptionUtilsKt.getSafeAnalyticsMessage((Throwable)error)));
        this.fireEvent(LinkEvent.PopupError.INSTANCE, params);
    }

    @Override
    public void onPopupLogout() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.PopupLogout.INSTANCE, null, 2, null);
    }

    @Override
    public void onPopupSkipped() {
        DefaultLinkEventsReporter.fireEvent$default(this, LinkEvent.PopupSkipped.INSTANCE, null, 2, null);
    }

    private final Map<String, Float> durationInSecondsFromStart-BwNAW2A(Duration duration) {
        Map map2;
        Duration duration2 = duration;
        if (duration2 != null) {
            long it = duration2.unbox-impl();
            boolean bl = false;
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"duration", (Object)Float.valueOf((float)Duration.toDouble-impl((long)it, (DurationUnit)DurationUnit.SECONDS))));
        } else {
            map2 = null;
        }
        return map2;
    }

    private final void fireEvent(LinkEvent event, Map<String, ? extends Object> additionalParams) {
        this.logger.debug("Link event: " + event.getEventName() + " " + additionalParams);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, additionalParams, null){
            int label;
            final /* synthetic */ DefaultLinkEventsReporter this$0;
            final /* synthetic */ LinkEvent $event;
            final /* synthetic */ Map<String, Object> $additionalParams;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$additionalParams = $additionalParams;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AnalyticsRequestExecutor analyticsRequestExecutor = DefaultLinkEventsReporter.access$getAnalyticsRequestExecutor$p(this.this$0);
                        PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory = DefaultLinkEventsReporter.access$getPaymentAnalyticsRequestFactory$p(this.this$0);
                        AnalyticsEvent analyticsEvent = this.$event;
                        Map map2 = this.$additionalParams;
                        if (map2 == null) {
                            map2 = MapsKt.emptyMap();
                        }
                        analyticsRequestExecutor.executeAsync(paymentAnalyticsRequestFactory.createRequest(analyticsEvent, map2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void fireEvent$default(DefaultLinkEventsReporter defaultLinkEventsReporter, LinkEvent linkEvent, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = null;
        }
        defaultLinkEventsReporter.fireEvent(linkEvent, map2);
    }

    private final String getAnalyticsValue(LinkEventsReporter.SessionState $this$analyticsValue) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$analyticsValue.ordinal()]) {
            case 1: {
                string = VALUE_REQUIRES_SIGN_UP;
                break;
            }
            case 2: {
                string = VALUE_REQUIRES_VERIFICATION;
                break;
            }
            case 3: {
                string = VALUE_VERIFIED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(DefaultLinkEventsReporter $this) {
        return $this.analyticsRequestExecutor;
    }

    public static final /* synthetic */ PaymentAnalyticsRequestFactory access$getPaymentAnalyticsRequestFactory$p(DefaultLinkEventsReporter $this) {
        return $this.paymentAnalyticsRequestFactory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/link/analytics/DefaultLinkEventsReporter$Companion;", "", "()V", "FIELD_ERROR_MESSAGE", "", "FIELD_SESSION_STATE", "VALUE_REQUIRES_SIGN_UP", "VALUE_REQUIRES_VERIFICATION", "VALUE_VERIFIED", "link_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LinkEventsReporter.SessionState.values().length];
            try {
                nArray[LinkEventsReporter.SessionState.RequiresSignUp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkEventsReporter.SessionState.RequiresVerification.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkEventsReporter.SessionState.Verified.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

