/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralKeyUpdateListener;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.model.parsers.EphemeralKeyJsonParser;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u0001:\u0004&'()BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0012\b\u0002\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0017\u0010\u001d\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u001eJ\u001a\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u0011H\u0002J \u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/EphemeralKeyManager;", "", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "listener", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "shouldPrefetchEphemeralKey", "", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "timeBufferInSeconds", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;Lcom/stripe/android/OperationIdFactory;ZLkotlin/jvm/functions/Function0;J)V", "apiVersion", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "getEphemeralKey$payments_core_release", "()Lcom/stripe/android/EphemeralKey;", "setEphemeralKey$payments_core_release", "(Lcom/stripe/android/EphemeralKey;)V", "retrieveEphemeralKey", "", "operation", "Lcom/stripe/android/EphemeralOperation;", "retrieveEphemeralKey$payments_core_release", "shouldRefreshKey", "shouldRefreshKey$payments_core_release", "updateKey", "key", "updateKeyError", "operationId", "errorCode", "", "errorMessage", "ClientKeyUpdateListener", "Companion", "Factory", "KeyManagerListener", "payments-core_release"})
public final class EphemeralKeyManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final EphemeralKeyProvider ephemeralKeyProvider;
    @NotNull
    private final KeyManagerListener listener;
    @NotNull
    private final Function0<Long> timeSupplier;
    private final long timeBufferInSeconds;
    @NotNull
    private final String apiVersion;
    private /* synthetic */ EphemeralKey ephemeralKey;
    @Deprecated
    private static final long REFRESH_BUFFER_IN_SECONDS = 30L;

    public EphemeralKeyManager(@NotNull EphemeralKeyProvider ephemeralKeyProvider, @NotNull KeyManagerListener listener, @NotNull OperationIdFactory operationIdFactory, boolean shouldPrefetchEphemeralKey, @NotNull Function0<Long> timeSupplier2, long timeBufferInSeconds) {
        Intrinsics.checkNotNullParameter((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkNotNullParameter(timeSupplier2, (String)"timeSupplier");
        this.ephemeralKeyProvider = ephemeralKeyProvider;
        this.listener = listener;
        this.timeSupplier = timeSupplier2;
        this.timeBufferInSeconds = timeBufferInSeconds;
        this.apiVersion = ApiVersion.Companion.get().getCode();
        if (shouldPrefetchEphemeralKey) {
            this.retrieveEphemeralKey$payments_core_release(new EphemeralOperation.RetrieveKey(operationIdFactory.create(), SetsKt.emptySet()));
        }
    }

    public /* synthetic */ EphemeralKeyManager(EphemeralKeyProvider ephemeralKeyProvider, KeyManagerListener keyManagerListener, OperationIdFactory operationIdFactory, boolean bl, Function0 function0, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            l = 30L;
        }
        this(ephemeralKeyProvider, keyManagerListener, operationIdFactory, bl, (Function0<Long>)function0, l);
    }

    @Nullable
    public final EphemeralKey getEphemeralKey$payments_core_release() {
        return this.ephemeralKey;
    }

    public final void setEphemeralKey$payments_core_release(@Nullable EphemeralKey ephemeralKey) {
        this.ephemeralKey = ephemeralKey;
    }

    public final /* synthetic */ void retrieveEphemeralKey$payments_core_release(EphemeralOperation operation) {
        block2: {
            Unit unit;
            Unit unit2;
            EphemeralKey ephemeralKey;
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            EphemeralKey it = ephemeralKey = this.ephemeralKey;
            boolean bl = false;
            EphemeralKey ephemeralKey2 = !(it == null || this.shouldRefreshKey$payments_core_release(it)) ? ephemeralKey : null;
            if (ephemeralKey2 == null) {
                unit2 = null;
            } else {
                EphemeralKey ephemeralKey3 = ephemeralKey2;
                boolean bl2 = false;
                this.listener.onKeyUpdate(ephemeralKey3, operation);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            this.ephemeralKeyProvider.createEphemeralKey(this.apiVersion, new ClientKeyUpdateListener(this, operation));
        }
    }

    private final void updateKey(EphemeralOperation operation, String key) {
        Object object;
        if (key == null) {
            this.listener.onKeyError(operation.getId$payments_core_release(), 500, "EphemeralKeyUpdateListener.onKeyUpdate was called with a null value");
            return;
        }
        Object object2 = this;
        try {
            EphemeralKey ephemeralKey;
            EphemeralKeyManager $this$updateKey_u24lambda_u2d3 = object2;
            boolean bl = false;
            EphemeralKey it = ephemeralKey = new EphemeralKeyJsonParser().parse(new JSONObject(key));
            boolean bl2 = false;
            $this$updateKey_u24lambda_u2d3.setEphemeralKey$payments_core_release(it);
            object = Result.constructor-impl((Object)ephemeralKey);
        }
        catch (Throwable $this$updateKey_u24lambda_u2d3) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$updateKey_u24lambda_u2d3));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            EphemeralKey ephemeralKey = (EphemeralKey)object2;
            boolean bl = false;
            this.listener.onKeyUpdate(ephemeralKey, operation);
        } else {
            Throwable it = throwable;
            boolean bl = false;
            String errorMessage = it instanceof JSONException ? StringsKt.trimIndent((String)("\n                        Received an ephemeral key that could not be parsed. See https://stripe.com/docs/mobile/android/basic for more details.\n                        \n                        " + it.getMessage() + "\n                        ")) : StringsKt.trimIndent((String)("\n                        Received an invalid ephemeral key. See https://stripe.com/docs/mobile/android/basic for more details.\n                        \n                        " + it.getMessage() + "\n                        "));
            this.listener.onKeyError(operation.getId$payments_core_release(), 500, errorMessage);
        }
    }

    private final void updateKeyError(String operationId, int errorCode, String errorMessage) {
        this.ephemeralKey = null;
        this.listener.onKeyError(operationId, errorCode, errorMessage);
    }

    public final boolean shouldRefreshKey$payments_core_release(@Nullable EphemeralKey ephemeralKey) {
        if (ephemeralKey == null) {
            return true;
        }
        long nowInSeconds = TimeUnit.MILLISECONDS.toSeconds(((Number)this.timeSupplier.invoke()).longValue());
        long nowPlusBuffer = nowInSeconds + this.timeBufferInSeconds;
        return ephemeralKey.getExpires$payments_core_release() < nowPlusBuffer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "", "onKeyError", "", "operationId", "", "errorCode", "", "errorMessage", "onKeyUpdate", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation;", "payments-core_release"})
    public static interface KeyManagerListener {
        public void onKeyUpdate(@NotNull EphemeralKey var1, @NotNull EphemeralOperation var2);

        public void onKeyError(@NotNull String var1, int var2, @NotNull String var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/EphemeralKeyManager$ClientKeyUpdateListener;", "Lcom/stripe/android/EphemeralKeyUpdateListener;", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "operation", "Lcom/stripe/android/EphemeralOperation;", "(Lcom/stripe/android/EphemeralKeyManager;Lcom/stripe/android/EphemeralOperation;)V", "onKeyUpdate", "", "stripeResponseJson", "", "onKeyUpdateFailure", "responseCode", "", "message", "payments-core_release"})
    private static final class ClientKeyUpdateListener
    implements EphemeralKeyUpdateListener {
        @NotNull
        private final EphemeralKeyManager ephemeralKeyManager;
        @NotNull
        private final EphemeralOperation operation;

        public ClientKeyUpdateListener(@NotNull EphemeralKeyManager ephemeralKeyManager2, @NotNull EphemeralOperation operation) {
            Intrinsics.checkNotNullParameter((Object)ephemeralKeyManager2, (String)"ephemeralKeyManager");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.ephemeralKeyManager = ephemeralKeyManager2;
            this.operation = operation;
        }

        @Override
        public void onKeyUpdate(@NotNull String stripeResponseJson) {
            Intrinsics.checkNotNullParameter((Object)stripeResponseJson, (String)"stripeResponseJson");
            this.ephemeralKeyManager.updateKey(this.operation, stripeResponseJson);
        }

        @Override
        public void onKeyUpdateFailure(int responseCode, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.ephemeralKeyManager.updateKeyError(this.operation.getId$payments_core_release(), responseCode, message);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Factory;", "", "create", "Lcom/stripe/android/EphemeralKeyManager;", "arg", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "Default", "payments-core_release"})
    public static interface Factory {
        @NotNull
        public EphemeralKeyManager create(@NotNull KeyManagerListener var1);

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Factory$Default;", "Lcom/stripe/android/EphemeralKeyManager$Factory;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "shouldPrefetchEphemeralKey", "", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "(Lcom/stripe/android/EphemeralKeyProvider;ZLcom/stripe/android/OperationIdFactory;Lkotlin/jvm/functions/Function0;)V", "create", "Lcom/stripe/android/EphemeralKeyManager;", "arg", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class Default
        implements Factory {
            @NotNull
            private final EphemeralKeyProvider keyProvider;
            private final boolean shouldPrefetchEphemeralKey;
            @NotNull
            private final OperationIdFactory operationIdFactory;
            @NotNull
            private final Function0<Long> timeSupplier;
            public static final int $stable;

            public Default(@NotNull EphemeralKeyProvider keyProvider, boolean shouldPrefetchEphemeralKey, @NotNull OperationIdFactory operationIdFactory, @NotNull Function0<Long> timeSupplier2) {
                Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
                Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
                Intrinsics.checkNotNullParameter(timeSupplier2, (String)"timeSupplier");
                this.keyProvider = keyProvider;
                this.shouldPrefetchEphemeralKey = shouldPrefetchEphemeralKey;
                this.operationIdFactory = operationIdFactory;
                this.timeSupplier = timeSupplier2;
            }

            public /* synthetic */ Default(EphemeralKeyProvider ephemeralKeyProvider, boolean bl, OperationIdFactory operationIdFactory, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    operationIdFactory = new StripeOperationIdFactory();
                }
                if ((n & 8) != 0) {
                    function0 = 1.INSTANCE;
                }
                this(ephemeralKeyProvider, bl, operationIdFactory, (Function0<Long>)function0);
            }

            @Override
            public /* synthetic */ EphemeralKeyManager create(KeyManagerListener arg) {
                Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                return new EphemeralKeyManager(this.keyProvider, arg, this.operationIdFactory, this.shouldPrefetchEphemeralKey, this.timeSupplier, 0L, 32, null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/EphemeralKeyManager$Companion;", "", "()V", "REFRESH_BUFFER_IN_SECONDS", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

