/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.cards.Bin;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.AccountRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/model/CardMetadata;", "Lcom/stripe/android/core/model/StripeModel;", "bin", "Lcom/stripe/android/cards/Bin;", "accountRanges", "", "Lcom/stripe/android/model/AccountRange;", "(Lcom/stripe/android/cards/Bin;Ljava/util/List;)V", "getAccountRanges", "()Ljava/util/List;", "getBin", "()Lcom/stripe/android/cards/Bin;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
@Parcelize
public final class CardMetadata
implements StripeModel {
    @NotNull
    private final Bin bin;
    @NotNull
    private final List<AccountRange> accountRanges;
    @NotNull
    public static final Parcelable.Creator<CardMetadata> CREATOR;

    public CardMetadata(@NotNull Bin bin, @NotNull List<AccountRange> accountRanges) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
        this.bin = bin;
        this.accountRanges = accountRanges;
    }

    @NotNull
    public final Bin getBin() {
        return this.bin;
    }

    @NotNull
    public final List<AccountRange> getAccountRanges() {
        return this.accountRanges;
    }

    @NotNull
    public final Bin component1() {
        return this.bin;
    }

    @NotNull
    public final List<AccountRange> component2() {
        return this.accountRanges;
    }

    @NotNull
    public final CardMetadata copy(@NotNull Bin bin, @NotNull List<AccountRange> accountRanges) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
        return new CardMetadata(bin, accountRanges);
    }

    public static /* synthetic */ CardMetadata copy$default(CardMetadata cardMetadata, Bin bin, List list, int n, Object object) {
        if ((n & 1) != 0) {
            bin = cardMetadata.bin;
        }
        if ((n & 2) != 0) {
            list = cardMetadata.accountRanges;
        }
        return cardMetadata.copy(bin, list);
    }

    @NotNull
    public String toString() {
        return "CardMetadata(bin=" + this.bin + ", accountRanges=" + this.accountRanges + ')';
    }

    public int hashCode() {
        int result2 = this.bin.hashCode();
        result2 = result2 * 31 + ((Object)this.accountRanges).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardMetadata)) {
            return false;
        }
        CardMetadata cardMetadata = (CardMetadata)other;
        if (!Intrinsics.areEqual((Object)this.bin, (Object)cardMetadata.bin)) {
            return false;
        }
        return Intrinsics.areEqual(this.accountRanges, cardMetadata.accountRanges);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeParcelable((Parcelable)this.bin, flags);
        List<AccountRange> list = this.accountRanges;
        out.writeInt(list.size());
        Iterator<AccountRange> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(out, flags);
        }
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CardMetadata> {
            @NotNull
            public final CardMetadata[] newArray(int size) {
                return new CardMetadata[size];
            }

            @NotNull
            public final CardMetadata createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                Bin bin = (Bin)parcel.readParcelable(CardMetadata.class.getClassLoader());
                for (int i = 0; i != n; ++i) {
                    arrayList.add(AccountRange.CREATOR.createFromParcel(parcel));
                }
                List list = arrayList;
                Bin bin2 = bin;
                return new CardMetadata(bin2, list);
            }
        }
        CREATOR = new Creator();
    }
}

