/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.CustomerBankAccount;
import com.stripe.android.model.CustomerCard;
import com.stripe.android.model.CustomerPaymentSource;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.Source;
import com.stripe.android.model.parsers.BankAccountJsonParser;
import com.stripe.android.model.parsers.CardJsonParser;
import com.stripe.android.model.parsers.SourceJsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/CustomerPaymentSourceJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/CustomerPaymentSource;", "()V", "parse", "json", "Lorg/json/JSONObject;", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class CustomerPaymentSourceJsonParser
implements ModelJsonParser<CustomerPaymentSource> {
    public static final int $stable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public CustomerPaymentSource parse(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = StripeJsonUtils.optString((JSONObject)json, (String)"object");
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -896505829: {
                if (string.equals("source")) {
                    n = 1;
                }
                break;
            }
            case 3046160: {
                if (string.equals("card")) {
                    n = 2;
                }
                break;
            }
            case -1825227990: {
                if (string.equals("bank_account")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                CustomerCard customerCard;
                Card card = new CardJsonParser().parse(json);
                if (card == null) {
                    customerCard = null;
                } else {
                    Card it = card;
                    boolean bl = false;
                    customerCard = new CustomerCard(it);
                }
                CustomerPaymentSource customerPaymentSource = customerCard;
                return customerPaymentSource;
            }
            case 1: {
                CustomerSource customerSource;
                Source source = new SourceJsonParser().parse(json);
                if (source == null) {
                    customerSource = null;
                } else {
                    Source it = source;
                    boolean bl = false;
                    customerSource = new CustomerSource(it);
                }
                CustomerPaymentSource customerPaymentSource = customerSource;
                return customerPaymentSource;
            }
            case 3: {
                BankAccount it = new BankAccountJsonParser().parse(json);
                boolean bl = false;
                CustomerPaymentSource customerPaymentSource = new CustomerBankAccount(it);
                return customerPaymentSource;
            }
            default: {
                return null;
            }
        }
    }
}

