/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.WalletJsonParser;
import com.stripe.android.model.wallets.Wallet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\f\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod;", "()V", "parse", "json", "Lorg/json/JSONObject;", "AuBecsDebitJsonParser", "BacsDebitJsonParser", "BillingDetails", "CardJsonParser", "Companion", "FpxJsonParser", "IdealJsonParser", "NetbankingJsonParser", "SepaDebitJsonParser", "SofortJsonParser", "USBankAccountJsonParser", "UpiJsonParser", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PaymentMethodJsonParser
implements ModelJsonParser<PaymentMethod> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Deprecated
    @NotNull
    private static final String FIELD_ID = "id";
    @Deprecated
    @NotNull
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    @Deprecated
    @NotNull
    private static final String FIELD_CREATED = "created";
    @Deprecated
    @NotNull
    private static final String FIELD_CUSTOMER = "customer";
    @Deprecated
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @Deprecated
    @NotNull
    private static final String FIELD_TYPE = "type";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PaymentMethod parse(@NotNull JSONObject json) {
        PaymentMethod.Builder builder;
        PaymentMethod.BillingDetails billingDetails;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        PaymentMethod.Type type = PaymentMethod.Type.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
        PaymentMethod.Builder builder2 = new PaymentMethod.Builder().setId(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID)).setType(type).setCreated(StripeJsonUtils.INSTANCE.optLong(json, FIELD_CREATED));
        JSONObject jSONObject = json.optJSONObject(FIELD_BILLING_DETAILS);
        if (jSONObject == null) {
            billingDetails = null;
        } else {
            void it;
            JSONObject jSONObject2 = jSONObject;
            builder = builder2;
            boolean bl = false;
            billingDetails = new BillingDetails().parse((JSONObject)it);
            builder2 = builder;
        }
        PaymentMethod.Builder builder3 = builder2.setBillingDetails(billingDetails).setCustomerId(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CUSTOMER)).setLiveMode(json.optBoolean(FIELD_LIVEMODE));
        PaymentMethod.Type type2 = type;
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                PaymentMethod.Card card;
                PaymentMethod.Builder builder4 = builder3;
                JSONObject jSONObject3 = json.optJSONObject(type.code);
                if (jSONObject3 == null) {
                    card = null;
                } else {
                    void it;
                    JSONObject jSONObject4 = jSONObject3;
                    builder = builder4;
                    boolean bl = false;
                    card = new CardJsonParser().parse((JSONObject)it);
                    builder4 = builder;
                }
                builder4.setCard(card);
                break;
            }
            case 2: {
                builder3.setCardPresent(PaymentMethod.CardPresent.Companion.getEMPTY$payments_core_release());
                break;
            }
            case 3: {
                PaymentMethod.Ideal ideal;
                PaymentMethod.Builder builder5 = builder3;
                JSONObject jSONObject5 = json.optJSONObject(type.code);
                if (jSONObject5 == null) {
                    ideal = null;
                } else {
                    JSONObject it = jSONObject5;
                    builder = builder5;
                    boolean bl = false;
                    ideal = new IdealJsonParser().parse(it);
                    builder5 = builder;
                }
                builder5.setIdeal(ideal);
                break;
            }
            case 4: {
                PaymentMethod.Fpx fpx;
                PaymentMethod.Builder builder6 = builder3;
                JSONObject jSONObject6 = json.optJSONObject(type.code);
                if (jSONObject6 == null) {
                    fpx = null;
                } else {
                    JSONObject it = jSONObject6;
                    builder = builder6;
                    boolean bl = false;
                    fpx = new FpxJsonParser().parse(it);
                    builder6 = builder;
                }
                builder6.setFpx(fpx);
                break;
            }
            case 5: {
                PaymentMethod.SepaDebit sepaDebit;
                PaymentMethod.Builder builder7 = builder3;
                JSONObject jSONObject7 = json.optJSONObject(type.code);
                if (jSONObject7 == null) {
                    sepaDebit = null;
                } else {
                    JSONObject it = jSONObject7;
                    builder = builder7;
                    boolean bl = false;
                    sepaDebit = new SepaDebitJsonParser().parse(it);
                    builder7 = builder;
                }
                builder7.setSepaDebit(sepaDebit);
                break;
            }
            case 6: {
                PaymentMethod.AuBecsDebit auBecsDebit;
                PaymentMethod.Builder builder8 = builder3;
                JSONObject jSONObject8 = json.optJSONObject(type.code);
                if (jSONObject8 == null) {
                    auBecsDebit = null;
                } else {
                    JSONObject it = jSONObject8;
                    builder = builder8;
                    boolean bl = false;
                    auBecsDebit = new AuBecsDebitJsonParser().parse(it);
                    builder8 = builder;
                }
                builder8.setAuBecsDebit(auBecsDebit);
                break;
            }
            case 7: {
                PaymentMethod.BacsDebit bacsDebit;
                PaymentMethod.Builder builder9 = builder3;
                JSONObject jSONObject9 = json.optJSONObject(type.code);
                if (jSONObject9 == null) {
                    bacsDebit = null;
                } else {
                    JSONObject it = jSONObject9;
                    builder = builder9;
                    boolean bl = false;
                    bacsDebit = new BacsDebitJsonParser().parse(it);
                    builder9 = builder;
                }
                builder9.setBacsDebit(bacsDebit);
                break;
            }
            case 8: {
                PaymentMethod.Sofort sofort;
                PaymentMethod.Builder builder10 = builder3;
                JSONObject jSONObject10 = json.optJSONObject(type.code);
                if (jSONObject10 == null) {
                    sofort = null;
                } else {
                    JSONObject it = jSONObject10;
                    builder = builder10;
                    boolean bl = false;
                    sofort = new SofortJsonParser().parse(it);
                    builder10 = builder;
                }
                builder10.setSofort(sofort);
                break;
            }
            case 9: {
                PaymentMethod.Upi upi;
                PaymentMethod.Builder builder11 = builder3;
                JSONObject jSONObject11 = json.optJSONObject(type.code);
                if (jSONObject11 == null) {
                    upi = null;
                } else {
                    JSONObject it = jSONObject11;
                    builder = builder11;
                    boolean bl = false;
                    upi = new UpiJsonParser().parse(it);
                    builder11 = builder;
                }
                builder11.setUpi(upi);
                break;
            }
            case 10: {
                PaymentMethod.Netbanking netbanking;
                PaymentMethod.Builder builder12 = builder3;
                JSONObject jSONObject12 = json.optJSONObject(type.code);
                if (jSONObject12 == null) {
                    netbanking = null;
                } else {
                    JSONObject it = jSONObject12;
                    builder = builder12;
                    boolean bl = false;
                    netbanking = new NetbankingJsonParser().parse(it);
                    builder12 = builder;
                }
                builder12.setNetbanking(netbanking);
                break;
            }
            case 11: {
                PaymentMethod.USBankAccount uSBankAccount;
                PaymentMethod.Builder builder13 = builder3;
                JSONObject jSONObject13 = json.optJSONObject(type.code);
                if (jSONObject13 == null) {
                    uSBankAccount = null;
                } else {
                    JSONObject it = jSONObject13;
                    builder = builder13;
                    boolean bl = false;
                    uSBankAccount = new USBankAccountJsonParser().parse(it);
                    builder13 = builder;
                }
                builder13.setUSBankAccount(uSBankAccount);
            }
        }
        return builder3.build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class BillingDetails
    implements ModelJsonParser<PaymentMethod.BillingDetails> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ADDRESS = "address";
        @Deprecated
        @NotNull
        private static final String FIELD_EMAIL = "email";
        @Deprecated
        @NotNull
        private static final String FIELD_NAME = "name";
        @Deprecated
        @NotNull
        private static final String FIELD_PHONE = "phone";

        @NotNull
        public PaymentMethod.BillingDetails parse(@NotNull JSONObject json) {
            Address address;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject == null) {
                address = null;
            } else {
                JSONObject it = jSONObject;
                boolean bl = false;
                address = new AddressJsonParser().parse(it);
            }
            String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PHONE);
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL);
            Address address2 = address;
            return new PaymentMethod.BillingDetails(address2, string3, string2, string);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0007\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card;", "()V", "parse", "json", "Lorg/json/JSONObject;", "ChecksJsonParser", "Companion", "NetworksJsonParser", "ThreeDSecureUsageJsonParser", "payments-core_release"})
    public static final class CardJsonParser
    implements ModelJsonParser<PaymentMethod.Card> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_BRAND = "brand";
        @Deprecated
        @NotNull
        private static final String FIELD_CHECKS = "checks";
        @Deprecated
        @NotNull
        private static final String FIELD_COUNTRY = "country";
        @Deprecated
        @NotNull
        private static final String FIELD_EXP_MONTH = "exp_month";
        @Deprecated
        @NotNull
        private static final String FIELD_EXP_YEAR = "exp_year";
        @Deprecated
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @Deprecated
        @NotNull
        private static final String FIELD_FUNDING = "funding";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @Deprecated
        @NotNull
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        @Deprecated
        @NotNull
        private static final String FIELD_WALLET = "wallet";
        @Deprecated
        @NotNull
        private static final String FIELD_NETWORKS = "networks";

        @NotNull
        public PaymentMethod.Card parse(@NotNull JSONObject json) {
            PaymentMethod.Card.Networks networks;
            Wallet wallet;
            Wallet wallet2;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage;
            PaymentMethod.Card.Checks checks;
            String string;
            Integer n;
            Integer n2;
            String string2;
            String string3;
            String string4;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage2;
            JSONObject it;
            CardBrand cardBrand;
            PaymentMethod.Card.Checks checks2;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            CardBrand cardBrand2 = CardBrand.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BRAND));
            JSONObject jSONObject = json.optJSONObject(FIELD_CHECKS);
            if (jSONObject == null) {
                checks2 = null;
            } else {
                JSONObject jSONObject2 = jSONObject;
                cardBrand = cardBrand2;
                boolean bl = false;
                checks2 = new ChecksJsonParser().parse(it);
                cardBrand2 = cardBrand;
            }
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY);
            Integer n3 = StripeJsonUtils.INSTANCE.optInteger(json, FIELD_EXP_MONTH);
            Integer n4 = StripeJsonUtils.INSTANCE.optInteger(json, FIELD_EXP_YEAR);
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT);
            String string7 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FUNDING);
            String string8 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4);
            JSONObject jSONObject3 = json.optJSONObject(FIELD_THREE_D_SECURE_USAGE);
            if (jSONObject3 == null) {
                threeDSecureUsage2 = null;
            } else {
                it = jSONObject3;
                string4 = string8;
                string3 = string7;
                string2 = string6;
                n2 = n4;
                n = n3;
                string = string5;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                threeDSecureUsage = new ThreeDSecureUsageJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string5 = string;
                n3 = n;
                n4 = n2;
                string6 = string2;
                string7 = string3;
                string8 = string4;
                threeDSecureUsage2 = threeDSecureUsage;
            }
            JSONObject jSONObject4 = json.optJSONObject(FIELD_WALLET);
            if (jSONObject4 == null) {
                wallet2 = null;
            } else {
                it = jSONObject4;
                threeDSecureUsage = threeDSecureUsage2;
                string4 = string8;
                string3 = string7;
                string2 = string6;
                n2 = n4;
                n = n3;
                string = string5;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                wallet = new WalletJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string5 = string;
                n3 = n;
                n4 = n2;
                string6 = string2;
                string7 = string3;
                string8 = string4;
                threeDSecureUsage2 = threeDSecureUsage;
                wallet2 = wallet;
            }
            JSONObject jSONObject5 = json.optJSONObject(FIELD_NETWORKS);
            if (jSONObject5 == null) {
                networks = null;
            } else {
                it = jSONObject5;
                wallet = wallet2;
                threeDSecureUsage = threeDSecureUsage2;
                string4 = string8;
                string3 = string7;
                string2 = string6;
                n2 = n4;
                n = n3;
                string = string5;
                checks = checks2;
                cardBrand = cardBrand2;
                boolean bl = false;
                PaymentMethod.Card.Networks networks2 = new NetworksJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks2 = checks;
                string5 = string;
                n3 = n;
                n4 = n2;
                string6 = string2;
                string7 = string3;
                string8 = string4;
                threeDSecureUsage2 = threeDSecureUsage;
                wallet2 = wallet;
                networks = networks2;
            }
            PaymentMethod.Card.Networks networks3 = networks;
            Wallet wallet3 = wallet2;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage3 = threeDSecureUsage2;
            String string9 = string8;
            String string10 = string7;
            String string11 = string6;
            Integer n5 = n4;
            Integer n6 = n3;
            String string12 = string5;
            PaymentMethod.Card.Checks checks3 = checks2;
            CardBrand cardBrand3 = cardBrand2;
            return new PaymentMethod.Card(cardBrand3, checks3, string12, n6, n5, string11, string10, string9, threeDSecureUsage3, wallet3, networks3);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Checks;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        public static final class ChecksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Checks> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Deprecated
            @NotNull
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            @Deprecated
            @NotNull
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            @Deprecated
            @NotNull
            private static final String FIELD_CVC_CHECK = "cvc_check";

            @NotNull
            public PaymentMethod.Card.Checks parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.Checks(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ADDRESS_LINE1_CHECK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ADDRESS_POSTAL_CODE_CHECK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CVC_CHECK));
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser$Companion;", "", "()V", "FIELD_ADDRESS_LINE1_CHECK", "", "FIELD_ADDRESS_POSTAL_CODE_CHECK", "FIELD_CVC_CHECK", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$ThreeDSecureUsage;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        public static final class ThreeDSecureUsageJsonParser
        implements ModelJsonParser<PaymentMethod.Card.ThreeDSecureUsage> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Deprecated
            @NotNull
            private static final String FIELD_IS_SUPPORTED = "supported";

            @NotNull
            public PaymentMethod.Card.ThreeDSecureUsage parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.ThreeDSecureUsage(StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_IS_SUPPORTED));
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser$Companion;", "", "()V", "FIELD_IS_SUPPORTED", "", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Networks;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
        public static final class NetworksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Networks> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            @Deprecated
            @NotNull
            private static final String FIELD_AVAIABLE = "available";
            @Deprecated
            @NotNull
            private static final String FIELD_SELECTION_MANDATORY = "selection_mandatory";
            @Deprecated
            @NotNull
            private static final String FIELD_PREFERRED = "preferred";

            /*
             * WARNING - void declaration
             */
            @NotNull
            public PaymentMethod.Card.Networks parse(@NotNull JSONObject json) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                List list = StripeJsonUtils.INSTANCE.jsonArrayToList(json.optJSONArray(FIELD_AVAIABLE));
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                Set available = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                return new PaymentMethod.Card.Networks(available, StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_SELECTION_MANDATORY), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PREFERRED));
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser$Companion;", "", "()V", "FIELD_AVAIABLE", "", "FIELD_PREFERRED", "FIELD_SELECTION_MANDATORY", "payments-core_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$Companion;", "", "()V", "FIELD_BRAND", "", "FIELD_CHECKS", "FIELD_COUNTRY", "FIELD_EXP_MONTH", "FIELD_EXP_YEAR", "FIELD_FINGERPRINT", "FIELD_FUNDING", "FIELD_LAST4", "FIELD_NETWORKS", "FIELD_THREE_D_SECURE_USAGE", "FIELD_WALLET", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Ideal;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class IdealJsonParser
    implements ModelJsonParser<PaymentMethod.Ideal> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_BANK = "bank";
        @Deprecated
        @NotNull
        private static final String FIELD_BIC = "bic";

        @NotNull
        public PaymentMethod.Ideal parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Ideal(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BIC));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser$Companion;", "", "()V", "FIELD_BANK", "", "FIELD_BIC", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Fpx;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class FpxJsonParser
    implements ModelJsonParser<PaymentMethod.Fpx> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        @Deprecated
        @NotNull
        private static final String FIELD_BANK = "bank";

        @NotNull
        public PaymentMethod.Fpx parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Fpx(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_HOLDER_TYPE));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser$Companion;", "", "()V", "FIELD_ACCOUNT_HOLDER_TYPE", "", "FIELD_BANK", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$NetbankingJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Netbanking;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class NetbankingJsonParser
    implements ModelJsonParser<PaymentMethod.Netbanking> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_BANK = "bank";

        @NotNull
        public PaymentMethod.Netbanking parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Netbanking(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$NetbankingJsonParser$Companion;", "", "()V", "FIELD_BANK", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$USBankAccount;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class USBankAccountJsonParser
    implements ModelJsonParser<PaymentMethod.USBankAccount> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        @Deprecated
        @NotNull
        private static final String FIELD_ACCOUNT_TYPE = "account_type";
        @Deprecated
        @NotNull
        private static final String FIELD_BANK_NAME = "bank_name";
        @Deprecated
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @Deprecated
        @NotNull
        private static final String FIELD_LINKED_ACCOUNT = "linked_account";
        @Deprecated
        @NotNull
        private static final String FIELD_NETWORKS = "networks";
        @Deprecated
        @NotNull
        private static final String FIELD_NETWORKS_PREFERRED = "preferred";
        @Deprecated
        @NotNull
        private static final String FIELD_NETWORKS_SUPPORTED = "supported";
        @Deprecated
        @NotNull
        private static final String FIELD_ROUTING_NUMBER = "routing_number";

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PaymentMethod.USBankAccount parse(@NotNull JSONObject json) {
            PaymentMethod.USBankAccount.USBankNetworks uSBankNetworks;
            Enum enum_;
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType;
            Object object;
            boolean bl;
            Enum it;
            block7: {
                PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType2;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    for (PaymentMethod.USBankAccount.USBankAccountHolderType enum_2 : PaymentMethod.USBankAccount.USBankAccountHolderType.values()) {
                        it = enum_2;
                        bl = false;
                        if (!Intrinsics.areEqual((Object)StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_HOLDER_TYPE), (Object)((PaymentMethod.USBankAccount.USBankAccountHolderType)it).getValue())) continue;
                        uSBankAccountHolderType2 = enum_2;
                        break block6;
                    }
                    uSBankAccountHolderType2 = null;
                }
                object = uSBankAccountHolderType2;
                PaymentMethod.USBankAccount.USBankAccountType[] uSBankAccountTypeArray = PaymentMethod.USBankAccount.USBankAccountType.values();
                uSBankAccountHolderType = object == null ? PaymentMethod.USBankAccount.USBankAccountHolderType.UNKNOWN : object;
                for (Enum enum_2 : uSBankAccountTypeArray) {
                    it = enum_2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ACCOUNT_TYPE), (Object)((PaymentMethod.USBankAccount.USBankAccountType)it).getValue())) continue;
                    enum_ = enum_2;
                    break block7;
                }
                enum_ = null;
            }
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType3 = uSBankAccountHolderType;
            object = enum_;
            Enum enum_3 = object == null ? PaymentMethod.USBankAccount.USBankAccountType.UNKNOWN : object;
            String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK_NAME);
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LINKED_ACCOUNT);
            if (json.has(FIELD_NETWORKS)) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string5 = StripeJsonUtils.optString((JSONObject)json.optJSONObject(FIELD_NETWORKS), (String)FIELD_NETWORKS_PREFERRED);
                JSONObject jSONObject = json.optJSONObject(FIELD_NETWORKS);
                List list = StripeJsonUtils.INSTANCE.jsonArrayToList(jSONObject == null ? null : jSONObject.getJSONArray(FIELD_NETWORKS_SUPPORTED));
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                String string6 = string5;
                String string7 = string4;
                String string8 = string3;
                String string9 = string2;
                String string10 = string;
                Enum enum_4 = enum_3;
                uSBankAccountHolderType = uSBankAccountHolderType3;
                boolean $i$f$map = false;
                void var4_23 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    it = t;
                    collection = destination$iv$iv;
                    bl = false;
                    collection.add(it.toString());
                }
                collection = (List)destination$iv$iv;
                uSBankAccountHolderType3 = uSBankAccountHolderType;
                enum_3 = enum_4;
                string = string10;
                string2 = string9;
                string3 = string8;
                string4 = string7;
                Collection<String> collection2 = collection;
                String string11 = string6;
                uSBankNetworks = new PaymentMethod.USBankAccount.USBankNetworks(string11, (List<String>)collection2);
            } else {
                uSBankNetworks = null;
            }
            String string12 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ROUTING_NUMBER);
            PaymentMethod.USBankAccount.USBankNetworks uSBankNetworks2 = uSBankNetworks;
            String string13 = string4;
            String string14 = string3;
            String string15 = string2;
            String string16 = string;
            Enum enum_5 = enum_3;
            PaymentMethod.USBankAccount.USBankAccountHolderType uSBankAccountHolderType4 = uSBankAccountHolderType3;
            return new PaymentMethod.USBankAccount(uSBankAccountHolderType4, (PaymentMethod.USBankAccount.USBankAccountType)enum_5, string16, string15, string14, string13, uSBankNetworks2, string12);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$USBankAccountJsonParser$Companion;", "", "()V", "FIELD_ACCOUNT_HOLDER_TYPE", "", "FIELD_ACCOUNT_TYPE", "FIELD_BANK_NAME", "FIELD_FINGERPRINT", "FIELD_LAST4", "FIELD_LINKED_ACCOUNT", "FIELD_NETWORKS", "FIELD_NETWORKS_PREFERRED", "FIELD_NETWORKS_SUPPORTED", "FIELD_ROUTING_NUMBER", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$SepaDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class SepaDebitJsonParser
    implements ModelJsonParser<PaymentMethod.SepaDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_BANK_CODE = "bank_code";
        @Deprecated
        @NotNull
        private static final String FIELD_BRANCH_CODE = "branch_code";
        @Deprecated
        @NotNull
        private static final String FIELD_COUNTRY = "country";
        @Deprecated
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST4 = "last4";

        @NotNull
        public PaymentMethod.SepaDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.SepaDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BANK_CODE), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BRANCH_CODE), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser$Companion;", "", "()V", "FIELD_BANK_CODE", "", "FIELD_BRANCH_CODE", "FIELD_COUNTRY", "FIELD_FINGERPRINT", "FIELD_LAST4", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$AuBecsDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class AuBecsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.AuBecsDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_BSB_NUMBER = "bsb_number";
        @Deprecated
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST4 = "last4";

        @NotNull
        public PaymentMethod.AuBecsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.AuBecsDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_BSB_NUMBER), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser$Companion;", "", "()V", "FIELD_BSB_NUMBER", "", "FIELD_FINGERPRINT", "FIELD_LAST4", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BacsDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class BacsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.BacsDebit> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_FINGERPRINT = "fingerprint";
        @Deprecated
        @NotNull
        private static final String FIELD_LAST4 = "last4";
        @Deprecated
        @NotNull
        private static final String FIELD_SORT_CODE = "sort_code";

        @NotNull
        public PaymentMethod.BacsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.BacsDebit(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_FINGERPRINT), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_LAST4), StripeJsonUtils.optString((JSONObject)json, (String)FIELD_SORT_CODE));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser$Companion;", "", "()V", "FIELD_FINGERPRINT", "", "FIELD_LAST4", "FIELD_SORT_CODE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Sofort;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class SofortJsonParser
    implements ModelJsonParser<PaymentMethod.Sofort> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_COUNTRY = "country";

        @NotNull
        public PaymentMethod.Sofort parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Sofort(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser$Companion;", "", "()V", "FIELD_COUNTRY", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$UpiJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Upi;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    public static final class UpiJsonParser
    implements ModelJsonParser<PaymentMethod.Upi> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final String FIELD_VPA = "vpa";

        @NotNull
        public PaymentMethod.Upi parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Upi(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_VPA));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$UpiJsonParser$Companion;", "", "()V", "FIELD_VPA", "", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$Companion;", "", "()V", "FIELD_BILLING_DETAILS", "", "FIELD_CREATED", "FIELD_CUSTOMER", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_TYPE", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            nArray[PaymentMethod.Type.CardPresent.ordinal()] = 2;
            nArray[PaymentMethod.Type.Ideal.ordinal()] = 3;
            nArray[PaymentMethod.Type.Fpx.ordinal()] = 4;
            nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 5;
            nArray[PaymentMethod.Type.AuBecsDebit.ordinal()] = 6;
            nArray[PaymentMethod.Type.BacsDebit.ordinal()] = 7;
            nArray[PaymentMethod.Type.Sofort.ordinal()] = 8;
            nArray[PaymentMethod.Type.Upi.ordinal()] = 9;
            nArray[PaymentMethod.Type.Netbanking.ordinal()] = 10;
            nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 11;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

