/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.Address;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.wallets.Wallet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/parsers/WalletJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/wallets/Wallet;", "()V", "parse", "json", "Lorg/json/JSONObject;", "parseMasterpassWallet", "Lcom/stripe/android/model/wallets/Wallet$MasterpassWallet;", "parseVisaCheckoutWallet", "Lcom/stripe/android/model/wallets/Wallet$VisaCheckoutWallet;", "dynamicLast4", "", "Companion", "payments-core_release"})
public final class WalletJsonParser
implements ModelJsonParser<Wallet> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final String FIELD_TYPE = "type";
    @Deprecated
    @NotNull
    private static final String FIELD_DYNAMIC_LAST4 = "dynamic_last4";
    @Deprecated
    @NotNull
    private static final String FIELD_BILLING_ADDRESS = "billing_address";
    @Deprecated
    @NotNull
    private static final String FIELD_EMAIL = "email";
    @Deprecated
    @NotNull
    private static final String FIELD_NAME = "name";
    @Deprecated
    @NotNull
    private static final String FIELD_SHIPPING_ADDRESS = "shipping_address";

    @Nullable
    public Wallet parse(@NotNull JSONObject json) {
        Wallet wallet;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Wallet.Type type = Wallet.Type.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
        if (type == null) {
            return null;
        }
        Wallet.Type walletType = type;
        JSONObject jSONObject = json.optJSONObject(walletType.getCode());
        if (jSONObject == null) {
            return null;
        }
        JSONObject walletTypeJson = jSONObject;
        String dynamicLast4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DYNAMIC_LAST4);
        switch (WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
            case 1: {
                wallet = new Wallet.AmexExpressCheckoutWallet(dynamicLast4);
                break;
            }
            case 2: {
                wallet = new Wallet.ApplePayWallet(dynamicLast4);
                break;
            }
            case 3: {
                wallet = new Wallet.SamsungPayWallet(dynamicLast4);
                break;
            }
            case 4: {
                wallet = new Wallet.GooglePayWallet(dynamicLast4);
                break;
            }
            case 5: {
                wallet = this.parseMasterpassWallet(walletTypeJson);
                break;
            }
            case 6: {
                wallet = this.parseVisaCheckoutWallet(walletTypeJson, dynamicLast4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return wallet;
    }

    private final Wallet.MasterpassWallet parseMasterpassWallet(JSONObject json) {
        Address address;
        JSONObject it;
        Address address2;
        JSONObject jSONObject = json.optJSONObject(FIELD_BILLING_ADDRESS);
        if (jSONObject == null) {
            address2 = null;
        } else {
            it = jSONObject;
            boolean bl = false;
            address2 = new AddressJsonParser().parse(it);
        }
        String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL);
        String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
        JSONObject jSONObject2 = json.optJSONObject(FIELD_SHIPPING_ADDRESS);
        if (jSONObject2 == null) {
            address = null;
        } else {
            it = jSONObject2;
            String string3 = string2;
            String string4 = string;
            Address address3 = address2;
            boolean bl = false;
            Address address4 = new AddressJsonParser().parse(it);
            address2 = address3;
            string = string4;
            string2 = string3;
            address = address4;
        }
        Address address5 = address;
        String string5 = string2;
        String string6 = string;
        Address address6 = address2;
        return new Wallet.MasterpassWallet(address6, string6, string5, address5);
    }

    private final Wallet.VisaCheckoutWallet parseVisaCheckoutWallet(JSONObject json, String dynamicLast4) {
        Address address;
        JSONObject it;
        Address address2;
        JSONObject jSONObject = json.optJSONObject(FIELD_BILLING_ADDRESS);
        if (jSONObject == null) {
            address2 = null;
        } else {
            it = jSONObject;
            boolean bl = false;
            address2 = new AddressJsonParser().parse(it);
        }
        String string = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_EMAIL);
        String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_NAME);
        JSONObject jSONObject2 = json.optJSONObject(FIELD_SHIPPING_ADDRESS);
        if (jSONObject2 == null) {
            address = null;
        } else {
            it = jSONObject2;
            String string3 = string2;
            String string4 = string;
            Address address3 = address2;
            boolean bl = false;
            Address address4 = new AddressJsonParser().parse(it);
            address2 = address3;
            string = string4;
            string2 = string3;
            address = address4;
        }
        String string5 = dynamicLast4;
        Address address5 = address;
        String string6 = string2;
        String string7 = string;
        Address address6 = address2;
        return new Wallet.VisaCheckoutWallet(address6, string7, string6, address5, string5);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/WalletJsonParser$Companion;", "", "()V", "FIELD_BILLING_ADDRESS", "", "FIELD_DYNAMIC_LAST4", "FIELD_EMAIL", "FIELD_NAME", "FIELD_SHIPPING_ADDRESS", "FIELD_TYPE", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Wallet.Type.values().length];
            nArray[Wallet.Type.AmexExpressCheckout.ordinal()] = 1;
            nArray[Wallet.Type.ApplePay.ordinal()] = 2;
            nArray[Wallet.Type.SamsungPay.ordinal()] = 3;
            nArray[Wallet.Type.GooglePay.ordinal()] = 4;
            nArray[Wallet.Type.Masterpass.ordinal()] = 5;
            nArray[Wallet.Type.VisaCheckout.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

