/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.content.Context;
import com.stripe.android.R;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/payments/PaymentFlowFailureMessageFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "create", "", "intent", "Lcom/stripe/android/model/StripeIntent;", "outcome", "", "createForPaymentIntent", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "createForSetupIntent", "setupIntent", "Lcom/stripe/android/model/SetupIntent;", "payments-core_release"})
public final class PaymentFlowFailureMessageFactory {
    @NotNull
    private final Context context;

    public PaymentFlowFailureMessageFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String create(@NotNull StripeIntent intent, int outcome) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (outcome == 4) {
            string2 = this.context.getResources().getString(R.string.stripe_failure_reason_timed_out);
            return string2;
        } else if (intent.getStatus() == StripeIntent.Status.RequiresPaymentMethod || intent.getStatus() == StripeIntent.Status.RequiresAction) {
            StripeIntent stripeIntent = intent;
            if (stripeIntent instanceof PaymentIntent) {
                string2 = this.createForPaymentIntent((PaymentIntent)intent);
                return string2;
            } else {
                if (!(stripeIntent instanceof SetupIntent)) throw new NoWhenBranchMatchedException();
                string2 = this.createForSetupIntent((SetupIntent)intent);
            }
            return string2;
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String createForPaymentIntent(PaymentIntent paymentIntent) {
        String string2;
        block8: {
            block7: {
                block6: {
                    boolean bl;
                    if (paymentIntent.getStatus() != StripeIntent.Status.RequiresAction) break block6;
                    PaymentMethod paymentMethod = paymentIntent.getPaymentMethod();
                    if (paymentMethod == null) {
                        bl = false;
                    } else {
                        PaymentMethod.Type type = paymentMethod.type;
                        bl = type == null ? false : type.isVoucher;
                    }
                    if (!bl) break block7;
                }
                PaymentIntent.Error error = paymentIntent.getLastPaymentError();
                if (!Intrinsics.areEqual((Object)(error == null ? null : error.getCode()), (Object)"payment_intent_authentication_failure")) break block8;
            }
            string2 = this.context.getResources().getString(R.string.stripe_failure_reason_authentication);
            return string2;
        }
        PaymentIntent.Error error = paymentIntent.getLastPaymentError();
        if ((error == null ? null : error.getType()) == PaymentIntent.Error.Type.CardError) {
            string2 = paymentIntent.getLastPaymentError().getMessage();
            return string2;
        }
        string2 = null;
        return string2;
    }

    private final String createForSetupIntent(SetupIntent setupIntent) {
        String string2;
        SetupIntent.Error error = setupIntent.getLastSetupError();
        if (Intrinsics.areEqual((Object)(error == null ? null : error.getCode()), (Object)"setup_intent_authentication_failure")) {
            string2 = this.context.getResources().getString(R.string.stripe_failure_reason_authentication);
        } else {
            SetupIntent.Error error2 = setupIntent.getLastSetupError();
            string2 = (error2 == null ? null : error2.getType()) == SetupIntent.Error.Type.CardError ? setupIntent.getLastSetupError().getMessage() : (String)null;
        }
        return string2;
    }
}

