/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.bankaccount.di;

import android.app.Application;
import android.content.Context;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.injection.LoggingModule;
import com.stripe.android.core.injection.LoggingModule_ProvideLoggerFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountComponent;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidePublishableKeyFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesAppContextFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesEnableLoggingFactory;
import com.stripe.android.payments.bankaccount.di.CollectBankAccountModule_ProvidesProductUsageFactory;
import com.stripe.android.payments.bankaccount.domain.AttachLinkAccountSession;
import com.stripe.android.payments.bankaccount.domain.CreateLinkAccountSession;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountContract;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewEffect;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewModel;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.flow.MutableSharedFlow;

@DaggerGenerated
public final class DaggerCollectBankAccountComponent
implements CollectBankAccountComponent {
    private final CollectBankAccountContract.Args configuration;
    private final MutableSharedFlow<CollectBankAccountViewEffect> viewEffect;
    private final Application application;
    private final DaggerCollectBankAccountComponent collectBankAccountComponent = this;
    private Provider<CoroutineContext> provideWorkContextProvider;
    private Provider<Logger> provideLoggerProvider;

    private DaggerCollectBankAccountComponent(CoroutineContextModule coroutineContextModuleParam, LoggingModule loggingModuleParam, Application applicationParam, MutableSharedFlow<CollectBankAccountViewEffect> viewEffectParam, CollectBankAccountContract.Args configurationParam) {
        this.configuration = configurationParam;
        this.viewEffect = viewEffectParam;
        this.application = applicationParam;
        this.initialize(coroutineContextModuleParam, loggingModuleParam, applicationParam, viewEffectParam, configurationParam);
    }

    public static CollectBankAccountComponent.Builder builder() {
        return new Builder();
    }

    private Context context() {
        return CollectBankAccountModule_ProvidesAppContextFactory.providesAppContext(this.application);
    }

    private Function0<String> namedFunction0OfString() {
        return CollectBankAccountModule_ProvidePublishableKeyFactory.providePublishableKey(this.configuration);
    }

    private PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory() {
        return new PaymentAnalyticsRequestFactory(this.context(), this.namedFunction0OfString(), CollectBankAccountModule_ProvidesProductUsageFactory.providesProductUsage());
    }

    private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
        return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
    }

    private StripeApiRepository stripeApiRepository() {
        return new StripeApiRepository(this.context(), this.namedFunction0OfString(), (CoroutineContext)this.provideWorkContextProvider.get(), CollectBankAccountModule_ProvidesProductUsageFactory.providesProductUsage(), this.paymentAnalyticsRequestFactory(), (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
    }

    private CreateLinkAccountSession createLinkAccountSession() {
        return new CreateLinkAccountSession(this.stripeApiRepository());
    }

    private AttachLinkAccountSession attachLinkAccountSession() {
        return new AttachLinkAccountSession(this.stripeApiRepository());
    }

    private void initialize(CoroutineContextModule coroutineContextModuleParam, LoggingModule loggingModuleParam, Application applicationParam, MutableSharedFlow<CollectBankAccountViewEffect> viewEffectParam, CollectBankAccountContract.Args configurationParam) {
        this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
        this.provideLoggerProvider = DoubleCheck.provider((Provider)LoggingModule_ProvideLoggerFactory.create((LoggingModule)loggingModuleParam, (Provider)CollectBankAccountModule_ProvidesEnableLoggingFactory.create()));
    }

    @Override
    public CollectBankAccountViewModel getViewModel() {
        return new CollectBankAccountViewModel(this.configuration, this.viewEffect, this.createLinkAccountSession(), this.attachLinkAccountSession(), (Logger)this.provideLoggerProvider.get());
    }

    @Override
    public void inject(CollectBankAccountViewModel.Factory factory) {
    }

    private static final class Builder
    implements CollectBankAccountComponent.Builder {
        private Application application;
        private MutableSharedFlow<CollectBankAccountViewEffect> viewEffect;
        private CollectBankAccountContract.Args configuration;

        private Builder() {
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder viewEffect(MutableSharedFlow<CollectBankAccountViewEffect> application) {
            this.viewEffect = (MutableSharedFlow)Preconditions.checkNotNull(application);
            return this;
        }

        @Override
        public Builder configuration(CollectBankAccountContract.Args configuration) {
            this.configuration = (CollectBankAccountContract.Args)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public CollectBankAccountComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement(this.viewEffect, MutableSharedFlow.class);
            Preconditions.checkBuilderRequirement((Object)this.configuration, CollectBankAccountContract.Args.class);
            return new DaggerCollectBankAccountComponent(new CoroutineContextModule(), new LoggingModule(), this.application, this.viewEffect, this.configuration);
        }
    }
}

