/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.authentication;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeIntentKtxKt;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.authentication.PaymentAuthenticator;
import com.stripe.android.view.AuthActivityStarterHost;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001b\b\u0007\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/payments/core/authentication/UnsupportedAuthenticator;", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticator;", "Lcom/stripe/android/model/StripeIntent;", "paymentRelayStarterFactory", "Lkotlin/Function1;", "Lcom/stripe/android/view/AuthActivityStarterHost;", "Lcom/stripe/android/PaymentRelayStarter;", "(Lkotlin/jvm/functions/Function1;)V", "authenticate", "", "host", "authenticatable", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "(Lcom/stripe/android/view/AuthActivityStarterHost;Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/core/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "payments-core_release"})
@JvmSuppressWildcards
public final class UnsupportedAuthenticator
implements PaymentAuthenticator<StripeIntent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<AuthActivityStarterHost, PaymentRelayStarter> paymentRelayStarterFactory;
    @NotNull
    private static final Map<Class<? extends StripeIntent.NextActionData>, String> ACTION_DEPENDENCY_MAP = MapsKt.mapOf((Pair)TuplesKt.to(StripeIntent.NextActionData.WeChatPayRedirect.class, (Object)"com.stripe:stripe-wechatpay:20.1.0"));

    @Inject
    public UnsupportedAuthenticator(@NotNull Function1<AuthActivityStarterHost, PaymentRelayStarter> paymentRelayStarterFactory2) {
        Intrinsics.checkNotNullParameter(paymentRelayStarterFactory2, (String)"paymentRelayStarterFactory");
        this.paymentRelayStarterFactory = paymentRelayStarterFactory2;
    }

    @Override
    @Nullable
    public Object authenticate(@NotNull AuthActivityStarterHost host, @NotNull StripeIntent authenticatable, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<Unit> $completion) {
        StripeException stripeException;
        StripeException stripeException2;
        StripeIntent.NextActionData nextActionData = authenticatable.getNextActionData();
        if (nextActionData == null) {
            stripeException2 = null;
        } else {
            StripeIntent.NextActionData it = nextActionData;
            boolean bl = false;
            Class<?> nextActionType = it.getClass();
            stripeException2 = StripeException.Companion.create((Throwable)new IllegalArgumentException(nextActionType.getSimpleName() + " type is not supported, add " + ACTION_DEPENDENCY_MAP.get(nextActionType) + " in build.gradle to support it"));
        }
        StripeException stripeException3 = stripeException2;
        if (stripeException3 == null) {
            UnsupportedAuthenticator $this$authenticate_u24lambda_u2d1 = this;
            boolean bl = false;
            stripeException = StripeException.Companion.create((Throwable)new IllegalArgumentException("stripeIntent.nextActionData is null"));
        } else {
            stripeException = stripeException3;
        }
        StripeException exception = stripeException;
        ((PaymentRelayStarter)this.paymentRelayStarterFactory.invoke((Object)host)).start(new PaymentRelayStarter.Args.ErrorArgs(exception, StripeIntentKtxKt.getRequestCode(authenticatable)));
        return Unit.INSTANCE;
    }

    @Override
    public void onNewActivityResultCaller(@NotNull ActivityResultCaller activityResultCaller, @NotNull ActivityResultCallback<PaymentFlowResult.Unvalidated> activityResultCallback) {
        PaymentAuthenticator.DefaultImpls.onNewActivityResultCaller(this, activityResultCaller, activityResultCallback);
    }

    @Override
    public void onLauncherInvalidated() {
        PaymentAuthenticator.DefaultImpls.onLauncherInvalidated(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R%\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/payments/core/authentication/UnsupportedAuthenticator$Companion;", "", "()V", "ACTION_DEPENDENCY_MAP", "", "Ljava/lang/Class;", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "", "getACTION_DEPENDENCY_MAP", "()Ljava/util/Map;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Class<? extends StripeIntent.NextActionData>, String> getACTION_DEPENDENCY_MAP() {
            return ACTION_DEPENDENCY_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

