/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.paymentlauncher;

import android.content.Context;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.injection.Injector;
import com.stripe.android.core.injection.InjectorKey;
import com.stripe.android.core.injection.UIContext;
import com.stripe.android.core.injection.WeakMapInjectorRegistry;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.core.injection.DaggerPaymentLauncherComponent;
import com.stripe.android.payments.core.injection.PaymentLauncherComponent;
import com.stripe.android.payments.paymentlauncher.PaymentLauncher;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherContract;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u007f\b\u0001\u0012\u000e\b\u0001\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0010\b\u0001\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0014\u0010%\u001a\u00020\u001e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/stripe/android/payments/paymentlauncher/StripePaymentLauncher;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncher;", "Lcom/stripe/android/core/injection/Injector;", "publishableKeyProvider", "Lkotlin/Function0;", "", "stripeAccountIdProvider", "hostActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherContract$Args;", "context", "Landroid/content/Context;", "enableLogging", "", "ioContext", "Lkotlin/coroutines/CoroutineContext;", "uiContext", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "productUsage", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/activity/result/ActivityResultLauncher;Landroid/content/Context;ZLkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Ljava/util/Set;)V", "injectorKey", "getInjectorKey$annotations", "()V", "paymentLauncherComponent", "Lcom/stripe/android/payments/core/injection/PaymentLauncherComponent;", "confirm", "", "params", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "handleNextActionForPaymentIntent", "clientSecret", "handleNextActionForSetupIntent", "inject", "injectable", "Lcom/stripe/android/core/injection/Injectable;", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class StripePaymentLauncher
implements PaymentLauncher,
Injector {
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final Function0<String> stripeAccountIdProvider;
    @NotNull
    private final ActivityResultLauncher<PaymentLauncherContract.Args> hostActivityLauncher;
    private final boolean enableLogging;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final PaymentLauncherComponent paymentLauncherComponent;
    @NotNull
    private final String injectorKey;
    public static final int $stable = 8;

    @AssistedInject
    public StripePaymentLauncher(@Assisted(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Assisted(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider, @Assisted @NotNull ActivityResultLauncher<PaymentLauncherContract.Args> hostActivityLauncher, @NotNull Context context, @Named(value="enableLogging") boolean enableLogging, @IOContext @NotNull CoroutineContext ioContext, @UIContext @NotNull CoroutineContext uiContext, @NotNull StripeRepository stripeRepository2, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @Named(value="productUsage") @NotNull Set<String> productUsage) {
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
        Intrinsics.checkNotNullParameter(hostActivityLauncher, (String)"hostActivityLauncher");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ioContext, (String)"ioContext");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
        this.publishableKeyProvider = publishableKeyProvider;
        this.stripeAccountIdProvider = stripeAccountIdProvider;
        this.hostActivityLauncher = hostActivityLauncher;
        this.enableLogging = enableLogging;
        this.productUsage = productUsage;
        this.paymentLauncherComponent = DaggerPaymentLauncherComponent.builder().context(context).enableLogging(this.enableLogging).ioContext(ioContext).uiContext(uiContext).stripeRepository(stripeRepository2).analyticsRequestFactory(paymentAnalyticsRequestFactory).publishableKeyProvider(this.publishableKeyProvider).stripeAccountIdProvider(this.stripeAccountIdProvider).productUsage(this.productUsage).build();
        String string2 = Reflection.getOrCreateKotlinClass(PaymentLauncher.class).getSimpleName();
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        this.injectorKey = WeakMapInjectorRegistry.INSTANCE.nextKey(string2);
        WeakMapInjectorRegistry.INSTANCE.register((Injector)this, this.injectorKey);
    }

    @InjectorKey
    private static /* synthetic */ void getInjectorKey$annotations() {
    }

    public void inject(@NotNull Injectable<?> injectable) {
        Intrinsics.checkNotNullParameter(injectable, (String)"injectable");
        if (!(injectable instanceof PaymentLauncherViewModel.Factory)) {
            throw new IllegalArgumentException("invalid Injectable " + injectable + " requested in " + this);
        }
        this.paymentLauncherComponent.inject((PaymentLauncherViewModel.Factory)injectable);
    }

    @Override
    public void confirm(@NotNull ConfirmPaymentIntentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.IntentConfirmationArgs(this.injectorKey, (String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, params, null, 64, null));
    }

    @Override
    public void confirm(@NotNull ConfirmSetupIntentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.IntentConfirmationArgs(this.injectorKey, (String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, params, null, 64, null));
    }

    @Override
    public void handleNextActionForPaymentIntent(@NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.PaymentIntentNextActionArgs(this.injectorKey, (String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, clientSecret, null, 64, null));
    }

    @Override
    public void handleNextActionForSetupIntent(@NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.SetupIntentNextActionArgs(this.injectorKey, (String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, clientSecret, null, 64, null));
    }
}

