/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Intent;
import android.net.Uri;
import android.webkit.URLUtil;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.MutableLiveData;
import com.stripe.android.core.Logger;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0014\u0010 \u001a\u00020\r2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0018\u0010)\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u001c\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewClient;", "Landroid/webkit/WebViewClient;", "logger", "Lcom/stripe/android/core/Logger;", "isPageLoaded", "Landroidx/lifecycle/MutableLiveData;", "", "clientSecret", "", "returnUrl", "activityStarter", "Lkotlin/Function1;", "Landroid/content/Intent;", "", "activityFinisher", "", "(Lcom/stripe/android/core/Logger;Landroidx/lifecycle/MutableLiveData;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "<set-?>", "completionUrlParam", "getCompletionUrlParam", "()Ljava/lang/String;", "hasLoadedBlank", "getHasLoadedBlank$payments_core_release", "()Z", "setHasLoadedBlank$payments_core_release", "(Z)V", "userReturnUri", "Landroid/net/Uri;", "hideProgressBar", "isPredefinedReturnUrl", "uri", "isReturnUrl", "onAuthCompleted", "error", "onPageFinished", "view", "Landroid/webkit/WebView;", "url", "openIntent", "intent", "openIntentScheme", "shouldOverrideUrlLoading", "request", "Landroid/webkit/WebResourceRequest;", "updateCompletionUrl", "Companion", "payments-core_release"})
public final class PaymentAuthWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final MutableLiveData<Boolean> isPageLoaded;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final Function1<Intent, Unit> activityStarter;
    @NotNull
    private final Function1<Throwable, Unit> activityFinisher;
    @Nullable
    private final Uri userReturnUri;
    @Nullable
    private String completionUrlParam;
    private boolean hasLoadedBlank;
    @NotNull
    public static final String PARAM_PAYMENT_CLIENT_SECRET = "payment_intent_client_secret";
    @NotNull
    public static final String PARAM_SETUP_CLIENT_SECRET = "setup_intent_client_secret";
    @NotNull
    private static final Set<String> AUTHENTICATE_URLS = SetsKt.setOf((Object)"https://hooks.stripe.com/three_d_secure/authenticate");
    @NotNull
    private static final Set<String> COMPLETION_URLS;
    @NotNull
    private static final String PARAM_RETURN_URL = "return_url";
    @NotNull
    public static final String BLANK_PAGE = "about:blank";

    /*
     * WARNING - void declaration
     */
    public PaymentAuthWebViewClient(@NotNull Logger logger2, @NotNull MutableLiveData<Boolean> isPageLoaded, @NotNull String clientSecret, @Nullable String returnUrl, @NotNull Function1<? super Intent, Unit> activityStarter, @NotNull Function1<? super Throwable, Unit> activityFinisher) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(isPageLoaded, (String)"isPageLoaded");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter(activityStarter, (String)"activityStarter");
        Intrinsics.checkNotNullParameter(activityFinisher, (String)"activityFinisher");
        this.logger = logger2;
        this.isPageLoaded = isPageLoaded;
        this.clientSecret = clientSecret;
        this.activityStarter = activityStarter;
        this.activityFinisher = activityFinisher;
        PaymentAuthWebViewClient paymentAuthWebViewClient = this;
        String string2 = returnUrl;
        if (string2 == null) {
            uri = null;
        } else {
            void it;
            String string3 = string2;
            PaymentAuthWebViewClient paymentAuthWebViewClient2 = paymentAuthWebViewClient;
            boolean bl = false;
            uri = Uri.parse((String)it);
            paymentAuthWebViewClient = paymentAuthWebViewClient2;
        }
        paymentAuthWebViewClient.userReturnUri = uri;
    }

    @Nullable
    public final String getCompletionUrlParam() {
        return this.completionUrlParam;
    }

    public final boolean getHasLoadedBlank$payments_core_release() {
        return this.hasLoadedBlank;
    }

    public final void setHasLoadedBlank$payments_core_release(boolean bl) {
        this.hasLoadedBlank = bl;
    }

    public void onPageFinished(@NotNull WebView view, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.logger.debug(Intrinsics.stringPlus((String)"PaymentAuthWebViewClient#onPageFinished() - ", (Object)url));
        super.onPageFinished(view, url);
        if (!this.hasLoadedBlank) {
            this.hideProgressBar();
        }
        if (url != null && Companion.isCompletionUrl$payments_core_release(url)) {
            this.logger.debug(Intrinsics.stringPlus((String)url, (Object)" is a completion URL"));
            PaymentAuthWebViewClient.onAuthCompleted$default(this, null, 1, null);
        }
    }

    private final void hideProgressBar() {
        this.logger.debug("PaymentAuthWebViewClient#hideProgressBar()");
        this.isPageLoaded.setValue((Object)true);
    }

    public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull WebResourceRequest request) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Uri url = request.getUrl();
        this.logger.debug(Intrinsics.stringPlus((String)"PaymentAuthWebViewClient#shouldOverrideUrlLoading(): ", (Object)url));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        this.updateCompletionUrl(url);
        if (this.isReturnUrl(url)) {
            this.logger.debug("PaymentAuthWebViewClient#shouldOverrideUrlLoading() - handle return URL");
            PaymentAuthWebViewClient.onAuthCompleted$default(this, null, 1, null);
            bl = true;
        } else if (StringsKt.equals((String)"intent", (String)url.getScheme(), (boolean)true)) {
            this.openIntentScheme(url);
            bl = true;
        } else if (!URLUtil.isNetworkUrl((String)url.toString())) {
            this.openIntent(new Intent("android.intent.action.VIEW", url));
            bl = true;
        } else {
            bl = super.shouldOverrideUrlLoading(view, request);
        }
        return bl;
    }

    private final void openIntentScheme(Uri uri) {
        Object object;
        this.logger.debug("PaymentAuthWebViewClient#openIntentScheme()");
        Object object2 = this;
        try {
            PaymentAuthWebViewClient $this$openIntentScheme_u24lambda_u2d1 = object2;
            boolean bl = false;
            Intent intent = Intent.parseUri((String)uri.toString(), (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"parseUri(uri.toString(), Intent.URI_INTENT_SCHEME)");
            $this$openIntentScheme_u24lambda_u2d1.openIntent(intent);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            this.logger.error("Failed to start Intent.", error);
            this.onAuthCompleted(error);
        }
    }

    private final void openIntent(Intent intent) {
        Object object;
        this.logger.debug("PaymentAuthWebViewClient#openIntent()");
        Object object2 = this;
        try {
            PaymentAuthWebViewClient $this$openIntent_u24lambda_u2d3 = object2;
            boolean bl = false;
            $this$openIntent_u24lambda_u2d3.activityStarter.invoke((Object)intent);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            this.logger.error("Failed to start Intent.", error);
            if (!Intrinsics.areEqual((Object)intent.getScheme(), (Object)"alipays")) {
                this.onAuthCompleted(error);
            }
        }
    }

    private final void updateCompletionUrl(Uri uri) {
        this.logger.debug("PaymentAuthWebViewClient#updateCompletionUrl()");
        CharSequence charSequence = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"uri.toString()");
        String returnUrlParam = PaymentAuthWebViewClient.Companion.isAuthenticateUrl(charSequence) ? uri.getQueryParameter(PARAM_RETURN_URL) : (String)null;
        charSequence = returnUrlParam;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.completionUrlParam = returnUrlParam;
        }
    }

    private final boolean isReturnUrl(Uri uri) {
        this.logger.debug("PaymentAuthWebViewClient#isReturnUrl()");
        if (this.isPredefinedReturnUrl(uri)) {
            return true;
        }
        if (this.userReturnUri != null) {
            return this.userReturnUri.getScheme() != null && Intrinsics.areEqual((Object)this.userReturnUri.getScheme(), (Object)uri.getScheme()) && this.userReturnUri.getHost() != null && Intrinsics.areEqual((Object)this.userReturnUri.getHost(), (Object)uri.getHost());
        }
        if (uri.isOpaque()) {
            return false;
        }
        Set paramNames = uri.getQueryParameterNames();
        String clientSecret = paramNames.contains(PARAM_PAYMENT_CLIENT_SECRET) ? uri.getQueryParameter(PARAM_PAYMENT_CLIENT_SECRET) : (paramNames.contains(PARAM_SETUP_CLIENT_SECRET) ? uri.getQueryParameter(PARAM_SETUP_CLIENT_SECRET) : null);
        return Intrinsics.areEqual((Object)this.clientSecret, (Object)clientSecret);
    }

    private final boolean isPredefinedReturnUrl(Uri uri) {
        return Intrinsics.areEqual((Object)"stripejs://use_stripe_sdk/return_url", (Object)uri.toString());
    }

    private final void onAuthCompleted(Throwable error) {
        this.logger.debug("PaymentAuthWebViewClient#onAuthCompleted()");
        this.activityFinisher.invoke((Object)error);
    }

    static /* synthetic */ void onAuthCompleted$default(PaymentAuthWebViewClient paymentAuthWebViewClient, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        paymentAuthWebViewClient.onAuthCompleted(throwable);
    }

    static {
        Object[] objectArray = new String[]{"https://hooks.stripe.com/redirect/complete/", "https://hooks.stripe.com/3d_secure/complete/"};
        COMPLETION_URLS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewClient$Companion;", "", "()V", "AUTHENTICATE_URLS", "", "", "BLANK_PAGE", "COMPLETION_URLS", "PARAM_PAYMENT_CLIENT_SECRET", "PARAM_RETURN_URL", "PARAM_SETUP_CLIENT_SECRET", "isAuthenticateUrl", "", "url", "isCompletionUrl", "isCompletionUrl$payments_core_release", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean isCompletionUrl$payments_core_release(@NotNull String url) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Iterable $this$any$iv = COMPLETION_URLS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String p0 = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)url, (String)p0, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isAuthenticateUrl(String url) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = AUTHENTICATE_URLS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String p0 = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)url, (String)p0, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

