/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J;\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PostalCodeValidator;", "", "()V", "isValid", "", "postalCode", "", "countryCode", "optionalShippingInfoFields", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "hiddenShippingInfoFields", "isValid$payments_core_release", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PostalCodeValidator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @Deprecated
    @NotNull
    private static final Map<String, Pattern> POSTAL_CODE_PATTERNS;

    public final boolean isValid(@NotNull String postalCode, @NotNull String countryCode) {
        Boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)postalCode, (String)"postalCode");
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Pattern pattern = POSTAL_CODE_PATTERNS.get(countryCode);
        if (pattern == null) {
            bl2 = null;
        } else {
            Matcher matcher = pattern.matcher(postalCode);
            bl2 = bl = matcher == null ? null : Boolean.valueOf(matcher.matches());
        }
        return bl == null ? !CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode) || !StringsKt.isBlank((CharSequence)postalCode) : bl;
    }

    public final boolean isValid$payments_core_release(@NotNull String postalCode, @Nullable String countryCode, @NotNull List<? extends ShippingInfoWidget.CustomizableShippingField> optionalShippingInfoFields, @NotNull List<? extends ShippingInfoWidget.CustomizableShippingField> hiddenShippingInfoFields) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)postalCode, (String)"postalCode");
        Intrinsics.checkNotNullParameter(optionalShippingInfoFields, (String)"optionalShippingInfoFields");
        Intrinsics.checkNotNullParameter(hiddenShippingInfoFields, (String)"hiddenShippingInfoFields");
        if (countryCode == null) {
            return false;
        }
        if (((CharSequence)postalCode).length() == 0 && PostalCodeValidator.Companion.isPostalCodeNotRequired(optionalShippingInfoFields, hiddenShippingInfoFields)) {
            bl = true;
        } else {
            Boolean bl2;
            Boolean bl3;
            Pattern pattern = POSTAL_CODE_PATTERNS.get(countryCode);
            if (pattern == null) {
                bl3 = null;
            } else {
                Matcher matcher = pattern.matcher(postalCode);
                bl3 = bl2 = matcher == null ? null : Boolean.valueOf(matcher.matches());
            }
            bl = bl2 == null ? !CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode) || !StringsKt.isBlank((CharSequence)postalCode) : bl2;
        }
        return bl;
    }

    static {
        POSTAL_CODE_PATTERNS = MapsKt.mapOf((Pair)TuplesKt.to((Object)Locale.US.getCountry(), (Object)Pattern.compile("^[0-9]{5}(?:-[0-9]{4})?$")));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PostalCodeValidator$Companion;", "", "()V", "POSTAL_CODE_PATTERNS", "", "", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isPostalCodeNotRequired", "", "optionalShippingInfoFields", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "hiddenShippingInfoFields", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isPostalCodeNotRequired(List<? extends ShippingInfoWidget.CustomizableShippingField> optionalShippingInfoFields, List<? extends ShippingInfoWidget.CustomizableShippingField> hiddenShippingInfoFields) {
            return optionalShippingInfoFields.contains((Object)ShippingInfoWidget.CustomizableShippingField.PostalCode) || hiddenShippingInfoFields.contains((Object)ShippingInfoWidget.CustomizableShippingField.PostalCode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

