/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.GooglePayConfig;
import com.stripe.android.PayWithGoogleUtils;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 &2\u00020\u0001:\u0005%&'()B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B1\b\u0011\u0012\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\b\u0001\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0017\u0012\u0006\u0010\u000b\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J!\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u0019JO\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00052\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u000b\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/GooglePayJsonFactory;", "", "context", "Landroid/content/Context;", "isJcbEnabled", "", "(Landroid/content/Context;Z)V", "publishableKeyProvider", "Lkotlin/Function0;", "", "stripeAccountIdProvider", "googlePayConfig", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Config;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Config;)V", "Lcom/stripe/android/GooglePayConfig;", "(Lcom/stripe/android/GooglePayConfig;Z)V", "createBaseCardPaymentMethodParams", "Lorg/json/JSONObject;", "createCardPaymentMethod", "billingAddressParameters", "Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;", "allowCreditCards", "(Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;Ljava/lang/Boolean;)Lorg/json/JSONObject;", "createIsReadyToPayRequest", "existingPaymentMethodRequired", "(Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lorg/json/JSONObject;", "createPaymentDataRequest", "transactionInfo", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "shippingAddressParameters", "Lcom/stripe/android/GooglePayJsonFactory$ShippingAddressParameters;", "isEmailRequired", "merchantInfo", "Lcom/stripe/android/GooglePayJsonFactory$MerchantInfo;", "(Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;Lcom/stripe/android/GooglePayJsonFactory$ShippingAddressParameters;ZLcom/stripe/android/GooglePayJsonFactory$MerchantInfo;Ljava/lang/Boolean;)Lorg/json/JSONObject;", "createShippingAddressParameters", "createTransactionInfo", "BillingAddressParameters", "Companion", "MerchantInfo", "ShippingAddressParameters", "TransactionInfo", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class GooglePayJsonFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final GooglePayConfig googlePayConfig;
    private final boolean isJcbEnabled;
    public static final int $stable;
    @Deprecated
    private static final int API_VERSION = 2;
    @Deprecated
    private static final int API_VERSION_MINOR = 0;
    @Deprecated
    @NotNull
    private static final String CARD_PAYMENT_METHOD = "CARD";
    @Deprecated
    @NotNull
    private static final List<String> ALLOWED_AUTH_METHODS;
    @Deprecated
    @NotNull
    private static final List<String> DEFAULT_CARD_NETWORKS;
    @Deprecated
    @NotNull
    private static final String JCB_CARD_NETWORK = "JCB";

    public GooglePayJsonFactory(@NotNull GooglePayConfig googlePayConfig, boolean isJcbEnabled) {
        Intrinsics.checkNotNullParameter((Object)googlePayConfig, (String)"googlePayConfig");
        this.googlePayConfig = googlePayConfig;
        this.isJcbEnabled = isJcbEnabled;
    }

    public /* synthetic */ GooglePayJsonFactory(GooglePayConfig googlePayConfig, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(googlePayConfig, bl);
    }

    public GooglePayJsonFactory(@NotNull Context context, boolean isJcbEnabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new GooglePayConfig(context), isJcbEnabled);
    }

    public /* synthetic */ GooglePayJsonFactory(Context context, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl);
    }

    @Inject
    public GooglePayJsonFactory(@Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Named(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider, @NotNull GooglePayPaymentMethodLauncher.Config googlePayConfig) {
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
        Intrinsics.checkNotNullParameter((Object)googlePayConfig, (String)"googlePayConfig");
        this(new GooglePayConfig((String)publishableKeyProvider.invoke(), (String)stripeAccountIdProvider.invoke()), googlePayConfig.isJcbEnabled$payments_core_release());
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createIsReadyToPayRequest(@Nullable BillingAddressParameters billingAddressParameters, @Nullable Boolean existingPaymentMethodRequired, @Nullable Boolean allowCreditCards) {
        JSONObject jSONObject;
        JSONObject $this$createIsReadyToPayRequest_u24lambda_u2d0 = jSONObject = new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0).put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.createCardPaymentMethod(billingAddressParameters, allowCreditCards)));
        boolean bl = false;
        if (existingPaymentMethodRequired != null) {
            $this$createIsReadyToPayRequest_u24lambda_u2d0.put("existingPaymentMethodRequired", existingPaymentMethodRequired.booleanValue());
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject2;
    }

    public static /* synthetic */ JSONObject createIsReadyToPayRequest$default(GooglePayJsonFactory googlePayJsonFactory, BillingAddressParameters billingAddressParameters, Boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            billingAddressParameters = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        return googlePayJsonFactory.createIsReadyToPayRequest(billingAddressParameters, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters, @Nullable ShippingAddressParameters shippingAddressParameters, boolean isEmailRequired, @Nullable MerchantInfo merchantInfo, @Nullable Boolean allowCreditCards) {
        CharSequence charSequence;
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        JSONObject $this$createPaymentDataRequest_u24lambda_u2d1 = jSONObject = new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0).put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.createCardPaymentMethod(billingAddressParameters, allowCreditCards))).put("transactionInfo", (Object)this.createTransactionInfo(transactionInfo)).put("emailRequired", isEmailRequired);
        boolean bl = false;
        ShippingAddressParameters shippingAddressParameters2 = shippingAddressParameters;
        boolean bl2 = shippingAddressParameters2 != null ? shippingAddressParameters2.isRequired$payments_core_release() : false;
        if (bl2) {
            $this$createPaymentDataRequest_u24lambda_u2d1.put("shippingAddressRequired", true);
            $this$createPaymentDataRequest_u24lambda_u2d1.put("shippingAddressParameters", (Object)this.createShippingAddressParameters(shippingAddressParameters));
        }
        if (merchantInfo != null && !((charSequence = (CharSequence)merchantInfo.getMerchantName$payments_core_release()) == null || charSequence.length() == 0)) {
            $this$createPaymentDataRequest_u24lambda_u2d1.put("merchantInfo", (Object)new JSONObject().put("merchantName", (Object)merchantInfo.getMerchantName$payments_core_release()));
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject2;
    }

    public static /* synthetic */ JSONObject createPaymentDataRequest$default(GooglePayJsonFactory googlePayJsonFactory, TransactionInfo transactionInfo, BillingAddressParameters billingAddressParameters, ShippingAddressParameters shippingAddressParameters, boolean bl, MerchantInfo merchantInfo, Boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            billingAddressParameters = null;
        }
        if ((n & 4) != 0) {
            shippingAddressParameters = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            merchantInfo = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = null;
        }
        return googlePayJsonFactory.createPaymentDataRequest(transactionInfo, billingAddressParameters, shippingAddressParameters, bl, merchantInfo, bl2);
    }

    private final JSONObject createTransactionInfo(TransactionInfo transactionInfo) {
        String it;
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        String string = transactionInfo.getCurrencyCode$payments_core_release().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        JSONObject $this$createTransactionInfo_u24lambda_u2d7 = jSONObject = jSONObject2.put("currencyCode", (Object)string).put("totalPriceStatus", (Object)transactionInfo.getTotalPriceStatus$payments_core_release().getCode$payments_core_release());
        boolean bl = false;
        String string2 = transactionInfo.getCountryCode$payments_core_release();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            String string3 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            $this$createTransactionInfo_u24lambda_u2d7.put("countryCode", (Object)string3);
        }
        String string4 = transactionInfo.getTransactionId$payments_core_release();
        if (string4 != null) {
            it = string4;
            boolean bl3 = false;
            $this$createTransactionInfo_u24lambda_u2d7.put("transactionId", (Object)it);
        }
        Integer n = transactionInfo.getTotalPrice$payments_core_release();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl4 = false;
            String string5 = transactionInfo.getCurrencyCode$payments_core_release().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            Currency currency = Currency.getInstance(string5);
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(\n           \u2026                        )");
            $this$createTransactionInfo_u24lambda_u2d7.put("totalPrice", (Object)PayWithGoogleUtils.getPriceString(it2, currency));
        }
        String string6 = transactionInfo.getTotalPriceLabel$payments_core_release();
        if (string6 != null) {
            String it3 = string6;
            boolean bl5 = false;
            $this$createTransactionInfo_u24lambda_u2d7.put("totalPriceLabel", (Object)it3);
        }
        TransactionInfo.CheckoutOption checkoutOption = transactionInfo.getCheckoutOption$payments_core_release();
        if (checkoutOption != null) {
            TransactionInfo.CheckoutOption it4 = checkoutOption;
            boolean bl6 = false;
            $this$createTransactionInfo_u24lambda_u2d7.put("checkoutOption", (Object)it4.getCode$payments_core_release());
        }
        JSONObject jSONObject3 = jSONObject;
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject3, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject3;
    }

    private final JSONObject createShippingAddressParameters(ShippingAddressParameters shippingAddressParameters) {
        JSONObject jSONObject = new JSONObject().put("allowedCountryCodes", (Object)new JSONArray((Collection)shippingAddressParameters.getNormalizedAllowedCountryCodes$payments_core_release())).put("phoneNumberRequired", shippingAddressParameters.getPhoneNumberRequired$payments_core_release());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"JSONObject()\n           \u2026berRequired\n            )");
        return jSONObject;
    }

    private final JSONObject createCardPaymentMethod(BillingAddressParameters billingAddressParameters, Boolean allowCreditCards) {
        JSONObject jSONObject;
        JSONObject $this$createCardPaymentMethod_u24lambda_u2d9 = jSONObject = this.createBaseCardPaymentMethodParams();
        boolean bl = false;
        BillingAddressParameters billingAddressParameters2 = billingAddressParameters;
        boolean bl2 = billingAddressParameters2 != null ? billingAddressParameters2.isRequired$payments_core_release() : false;
        if (bl2) {
            $this$createCardPaymentMethod_u24lambda_u2d9.put("billingAddressRequired", true);
            $this$createCardPaymentMethod_u24lambda_u2d9.put("billingAddressParameters", (Object)new JSONObject().put("phoneNumberRequired", billingAddressParameters.isPhoneNumberRequired$payments_core_release()).put("format", (Object)billingAddressParameters.getFormat$payments_core_release().getCode$payments_core_release()));
        }
        Boolean bl3 = allowCreditCards;
        if (bl3 != null) {
            boolean it = bl3;
            boolean bl4 = false;
            $this$createCardPaymentMethod_u24lambda_u2d9.put("allowCreditCards", it);
        }
        JSONObject cardPaymentMethodParams = jSONObject;
        JSONObject jSONObject2 = new JSONObject().put("type", (Object)CARD_PAYMENT_METHOD).put("parameters", (Object)cardPaymentMethodParams).put("tokenizationSpecification", (Object)this.googlePayConfig.getTokenizationSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject()\n           \u2026okenizationSpecification)");
        return jSONObject2;
    }

    private final JSONObject createBaseCardPaymentMethodParams() {
        List list;
        List list2 = list = CollectionsKt.listOf((Object)JCB_CARD_NETWORK);
        Collection collection = DEFAULT_CARD_NETWORKS;
        String string = "allowedCardNetworks";
        JSONObject jSONObject = new JSONObject().put("allowedAuthMethods", (Object)new JSONArray((Collection)ALLOWED_AUTH_METHODS));
        boolean bl = false;
        boolean bl2 = this.isJcbEnabled;
        List list3 = bl2 ? list : null;
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)(list3 != null ? (Iterable)list3 : (Iterable)CollectionsKt.emptyList()));
        JSONObject jSONObject2 = jSONObject.put(string, (Object)new JSONArray(collection2));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject()\n           \u2026          )\n            )");
        return jSONObject2;
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createIsReadyToPayRequest(@Nullable BillingAddressParameters billingAddressParameters, @Nullable Boolean existingPaymentMethodRequired) {
        return GooglePayJsonFactory.createIsReadyToPayRequest$default(this, billingAddressParameters, existingPaymentMethodRequired, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createIsReadyToPayRequest(@Nullable BillingAddressParameters billingAddressParameters) {
        return GooglePayJsonFactory.createIsReadyToPayRequest$default(this, billingAddressParameters, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createIsReadyToPayRequest() {
        return GooglePayJsonFactory.createIsReadyToPayRequest$default(this, null, null, null, 7, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters, @Nullable ShippingAddressParameters shippingAddressParameters, boolean isEmailRequired, @Nullable MerchantInfo merchantInfo) {
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        return GooglePayJsonFactory.createPaymentDataRequest$default(this, transactionInfo, billingAddressParameters, shippingAddressParameters, isEmailRequired, merchantInfo, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters, @Nullable ShippingAddressParameters shippingAddressParameters, boolean isEmailRequired) {
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        return GooglePayJsonFactory.createPaymentDataRequest$default(this, transactionInfo, billingAddressParameters, shippingAddressParameters, isEmailRequired, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters, @Nullable ShippingAddressParameters shippingAddressParameters) {
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        return GooglePayJsonFactory.createPaymentDataRequest$default(this, transactionInfo, billingAddressParameters, shippingAddressParameters, false, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters) {
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        return GooglePayJsonFactory.createPaymentDataRequest$default(this, transactionInfo, billingAddressParameters, null, false, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo) {
        Intrinsics.checkNotNullParameter((Object)transactionInfo, (String)"transactionInfo");
        return GooglePayJsonFactory.createPaymentDataRequest$default(this, transactionInfo, null, null, false, null, null, 62, null);
    }

    static {
        Object[] objectArray = new String[]{"PAN_ONLY", "CRYPTOGRAM_3DS"};
        ALLOWED_AUTH_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"AMEX", "DISCOVER", "MASTERCARD", "VISA"};
        DEFAULT_CARD_NETWORKS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001!B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;", "Landroid/os/Parcelable;", "isRequired", "", "format", "Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "isPhoneNumberRequired", "(ZLcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;Z)V", "getFormat$payments_core_release", "()Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "isPhoneNumberRequired$payments_core_release", "()Z", "isRequired$payments_core_release", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "component3", "component3$payments_core_release", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Format", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class BillingAddressParameters
    implements Parcelable {
        private final boolean isRequired;
        @NotNull
        private final Format format;
        private final boolean isPhoneNumberRequired;
        @NotNull
        public static final Parcelable.Creator<BillingAddressParameters> CREATOR;
        public static final int $stable;

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired, @NotNull Format format, boolean isPhoneNumberRequired) {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this.isRequired = isRequired;
            this.format = format;
            this.isPhoneNumberRequired = isPhoneNumberRequired;
        }

        public /* synthetic */ BillingAddressParameters(boolean bl, Format format, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                format = Format.Min;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(bl, format, bl2);
        }

        public final boolean isRequired$payments_core_release() {
            return this.isRequired;
        }

        @NotNull
        public final Format getFormat$payments_core_release() {
            return this.format;
        }

        public final boolean isPhoneNumberRequired$payments_core_release() {
            return this.isPhoneNumberRequired;
        }

        public final boolean component1$payments_core_release() {
            return this.isRequired;
        }

        @NotNull
        public final Format component2$payments_core_release() {
            return this.format;
        }

        public final boolean component3$payments_core_release() {
            return this.isPhoneNumberRequired;
        }

        @NotNull
        public final BillingAddressParameters copy(boolean isRequired, @NotNull Format format, boolean isPhoneNumberRequired) {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return new BillingAddressParameters(isRequired, format, isPhoneNumberRequired);
        }

        public static /* synthetic */ BillingAddressParameters copy$default(BillingAddressParameters billingAddressParameters, boolean bl, Format format, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = billingAddressParameters.isRequired;
            }
            if ((n & 2) != 0) {
                format = billingAddressParameters.format;
            }
            if ((n & 4) != 0) {
                bl2 = billingAddressParameters.isPhoneNumberRequired;
            }
            return billingAddressParameters.copy(bl, format, bl2);
        }

        @NotNull
        public String toString() {
            return "BillingAddressParameters(isRequired=" + this.isRequired + ", format=" + (Object)((Object)this.format) + ", isPhoneNumberRequired=" + this.isPhoneNumberRequired + ')';
        }

        public int hashCode() {
            int n = this.isRequired ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + this.format.hashCode();
            int n2 = this.isPhoneNumberRequired ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BillingAddressParameters)) {
                return false;
            }
            BillingAddressParameters billingAddressParameters = (BillingAddressParameters)other;
            if (this.isRequired != billingAddressParameters.isRequired) {
                return false;
            }
            if (this.format != billingAddressParameters.format) {
                return false;
            }
            return this.isPhoneNumberRequired == billingAddressParameters.isPhoneNumberRequired;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.isRequired ? 1 : 0);
            out.writeString(this.format.name());
            out.writeInt(this.isPhoneNumberRequired ? 1 : 0);
        }

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired, @NotNull Format format) {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            this(isRequired, format, false, 4, null);
        }

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired) {
            this(isRequired, null, false, 6, null);
        }

        @JvmOverloads
        public BillingAddressParameters() {
            this(false, null, false, 7, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<BillingAddressParameters> {
                @NotNull
                public final BillingAddressParameters[] newArray(int size) {
                    return new BillingAddressParameters[size];
                }

                @NotNull
                public final BillingAddressParameters createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new BillingAddressParameters(parcel.readInt() != 0, Format.valueOf(parcel.readString()), parcel.readInt() != 0);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$payments_core_release", "()Ljava/lang/String;", "Min", "Full", "payments-core_release"})
        public static final class Format
        extends Enum<Format> {
            @NotNull
            private final String code;
            public static final /* enum */ Format Min = new Format("MIN");
            public static final /* enum */ Format Full = new Format("FULL");
            private static final /* synthetic */ Format[] $VALUES;

            private Format(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode$payments_core_release() {
                return this.code;
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }

            public static Format valueOf(String value) {
                return Enum.valueOf(Format.class, value);
            }

            static {
                $VALUES = formatArray = new Format[]{Format.Min, Format.Full};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u000267BS\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001a\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b!J\u0012\u0010\"\u001a\u0004\u0018\u00010\tH\u00c0\u0003\u00a2\u0006\u0004\b#\u0010\u0014J\u0010\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u0004\u0018\u00010\fH\u00c0\u0003\u00a2\u0006\u0002\b'J^\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010)J\t\u0010*\u001a\u00020\tH\u00d6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u00020\tH\u00d6\u0001J\t\u00100\u001a\u00020\u0003H\u00d6\u0001J\u0019\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\tH\u00d6\u0001R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0018\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00068"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "Landroid/os/Parcelable;", "currencyCode", "", "totalPriceStatus", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "countryCode", "transactionId", "totalPrice", "", "totalPriceLabel", "checkoutOption", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "(Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;)V", "getCheckoutOption$payments_core_release", "()Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "getCountryCode$payments_core_release", "()Ljava/lang/String;", "getCurrencyCode$payments_core_release", "getTotalPrice$payments_core_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTotalPriceLabel$payments_core_release", "getTotalPriceStatus$payments_core_release", "()Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "getTransactionId$payments_core_release", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "component3", "component3$payments_core_release", "component4", "component4$payments_core_release", "component5", "component5$payments_core_release", "component6", "component6$payments_core_release", "component7", "component7$payments_core_release", "copy", "(Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;)Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "CheckoutOption", "TotalPriceStatus", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class TransactionInfo
    implements Parcelable {
        @NotNull
        private final String currencyCode;
        @NotNull
        private final TotalPriceStatus totalPriceStatus;
        @Nullable
        private final String countryCode;
        @Nullable
        private final String transactionId;
        @Nullable
        private final Integer totalPrice;
        @Nullable
        private final String totalPriceLabel;
        @Nullable
        private final CheckoutOption checkoutOption;
        @NotNull
        public static final Parcelable.Creator<TransactionInfo> CREATOR;
        public static final int $stable;

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel, @Nullable CheckoutOption checkoutOption) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this.currencyCode = currencyCode;
            this.totalPriceStatus = totalPriceStatus;
            this.countryCode = countryCode;
            this.transactionId = transactionId;
            this.totalPrice = totalPrice;
            this.totalPriceLabel = totalPriceLabel;
            this.checkoutOption = checkoutOption;
        }

        public /* synthetic */ TransactionInfo(String string, TotalPriceStatus totalPriceStatus, String string2, String string3, Integer n, String string4, CheckoutOption checkoutOption, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                string3 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x20) != 0) {
                string4 = null;
            }
            if ((n2 & 0x40) != 0) {
                checkoutOption = null;
            }
            this(string, totalPriceStatus, string2, string3, n, string4, checkoutOption);
        }

        @NotNull
        public final String getCurrencyCode$payments_core_release() {
            return this.currencyCode;
        }

        @NotNull
        public final TotalPriceStatus getTotalPriceStatus$payments_core_release() {
            return this.totalPriceStatus;
        }

        @Nullable
        public final String getCountryCode$payments_core_release() {
            return this.countryCode;
        }

        @Nullable
        public final String getTransactionId$payments_core_release() {
            return this.transactionId;
        }

        @Nullable
        public final Integer getTotalPrice$payments_core_release() {
            return this.totalPrice;
        }

        @Nullable
        public final String getTotalPriceLabel$payments_core_release() {
            return this.totalPriceLabel;
        }

        @Nullable
        public final CheckoutOption getCheckoutOption$payments_core_release() {
            return this.checkoutOption;
        }

        @NotNull
        public final String component1$payments_core_release() {
            return this.currencyCode;
        }

        @NotNull
        public final TotalPriceStatus component2$payments_core_release() {
            return this.totalPriceStatus;
        }

        @Nullable
        public final String component3$payments_core_release() {
            return this.countryCode;
        }

        @Nullable
        public final String component4$payments_core_release() {
            return this.transactionId;
        }

        @Nullable
        public final Integer component5$payments_core_release() {
            return this.totalPrice;
        }

        @Nullable
        public final String component6$payments_core_release() {
            return this.totalPriceLabel;
        }

        @Nullable
        public final CheckoutOption component7$payments_core_release() {
            return this.checkoutOption;
        }

        @NotNull
        public final TransactionInfo copy(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel, @Nullable CheckoutOption checkoutOption) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            return new TransactionInfo(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, totalPriceLabel, checkoutOption);
        }

        public static /* synthetic */ TransactionInfo copy$default(TransactionInfo transactionInfo, String string, TotalPriceStatus totalPriceStatus, String string2, String string3, Integer n, String string4, CheckoutOption checkoutOption, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = transactionInfo.currencyCode;
            }
            if ((n2 & 2) != 0) {
                totalPriceStatus = transactionInfo.totalPriceStatus;
            }
            if ((n2 & 4) != 0) {
                string2 = transactionInfo.countryCode;
            }
            if ((n2 & 8) != 0) {
                string3 = transactionInfo.transactionId;
            }
            if ((n2 & 0x10) != 0) {
                n = transactionInfo.totalPrice;
            }
            if ((n2 & 0x20) != 0) {
                string4 = transactionInfo.totalPriceLabel;
            }
            if ((n2 & 0x40) != 0) {
                checkoutOption = transactionInfo.checkoutOption;
            }
            return transactionInfo.copy(string, totalPriceStatus, string2, string3, n, string4, checkoutOption);
        }

        @NotNull
        public String toString() {
            return "TransactionInfo(currencyCode=" + this.currencyCode + ", totalPriceStatus=" + (Object)((Object)this.totalPriceStatus) + ", countryCode=" + this.countryCode + ", transactionId=" + this.transactionId + ", totalPrice=" + this.totalPrice + ", totalPriceLabel=" + this.totalPriceLabel + ", checkoutOption=" + (Object)((Object)this.checkoutOption) + ')';
        }

        public int hashCode() {
            int result2 = this.currencyCode.hashCode();
            result2 = result2 * 31 + this.totalPriceStatus.hashCode();
            result2 = result2 * 31 + (this.countryCode == null ? 0 : this.countryCode.hashCode());
            result2 = result2 * 31 + (this.transactionId == null ? 0 : this.transactionId.hashCode());
            result2 = result2 * 31 + (this.totalPrice == null ? 0 : ((Object)this.totalPrice).hashCode());
            result2 = result2 * 31 + (this.totalPriceLabel == null ? 0 : this.totalPriceLabel.hashCode());
            result2 = result2 * 31 + (this.checkoutOption == null ? 0 : this.checkoutOption.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransactionInfo)) {
                return false;
            }
            TransactionInfo transactionInfo = (TransactionInfo)other;
            if (!Intrinsics.areEqual((Object)this.currencyCode, (Object)transactionInfo.currencyCode)) {
                return false;
            }
            if (this.totalPriceStatus != transactionInfo.totalPriceStatus) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.countryCode, (Object)transactionInfo.countryCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.transactionId, (Object)transactionInfo.transactionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalPrice, (Object)transactionInfo.totalPrice)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalPriceLabel, (Object)transactionInfo.totalPriceLabel)) {
                return false;
            }
            return this.checkoutOption == transactionInfo.checkoutOption;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.currencyCode);
            out.writeString(this.totalPriceStatus.name());
            out.writeString(this.countryCode);
            out.writeString(this.transactionId);
            Object object = this.totalPrice;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeInt(((Integer)object).intValue());
            }
            out.writeString(this.totalPriceLabel);
            object = this.checkoutOption;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeString(((Enum)object).name());
            }
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, totalPriceLabel, null, 64, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, null, null, 96, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this(currencyCode, totalPriceStatus, countryCode, transactionId, null, null, null, 112, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this(currencyCode, totalPriceStatus, countryCode, null, null, null, null, 120, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus) {
            Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkNotNullParameter((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this(currencyCode, totalPriceStatus, null, null, null, null, null, 124, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<TransactionInfo> {
                @NotNull
                public final TransactionInfo[] newArray(int size) {
                    return new TransactionInfo[size];
                }

                @NotNull
                public final TransactionInfo createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new TransactionInfo(parcel.readString(), TotalPriceStatus.valueOf(parcel.readString()), parcel.readString(), parcel.readString(), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readString(), parcel.readInt() == 0 ? null : CheckoutOption.valueOf(parcel.readString()));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$payments_core_release", "()Ljava/lang/String;", "NotCurrentlyKnown", "Estimated", "Final", "payments-core_release"})
        public static final class TotalPriceStatus
        extends Enum<TotalPriceStatus> {
            @NotNull
            private final String code;
            public static final /* enum */ TotalPriceStatus NotCurrentlyKnown = new TotalPriceStatus("NOT_CURRENTLY_KNOWN");
            public static final /* enum */ TotalPriceStatus Estimated = new TotalPriceStatus("ESTIMATED");
            public static final /* enum */ TotalPriceStatus Final = new TotalPriceStatus("FINAL");
            private static final /* synthetic */ TotalPriceStatus[] $VALUES;

            private TotalPriceStatus(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode$payments_core_release() {
                return this.code;
            }

            public static TotalPriceStatus[] values() {
                return (TotalPriceStatus[])$VALUES.clone();
            }

            public static TotalPriceStatus valueOf(String value) {
                return Enum.valueOf(TotalPriceStatus.class, value);
            }

            static {
                $VALUES = totalPriceStatusArray = new TotalPriceStatus[]{TotalPriceStatus.NotCurrentlyKnown, TotalPriceStatus.Estimated, TotalPriceStatus.Final};
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$payments_core_release", "()Ljava/lang/String;", "Default", "CompleteImmediatePurchase", "payments-core_release"})
        public static final class CheckoutOption
        extends Enum<CheckoutOption> {
            @NotNull
            private final String code;
            public static final /* enum */ CheckoutOption Default = new CheckoutOption("DEFAULT");
            public static final /* enum */ CheckoutOption CompleteImmediatePurchase = new CheckoutOption("COMPLETE_IMMEDIATE_PURCHASE");
            private static final /* synthetic */ CheckoutOption[] $VALUES;

            private CheckoutOption(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode$payments_core_release() {
                return this.code;
            }

            public static CheckoutOption[] values() {
                return (CheckoutOption[])$VALUES.clone();
            }

            public static CheckoutOption valueOf(String value) {
                return Enum.valueOf(CheckoutOption.class, value);
            }

            static {
                $VALUES = checkoutOptionArray = new CheckoutOption[]{CheckoutOption.Default, CheckoutOption.CompleteImmediatePurchase};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J\u000e\u0010\u0012\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006!"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$ShippingAddressParameters;", "Landroid/os/Parcelable;", "isRequired", "", "allowedCountryCodes", "", "", "phoneNumberRequired", "(ZLjava/util/Set;Z)V", "isRequired$payments_core_release", "()Z", "normalizedAllowedCountryCodes", "getNormalizedAllowedCountryCodes$payments_core_release", "()Ljava/util/Set;", "getPhoneNumberRequired$payments_core_release", "component1", "component1$payments_core_release", "component2", "component3", "component3$payments_core_release", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class ShippingAddressParameters
    implements Parcelable {
        private final boolean isRequired;
        @NotNull
        private final Set<String> allowedCountryCodes;
        private final boolean phoneNumberRequired;
        @NotNull
        public static final Parcelable.Creator<ShippingAddressParameters> CREATOR;
        public static final int $stable;

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired, @NotNull Set<String> allowedCountryCodes, boolean phoneNumberRequired) {
            Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
            this.isRequired = isRequired;
            this.allowedCountryCodes = allowedCountryCodes;
            this.phoneNumberRequired = phoneNumberRequired;
            String[] countryCodes = Locale.getISOCountries();
            Iterable $this$forEach$iv = this.getNormalizedAllowedCountryCodes$payments_core_release();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                String allowedShippingCountryCode;
                block2: {
                    allowedShippingCountryCode = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)countryCodes, (String)"countryCodes");
                    String[] $this$any$iv = countryCodes;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv2;
                        String it = element$iv2 = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)allowedShippingCountryCode, (Object)it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                if (bl) continue;
                boolean bl4 = false;
                String string = '\'' + allowedShippingCountryCode + "' is not a valid country code";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ ShippingAddressParameters(boolean bl, Set set, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(bl, set, bl2);
        }

        public final boolean isRequired$payments_core_release() {
            return this.isRequired;
        }

        public final boolean getPhoneNumberRequired$payments_core_release() {
            return this.phoneNumberRequired;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getNormalizedAllowedCountryCodes$payments_core_release() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.allowedCountryCodes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                collection.add(string2);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public final boolean component1$payments_core_release() {
            return this.isRequired;
        }

        private final Set<String> component2() {
            return this.allowedCountryCodes;
        }

        public final boolean component3$payments_core_release() {
            return this.phoneNumberRequired;
        }

        @NotNull
        public final ShippingAddressParameters copy(boolean isRequired, @NotNull Set<String> allowedCountryCodes, boolean phoneNumberRequired) {
            Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
            return new ShippingAddressParameters(isRequired, allowedCountryCodes, phoneNumberRequired);
        }

        public static /* synthetic */ ShippingAddressParameters copy$default(ShippingAddressParameters shippingAddressParameters, boolean bl, Set set, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = shippingAddressParameters.isRequired;
            }
            if ((n & 2) != 0) {
                set = shippingAddressParameters.allowedCountryCodes;
            }
            if ((n & 4) != 0) {
                bl2 = shippingAddressParameters.phoneNumberRequired;
            }
            return shippingAddressParameters.copy(bl, set, bl2);
        }

        @NotNull
        public String toString() {
            return "ShippingAddressParameters(isRequired=" + this.isRequired + ", allowedCountryCodes=" + this.allowedCountryCodes + ", phoneNumberRequired=" + this.phoneNumberRequired + ')';
        }

        public int hashCode() {
            int n = this.isRequired ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + ((Object)this.allowedCountryCodes).hashCode();
            int n2 = this.phoneNumberRequired ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShippingAddressParameters)) {
                return false;
            }
            ShippingAddressParameters shippingAddressParameters = (ShippingAddressParameters)other;
            if (this.isRequired != shippingAddressParameters.isRequired) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allowedCountryCodes, shippingAddressParameters.allowedCountryCodes)) {
                return false;
            }
            return this.phoneNumberRequired == shippingAddressParameters.phoneNumberRequired;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.isRequired ? 1 : 0);
            Set<String> set = this.allowedCountryCodes;
            out.writeInt(set.size());
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                out.writeString(iterator.next());
            }
            out.writeInt(this.phoneNumberRequired ? 1 : 0);
        }

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired, @NotNull Set<String> allowedCountryCodes) {
            Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
            this(isRequired, allowedCountryCodes, false, 4, null);
        }

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired) {
            this(isRequired, null, false, 6, null);
        }

        @JvmOverloads
        public ShippingAddressParameters() {
            this(false, null, false, 7, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<ShippingAddressParameters> {
                @NotNull
                public final ShippingAddressParameters[] newArray(int size) {
                    return new ShippingAddressParameters[size];
                }

                @NotNull
                public final ShippingAddressParameters createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
                    boolean bl = parcel.readInt() != 0;
                    for (int i = 0; i != n; ++i) {
                        linkedHashSet.add(parcel.readString());
                    }
                    boolean bl2 = parcel.readInt() != 0;
                    Set set = linkedHashSet;
                    boolean bl3 = bl;
                    return new ShippingAddressParameters(bl3, set, bl2);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$MerchantInfo;", "Landroid/os/Parcelable;", "merchantName", "", "(Ljava/lang/String;)V", "getMerchantName$payments_core_release", "()Ljava/lang/String;", "component1", "component1$payments_core_release", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class MerchantInfo
    implements Parcelable {
        @Nullable
        private final String merchantName;
        @NotNull
        public static final Parcelable.Creator<MerchantInfo> CREATOR;
        public static final int $stable;

        public MerchantInfo(@Nullable String merchantName) {
            this.merchantName = merchantName;
        }

        public /* synthetic */ MerchantInfo(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getMerchantName$payments_core_release() {
            return this.merchantName;
        }

        @Nullable
        public final String component1$payments_core_release() {
            return this.merchantName;
        }

        @NotNull
        public final MerchantInfo copy(@Nullable String merchantName) {
            return new MerchantInfo(merchantName);
        }

        public static /* synthetic */ MerchantInfo copy$default(MerchantInfo merchantInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = merchantInfo.merchantName;
            }
            return merchantInfo.copy(string);
        }

        @NotNull
        public String toString() {
            return "MerchantInfo(merchantName=" + this.merchantName + ')';
        }

        public int hashCode() {
            return this.merchantName == null ? 0 : this.merchantName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MerchantInfo)) {
                return false;
            }
            MerchantInfo merchantInfo = (MerchantInfo)other;
            return Intrinsics.areEqual((Object)this.merchantName, (Object)merchantInfo.merchantName);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.merchantName);
        }

        public MerchantInfo() {
            this(null, 1, null);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<MerchantInfo> {
                @NotNull
                public final MerchantInfo[] newArray(int size) {
                    return new MerchantInfo[size];
                }

                @NotNull
                public final MerchantInfo createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new MerchantInfo(parcel.readString());
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$Companion;", "", "()V", "ALLOWED_AUTH_METHODS", "", "", "API_VERSION", "", "API_VERSION_MINOR", "CARD_PAYMENT_METHOD", "DEFAULT_CARD_NETWORKS", "JCB_CARD_NETWORK", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

