/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.DefaultFraudDetectionDataRepository;
import com.stripe.android.core.ApiKeyValidator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/PaymentConfiguration;", "Landroid/os/Parcelable;", "publishableKey", "", "stripeAccountId", "(Ljava/lang/String;Ljava/lang/String;)V", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Store", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class PaymentConfiguration
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String publishableKey;
    @Nullable
    private final String stripeAccountId;
    @NotNull
    public static final Parcelable.Creator<PaymentConfiguration> CREATOR;
    public static final int $stable;
    @Nullable
    private static PaymentConfiguration instance;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PaymentConfiguration(@NotNull String publishableKey2, @Nullable String stripeAccountId2) {
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        this.publishableKey = publishableKey2;
        this.stripeAccountId = stripeAccountId2;
        ApiKeyValidator.Companion.get().requireValid(this.publishableKey);
    }

    public /* synthetic */ PaymentConfiguration(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getPublishableKey() {
        return this.publishableKey;
    }

    @Nullable
    public final String getStripeAccountId() {
        return this.stripeAccountId;
    }

    @NotNull
    public final String component1() {
        return this.publishableKey;
    }

    @Nullable
    public final String component2() {
        return this.stripeAccountId;
    }

    @NotNull
    public final PaymentConfiguration copy(@NotNull String publishableKey2, @Nullable String stripeAccountId2) {
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        return new PaymentConfiguration(publishableKey2, stripeAccountId2);
    }

    public static /* synthetic */ PaymentConfiguration copy$default(PaymentConfiguration paymentConfiguration, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = paymentConfiguration.publishableKey;
        }
        if ((n & 2) != 0) {
            string2 = paymentConfiguration.stripeAccountId;
        }
        return paymentConfiguration.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "PaymentConfiguration(publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ')';
    }

    public int hashCode() {
        int result2 = this.publishableKey.hashCode();
        result2 = result2 * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentConfiguration)) {
            return false;
        }
        PaymentConfiguration paymentConfiguration = (PaymentConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)paymentConfiguration.publishableKey)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stripeAccountId, (Object)paymentConfiguration.stripeAccountId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.publishableKey);
        out.writeString(this.stripeAccountId);
    }

    @JvmStatic
    @NotNull
    public static final PaymentConfiguration getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Context context, @NotNull String publishableKey2, @Nullable String stripeAccountId2) {
        Companion.init(context, publishableKey2, stripeAccountId2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Context context, @NotNull String publishableKey2) {
        Companion.init(context, publishableKey2);
    }

    static {
        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentConfiguration> {
            @NotNull
            public final PaymentConfiguration[] newArray(int size) {
                return new PaymentConfiguration[size];
            }

            @NotNull
            public final PaymentConfiguration createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new PaymentConfiguration(parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/PaymentConfiguration$Store;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "prefs", "Landroid/content/SharedPreferences;", "load", "Lcom/stripe/android/PaymentConfiguration;", "load$payments_core_release", "save", "", "publishableKey", "", "stripeAccountId", "Companion", "payments-core_release"})
    private static final class Store {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final SharedPreferences prefs;
        @Deprecated
        private static final String NAME = PaymentConfiguration.class.getCanonicalName();
        @Deprecated
        @NotNull
        private static final String KEY_PUBLISHABLE_KEY = "key_publishable_key";
        @Deprecated
        @NotNull
        private static final String KEY_ACCOUNT_ID = "key_account_id";

        public Store(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.applicationConte\u2026haredPreferences(NAME, 0)");
            this.prefs = sharedPreferences;
        }

        public final /* synthetic */ void save(String publishableKey2, String stripeAccountId2) {
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            this.prefs.edit().putString(KEY_PUBLISHABLE_KEY, publishableKey2).putString(KEY_ACCOUNT_ID, stripeAccountId2).apply();
        }

        public final /* synthetic */ PaymentConfiguration load$payments_core_release() {
            PaymentConfiguration paymentConfiguration;
            String string = this.prefs.getString(KEY_PUBLISHABLE_KEY, null);
            if (string != null) {
                String publishableKey2 = string;
                boolean bl = false;
                paymentConfiguration = new PaymentConfiguration(publishableKey2, this.prefs.getString(KEY_ACCOUNT_ID, null));
            } else {
                paymentConfiguration = null;
            }
            return paymentConfiguration;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/PaymentConfiguration$Store$Companion;", "", "()V", "KEY_ACCOUNT_ID", "", "KEY_PUBLISHABLE_KEY", "NAME", "kotlin.jvm.PlatformType", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J$\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/PaymentConfiguration$Companion;", "", "()V", "instance", "Lcom/stripe/android/PaymentConfiguration;", "clearInstance", "", "getInstance", "context", "Landroid/content/Context;", "init", "publishableKey", "", "stripeAccountId", "loadInstance", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PaymentConfiguration getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PaymentConfiguration paymentConfiguration = instance;
            if (paymentConfiguration == null) {
                paymentConfiguration = this.loadInstance(context);
            }
            return paymentConfiguration;
        }

        /*
         * WARNING - void declaration
         */
        private final PaymentConfiguration loadInstance(Context context) {
            void var2_2;
            PaymentConfiguration paymentConfiguration = new Store(context).load$payments_core_release();
            if (paymentConfiguration == null) {
                throw new IllegalStateException("PaymentConfiguration was not initialized. Call PaymentConfiguration.init().");
            }
            PaymentConfiguration it = paymentConfiguration;
            boolean bl = false;
            instance = it;
            return var2_2;
        }

        @JvmStatic
        @JvmOverloads
        public final void init(@NotNull Context context, @NotNull String publishableKey2, @Nullable String stripeAccountId2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            instance = new PaymentConfiguration(publishableKey2, stripeAccountId2);
            new Store(context).save(publishableKey2, stripeAccountId2);
            new DefaultFraudDetectionDataRepository(context, null, 2, null).refresh();
        }

        public static /* synthetic */ void init$default(Companion companion, Context context, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            companion.init(context, string, string2);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final /* synthetic */ void clearInstance() {
            instance = null;
        }

        @JvmStatic
        @JvmOverloads
        public final void init(@NotNull Context context, @NotNull String publishableKey2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            com.stripe.android.PaymentConfiguration$Companion.init$default(this, context, publishableKey2, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

