/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepaylauncher;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.savedstate.SavedStateRegistryOwner;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.stripe.android.GooglePayJsonFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.injection.InjectWithFallbackKt;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.googlepaylauncher.ConvertKt;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncher;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherContract;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherViewModel;
import com.stripe.android.googlepaylauncher.GooglePayRepository;
import com.stripe.android.googlepaylauncher.injection.DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent;
import com.stripe.android.googlepaylauncher.injection.GooglePayPaymentMethodLauncherViewModelSubcomponent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.networking.StripeRepository;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 02\u00020\u0001:\u000201B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0007J\u0019\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b+J\u0011\u0010,\u001a\u00020\u001aH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0013R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00130\u00130\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "paymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContract$Args;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "googlePayJsonFactory", "Lcom/stripe/android/GooglePayJsonFactory;", "googlePayRepository", "Lcom/stripe/android/googlepaylauncher/GooglePayRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/google/android/gms/wallet/PaymentsClient;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContract$Args;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/GooglePayJsonFactory;Lcom/stripe/android/googlepaylauncher/GooglePayRepository;Landroidx/lifecycle/SavedStateHandle;)V", "_googleResult", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Result;", "googlePayResult", "Landroidx/lifecycle/LiveData;", "kotlin.jvm.PlatformType", "getGooglePayResult$payments_core_release", "()Landroidx/lifecycle/LiveData;", "value", "", "hasLaunched", "getHasLaunched$payments_core_release", "()Z", "setHasLaunched$payments_core_release", "(Z)V", "createLoadPaymentDataTask", "Lcom/google/android/gms/tasks/Task;", "Lcom/google/android/gms/wallet/PaymentData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPaymentDataRequest", "Lorg/json/JSONObject;", "createPaymentMethod", "paymentData", "(Lcom/google/android/gms/wallet/PaymentData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTransactionInfo", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "createTransactionInfo$payments_core_release", "isReadyToPay", "updateResult", "", "result", "Companion", "Factory", "payments-core_release"})
public final class GooglePayPaymentMethodLauncherViewModel
extends ViewModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentsClient paymentsClient;
    @NotNull
    private final ApiRequest.Options requestOptions;
    @NotNull
    private final GooglePayPaymentMethodLauncherContract.Args args;
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final GooglePayJsonFactory googlePayJsonFactory;
    @NotNull
    private final GooglePayRepository googlePayRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final MutableLiveData<GooglePayPaymentMethodLauncher.Result> _googleResult;
    @NotNull
    private final LiveData<GooglePayPaymentMethodLauncher.Result> googlePayResult;
    @Deprecated
    @NotNull
    private static final String HAS_LAUNCHED_KEY = "has_launched";

    @Inject
    public GooglePayPaymentMethodLauncherViewModel(@NotNull PaymentsClient paymentsClient2, @NotNull ApiRequest.Options requestOptions, @NotNull GooglePayPaymentMethodLauncherContract.Args args2, @NotNull StripeRepository stripeRepository2, @NotNull GooglePayJsonFactory googlePayJsonFactory, @NotNull GooglePayRepository googlePayRepository, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)paymentsClient2, (String)"paymentsClient");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)googlePayJsonFactory, (String)"googlePayJsonFactory");
        Intrinsics.checkNotNullParameter((Object)googlePayRepository, (String)"googlePayRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.paymentsClient = paymentsClient2;
        this.requestOptions = requestOptions;
        this.args = args2;
        this.stripeRepository = stripeRepository2;
        this.googlePayJsonFactory = googlePayJsonFactory;
        this.googlePayRepository = googlePayRepository;
        this.savedStateHandle = savedStateHandle;
        this._googleResult = new MutableLiveData();
        LiveData $this$distinctUntilChanged$iv = (LiveData)this._googleResult;
        boolean $i$f$distinctUntilChanged = false;
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)$this$distinctUntilChanged$iv);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"distinctUntilChanged(this)");
        this.googlePayResult = liveData;
    }

    public final boolean getHasLaunched$payments_core_release() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(HAS_LAUNCHED_KEY), (Object)true);
    }

    public final void setHasLaunched$payments_core_release(boolean value) {
        this.savedStateHandle.set(HAS_LAUNCHED_KEY, (Object)value);
    }

    @NotNull
    public final LiveData<GooglePayPaymentMethodLauncher.Result> getGooglePayResult$payments_core_release() {
        return this.googlePayResult;
    }

    public final void updateResult(@NotNull GooglePayPaymentMethodLauncher.Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this._googleResult.setValue((Object)result2);
    }

    @VisibleForTesting
    @Nullable
    public final Object isReadyToPay(@NotNull Continuation<? super Boolean> $completion) {
        return FlowKt.first(this.googlePayRepository.isReady(), $completion);
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject createPaymentDataRequest() {
        GooglePayJsonFactory googlePayJsonFactory = this.googlePayJsonFactory;
        GooglePayJsonFactory.TransactionInfo transactionInfo = this.createTransactionInfo$payments_core_release(this.args);
        GooglePayJsonFactory.MerchantInfo merchantInfo = new GooglePayJsonFactory.MerchantInfo(this.args.getConfig$payments_core_release().getMerchantName());
        GooglePayJsonFactory.BillingAddressParameters billingAddressParameters = ConvertKt.convert(this.args.getConfig$payments_core_release().getBillingAddressConfig());
        boolean bl = this.args.getConfig$payments_core_release().isEmailRequired();
        boolean bl2 = this.args.getConfig$payments_core_release().getAllowCreditCards();
        return GooglePayJsonFactory.createPaymentDataRequest$default(googlePayJsonFactory, transactionInfo, billingAddressParameters, null, bl, merchantInfo, bl2, 4, null);
    }

    @VisibleForTesting
    @NotNull
    public final GooglePayJsonFactory.TransactionInfo createTransactionInfo$payments_core_release(@NotNull GooglePayPaymentMethodLauncherContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        return new GooglePayJsonFactory.TransactionInfo(args2.getCurrencyCode$payments_core_release(), GooglePayJsonFactory.TransactionInfo.TotalPriceStatus.Estimated, args2.getConfig$payments_core_release().getMerchantCountryCode(), args2.getTransactionId$payments_core_release(), args2.getAmount$payments_core_release(), null, GooglePayJsonFactory.TransactionInfo.CheckoutOption.Default, 32, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createLoadPaymentDataTask(@NotNull Continuation<? super Task<PaymentData>> var1_1) {
        if (!(var1_1 instanceof createLoadPaymentDataTask.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createLoadPaymentDataTask((Continuation<? super Task<PaymentData>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.isReadyToPay((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GooglePayPaymentMethodLauncherViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    $i$a$-check-GooglePayPaymentMethodLauncherViewModel$createLoadPaymentDataTask$2 = false;
                    var2_6 = "Google Pay is unavailable.";
                    throw new IllegalStateException(var2_6.toString());
                }
                v1 = this.paymentsClient.loadPaymentData(PaymentDataRequest.fromJson((String)this.createPaymentDataRequest().toString()));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"paymentsClient.loadPayme\u2026t().toString())\n        )");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object createPaymentMethod(@NotNull PaymentData var1_1, @NotNull Continuation<? super GooglePayPaymentMethodLauncher.Result> var2_2) {
        if (!(var2_2 instanceof createPaymentMethod.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createPaymentMethod(null, (Continuation<? super GooglePayPaymentMethodLauncher.Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                paymentDataJson = new JSONObject(paymentData.toJson());
                params = PaymentMethodCreateParams.Companion.createFromGooglePay(paymentDataJson);
                var5_8 /* !! */  = this;
                $this$createPaymentMethod_u24lambda_u2d1 /* !! */  = (GooglePayPaymentMethodLauncherViewModel)var5_8 /* !! */ ;
                $i$a$-runCatching-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2 = false;
                $continuation.label = 1;
                v0 = $this$createPaymentMethod_u24lambda_u2d1 /* !! */ .stripeRepository.createPaymentMethod(params, $this$createPaymentMethod_u24lambda_u2d1 /* !! */ .requestOptions, (Continuation<? super PaymentMethod>)$continuation);
                ** if (v0 != var11_5) goto lbl25
lbl24:
                // 1 sources

                return var11_5;
lbl25:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                $i$a$-runCatching-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2 = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    if (v0 == null) {
                        var8_12 = "Required value was null.";
                        throw new IllegalArgumentException(var8_12.toString());
                    }
                    $this$createPaymentMethod_u24lambda_u2d1 /* !! */  = Result.constructor-impl((Object)((PaymentMethod)v0));
                }
                catch (Throwable $i$a$-runCatching-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2) {
                    $this$createPaymentMethod_u24lambda_u2d1 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2));
                }
                var5_8 /* !! */  = $this$createPaymentMethod_u24lambda_u2d1 /* !! */ ;
                v1 = Result.exceptionOrNull-impl((Object)var5_8 /* !! */ );
                if (v1 == null) {
                    it = (PaymentMethod)var5_8 /* !! */ ;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$3 = false;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Completed((PaymentMethod)it);
                } else {
                    it = v1;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$4 = false;
                    var8_13 = it;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Failed((Throwable)it, var8_13 instanceof APIConnectionException != false ? 3 : (var8_13 instanceof InvalidRequestException != false ? 2 : 1));
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001 B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ7\u0010\u0013\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "Lcom/stripe/android/core/injection/Injectable;", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Factory$FallbackInjectionParams;", "application", "Landroid/app/Application;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContract$Args;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "defaultArgs", "Landroid/os/Bundle;", "(Landroid/app/Application;Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContract$Args;Landroidx/savedstate/SavedStateRegistryOwner;Landroid/os/Bundle;)V", "subComponentBuilder", "Lcom/stripe/android/googlepaylauncher/injection/GooglePayPaymentMethodLauncherViewModelSubcomponent$Builder;", "getSubComponentBuilder", "()Lcom/stripe/android/googlepaylauncher/injection/GooglePayPaymentMethodLauncherViewModelSubcomponent$Builder;", "setSubComponentBuilder", "(Lcom/stripe/android/googlepaylauncher/injection/GooglePayPaymentMethodLauncherViewModelSubcomponent$Builder;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "fallbackInitialize", "", "arg", "FallbackInjectionParams", "payments-core_release"})
    public static final class Factory
    extends AbstractSavedStateViewModelFactory
    implements Injectable<FallbackInjectionParams> {
        @NotNull
        private final Application application;
        @NotNull
        private final GooglePayPaymentMethodLauncherContract.Args args;
        @Inject
        public GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder subComponentBuilder;

        public Factory(@NotNull Application application, @NotNull GooglePayPaymentMethodLauncherContract.Args args2, @NotNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, defaultArgs);
            this.application = application;
            this.args = args2;
        }

        public /* synthetic */ Factory(Application application, GooglePayPaymentMethodLauncherContract.Args args2, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bundle = null;
            }
            this(application, args2, savedStateRegistryOwner, bundle);
        }

        @NotNull
        public final GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder getSubComponentBuilder() {
            GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder builder = this.subComponentBuilder;
            if (builder != null) {
                return builder;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subComponentBuilder");
            return null;
        }

        public final void setSubComponentBuilder(@NotNull GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.subComponentBuilder = builder;
        }

        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle savedStateHandle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
            Injectable injectable = this;
            GooglePayPaymentMethodLauncherContract.Args.InjectionParams injectionParams = this.args.getInjectionParams$payments_core_release();
            String string = injectionParams != null ? injectionParams.getInjectorKey() : null;
            GooglePayPaymentMethodLauncherContract.Args.InjectionParams injectionParams2 = this.args.getInjectionParams$payments_core_release();
            boolean bl = injectionParams2 != null ? injectionParams2.getEnableLogging() : false;
            Object object = this.args.getInjectionParams$payments_core_release();
            if (object == null || (object = ((GooglePayPaymentMethodLauncherContract.Args.InjectionParams)object).getPublishableKey()) == null) {
                object = PaymentConfiguration.Companion.getInstance((Context)this.application).getPublishableKey();
            }
            String string2 = this.args.getInjectionParams$payments_core_release() != null ? this.args.getInjectionParams$payments_core_release().getStripeAccountId() : PaymentConfiguration.Companion.getInstance((Context)this.application).getStripeAccountId();
            Object object2 = this.args.getInjectionParams$payments_core_release();
            if (object2 == null || (object2 = ((GooglePayPaymentMethodLauncherContract.Args.InjectionParams)object2).getProductUsage()) == null) {
                object2 = SetsKt.setOf((Object)"GooglePayPaymentMethodLauncher");
            }
            InjectWithFallbackKt.injectWithFallback((Injectable)injectable, (String)string, (Object)new FallbackInjectionParams(this.application, bl, (String)object, string2, (Set<String>)object2));
            return (T)((Object)this.getSubComponentBuilder().args(this.args).savedStateHandle(savedStateHandle).build().getViewModel());
        }

        public void fallbackInitialize(@NotNull FallbackInjectionParams arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent.builder().context((Context)arg.getApplication()).enableLogging(arg.getEnableLogging()).publishableKeyProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInjectionParams $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$arg.getPublishableKey();
                }
            })).stripeAccountIdProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInjectionParams $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return this.$arg.getStripeAccountId();
                }
            })).productUsage(arg.getProductUsage()).googlePayConfig(this.args.getConfig$payments_core_release()).build().inject(this);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Factory$FallbackInjectionParams;", "", "application", "Landroid/app/Application;", "enableLogging", "", "publishableKey", "", "stripeAccountId", "productUsage", "", "(Landroid/app/Application;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getApplication", "()Landroid/app/Application;", "getEnableLogging", "()Z", "getProductUsage", "()Ljava/util/Set;", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "payments-core_release"})
        public static final class FallbackInjectionParams {
            @NotNull
            private final Application application;
            private final boolean enableLogging;
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final Set<String> productUsage;

            public FallbackInjectionParams(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                this.application = application;
                this.enableLogging = enableLogging;
                this.publishableKey = publishableKey2;
                this.stripeAccountId = stripeAccountId2;
                this.productUsage = productUsage;
            }

            @NotNull
            public final Application getApplication() {
                return this.application;
            }

            public final boolean getEnableLogging() {
                return this.enableLogging;
            }

            @NotNull
            public final String getPublishableKey() {
                return this.publishableKey;
            }

            @Nullable
            public final String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> getProductUsage() {
                return this.productUsage;
            }

            @NotNull
            public final Application component1() {
                return this.application;
            }

            public final boolean component2() {
                return this.enableLogging;
            }

            @NotNull
            public final String component3() {
                return this.publishableKey;
            }

            @Nullable
            public final String component4() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> component5() {
                return this.productUsage;
            }

            @NotNull
            public final FallbackInjectionParams copy(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                return new FallbackInjectionParams(application, enableLogging, publishableKey2, stripeAccountId2, productUsage);
            }

            public static /* synthetic */ FallbackInjectionParams copy$default(FallbackInjectionParams fallbackInjectionParams, Application application, boolean bl, String string, String string2, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    application = fallbackInjectionParams.application;
                }
                if ((n & 2) != 0) {
                    bl = fallbackInjectionParams.enableLogging;
                }
                if ((n & 4) != 0) {
                    string = fallbackInjectionParams.publishableKey;
                }
                if ((n & 8) != 0) {
                    string2 = fallbackInjectionParams.stripeAccountId;
                }
                if ((n & 0x10) != 0) {
                    set = fallbackInjectionParams.productUsage;
                }
                return fallbackInjectionParams.copy(application, bl, string, string2, set);
            }

            @NotNull
            public String toString() {
                return "FallbackInjectionParams(application=" + this.application + ", enableLogging=" + this.enableLogging + ", publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", productUsage=" + this.productUsage + ')';
            }

            public int hashCode() {
                int result2 = this.application.hashCode();
                int n = this.enableLogging ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                result2 = result2 * 31 + this.publishableKey.hashCode();
                result2 = result2 * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result2 = result2 * 31 + ((Object)this.productUsage).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FallbackInjectionParams)) {
                    return false;
                }
                FallbackInjectionParams fallbackInjectionParams = (FallbackInjectionParams)other;
                if (!Intrinsics.areEqual((Object)this.application, (Object)fallbackInjectionParams.application)) {
                    return false;
                }
                if (this.enableLogging != fallbackInjectionParams.enableLogging) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)fallbackInjectionParams.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)fallbackInjectionParams.stripeAccountId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.productUsage, fallbackInjectionParams.productUsage);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Companion;", "", "()V", "HAS_LAUNCHED_KEY", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

