/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.LuxeActionCreatorForStatus;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\t\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u0005j\u0002`\nH\u0001\u00a2\u0006\u0002\b\u001bJ!\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u001fH\u0000\u00a2\u0006\u0002\b R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository;", "", "()V", "codeToNextActionSpec", "", "", "Lcom/stripe/android/model/LuxeNextActionRepository$LuxeAction;", "getAction", "Lcom/stripe/android/model/LuxeNextActionRepository$Result;", "lpmCode", "Lcom/stripe/android/model/PaymentMethodCode;", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "stripeIntentJson", "Lorg/json/JSONObject;", "getAction$payments_core_release", "getActionCreator", "Lcom/stripe/android/model/LuxeActionCreatorForStatus;", "getPostAuthorizeIntentOutcome", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "getPostAuthorizeIntentOutcome$payments_core_release", "(Lcom/stripe/android/model/StripeIntent;)Ljava/lang/Integer;", "isPresent", "", "code", "isPresent$payments_core_release", "update", "", "additionalData", "", "update$payments_core_release", "Companion", "LuxeAction", "Result", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@StabilityInferred(parameters=0)
public final class LuxeNextActionRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, LuxeAction> codeToNextActionSpec = new LinkedHashMap();
    public static final int $stable = 8;
    @NotNull
    private static final LuxeNextActionRepository Instance = new LuxeNextActionRepository();

    public final void update$payments_core_release(@NotNull Map<String, LuxeAction> additionalData) {
        Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
        this.codeToNextActionSpec.putAll(additionalData);
    }

    @VisibleForTesting
    public final boolean isPresent$payments_core_release(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.codeToNextActionSpec.containsKey(code);
    }

    @Nullable
    public final Integer getPostAuthorizeIntentOutcome$payments_core_release(@NotNull StripeIntent stripeIntent) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        if (stripeIntent.requiresAction() && stripeIntent.getNextActionData() == null) {
            n = 2;
        } else {
            Map<Object, Object> map = this.codeToNextActionSpec;
            PaymentMethod paymentMethod = stripeIntent.getPaymentMethod();
            LuxeAction luxeAction = map.get(paymentMethod != null ? paymentMethod.code : null);
            n = luxeAction != null && (map = luxeAction.getPostAuthorizeIntentStatus()) != null ? (Integer)map.get((Object)stripeIntent.getStatus()) : null;
        }
        return n;
    }

    @NotNull
    public final Result getAction$payments_core_release(@Nullable String lpmCode, @Nullable StripeIntent.Status status, @NotNull JSONObject stripeIntentJson) {
        Result result2;
        LuxeActionCreatorForStatus.ActionCreator actionCreator;
        Intrinsics.checkNotNullParameter((Object)stripeIntentJson, (String)"stripeIntentJson");
        LuxeActionCreatorForStatus luxeActionCreatorForStatus = this.getActionCreator(lpmCode, status);
        return luxeActionCreatorForStatus != null && (actionCreator = luxeActionCreatorForStatus.getActionCreator()) != null && (result2 = actionCreator.create$payments_core_release(stripeIntentJson)) != null ? result2 : (Result)Result.NotSupported.INSTANCE;
    }

    private final LuxeActionCreatorForStatus getActionCreator(String lpmCode, StripeIntent.Status status) {
        LuxeActionCreatorForStatus luxeActionCreatorForStatus;
        LuxeAction luxeAction = this.codeToNextActionSpec.get(lpmCode);
        LuxeActionCreatorForStatus it = luxeActionCreatorForStatus = luxeAction != null ? luxeAction.getPostConfirmStatusNextStatus() : null;
        boolean bl = false;
        LuxeActionCreatorForStatus luxeActionCreatorForStatus2 = it;
        return (luxeActionCreatorForStatus2 != null ? luxeActionCreatorForStatus2.getStatus() : null) == status ? luxeActionCreatorForStatus : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$Companion;", "", "()V", "Instance", "Lcom/stripe/android/model/LuxeNextActionRepository;", "getInstance", "()Lcom/stripe/android/model/LuxeNextActionRepository;", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LuxeNextActionRepository getInstance() {
            return Instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$LuxeAction;", "", "postConfirmStatusNextStatus", "Lcom/stripe/android/model/LuxeActionCreatorForStatus;", "postAuthorizeIntentStatus", "", "Lcom/stripe/android/model/StripeIntent$Status;", "", "(Lcom/stripe/android/model/LuxeActionCreatorForStatus;Ljava/util/Map;)V", "getPostAuthorizeIntentStatus", "()Ljava/util/Map;", "getPostConfirmStatusNextStatus", "()Lcom/stripe/android/model/LuxeActionCreatorForStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "payments-core_release"})
    public static final class LuxeAction {
        @Nullable
        private final LuxeActionCreatorForStatus postConfirmStatusNextStatus;
        @NotNull
        private final Map<StripeIntent.Status, Integer> postAuthorizeIntentStatus;

        public LuxeAction(@Nullable LuxeActionCreatorForStatus postConfirmStatusNextStatus, @NotNull Map<StripeIntent.Status, Integer> postAuthorizeIntentStatus) {
            Intrinsics.checkNotNullParameter(postAuthorizeIntentStatus, (String)"postAuthorizeIntentStatus");
            this.postConfirmStatusNextStatus = postConfirmStatusNextStatus;
            this.postAuthorizeIntentStatus = postAuthorizeIntentStatus;
        }

        @Nullable
        public final LuxeActionCreatorForStatus getPostConfirmStatusNextStatus() {
            return this.postConfirmStatusNextStatus;
        }

        @NotNull
        public final Map<StripeIntent.Status, Integer> getPostAuthorizeIntentStatus() {
            return this.postAuthorizeIntentStatus;
        }

        @Nullable
        public final LuxeActionCreatorForStatus component1() {
            return this.postConfirmStatusNextStatus;
        }

        @NotNull
        public final Map<StripeIntent.Status, Integer> component2() {
            return this.postAuthorizeIntentStatus;
        }

        @NotNull
        public final LuxeAction copy(@Nullable LuxeActionCreatorForStatus postConfirmStatusNextStatus, @NotNull Map<StripeIntent.Status, Integer> postAuthorizeIntentStatus) {
            Intrinsics.checkNotNullParameter(postAuthorizeIntentStatus, (String)"postAuthorizeIntentStatus");
            return new LuxeAction(postConfirmStatusNextStatus, postAuthorizeIntentStatus);
        }

        public static /* synthetic */ LuxeAction copy$default(LuxeAction luxeAction, LuxeActionCreatorForStatus luxeActionCreatorForStatus, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                luxeActionCreatorForStatus = luxeAction.postConfirmStatusNextStatus;
            }
            if ((n & 2) != 0) {
                map = luxeAction.postAuthorizeIntentStatus;
            }
            return luxeAction.copy(luxeActionCreatorForStatus, map);
        }

        @NotNull
        public String toString() {
            return "LuxeAction(postConfirmStatusNextStatus=" + this.postConfirmStatusNextStatus + ", postAuthorizeIntentStatus=" + this.postAuthorizeIntentStatus + ')';
        }

        public int hashCode() {
            int result2 = this.postConfirmStatusNextStatus == null ? 0 : this.postConfirmStatusNextStatus.hashCode();
            result2 = result2 * 31 + ((Object)this.postAuthorizeIntentStatus).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LuxeAction)) {
                return false;
            }
            LuxeAction luxeAction = (LuxeAction)other;
            if (!Intrinsics.areEqual((Object)this.postConfirmStatusNextStatus, (Object)luxeAction.postConfirmStatusNextStatus)) {
                return false;
            }
            return Intrinsics.areEqual(this.postAuthorizeIntentStatus, luxeAction.postAuthorizeIntentStatus);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$Result;", "", "()V", "Action", "NoAction", "NotSupported", "Lcom/stripe/android/model/LuxeNextActionRepository$Result$Action;", "Lcom/stripe/android/model/LuxeNextActionRepository$Result$NoAction;", "Lcom/stripe/android/model/LuxeNextActionRepository$Result$NotSupported;", "payments-core_release"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$Result$Action;", "Lcom/stripe/android/model/LuxeNextActionRepository$Result;", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "(Lcom/stripe/android/model/StripeIntent$NextActionData;)V", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class Action
        extends Result {
            @NotNull
            private final StripeIntent.NextActionData nextActionData;
            public static final int $stable;

            public Action(@NotNull StripeIntent.NextActionData nextActionData) {
                Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
                super(null);
                this.nextActionData = nextActionData;
            }

            @NotNull
            public final StripeIntent.NextActionData getNextActionData() {
                return this.nextActionData;
            }

            @NotNull
            public final StripeIntent.NextActionData component1() {
                return this.nextActionData;
            }

            @NotNull
            public final Action copy(@NotNull StripeIntent.NextActionData nextActionData) {
                Intrinsics.checkNotNullParameter((Object)nextActionData, (String)"nextActionData");
                return new Action(nextActionData);
            }

            public static /* synthetic */ Action copy$default(Action action, StripeIntent.NextActionData nextActionData, int n, Object object) {
                if ((n & 1) != 0) {
                    nextActionData = action.nextActionData;
                }
                return action.copy(nextActionData);
            }

            @NotNull
            public String toString() {
                return "Action(nextActionData=" + this.nextActionData + ')';
            }

            public int hashCode() {
                return this.nextActionData.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Action)) {
                    return false;
                }
                Action action = (Action)other;
                return Intrinsics.areEqual((Object)this.nextActionData, (Object)action.nextActionData);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$Result$NoAction;", "Lcom/stripe/android/model/LuxeNextActionRepository$Result;", "()V", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class NoAction
        extends Result {
            @NotNull
            public static final NoAction INSTANCE = new NoAction();
            public static final int $stable;

            private NoAction() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/LuxeNextActionRepository$Result$NotSupported;", "Lcom/stripe/android/model/LuxeNextActionRepository$Result;", "()V", "payments-core_release"})
        @StabilityInferred(parameters=0)
        public static final class NotSupported
        extends Result {
            @NotNull
            public static final NotSupported INSTANCE = new NotSupported();
            public static final int $stable;

            private NotSupported() {
                super(null);
            }
        }
    }
}

